/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.pool;

import de.intarsys.tools.pool.IPool;
import de.intarsys.tools.pool.IPoolObjectFactory;
import java.util.Stack;

public class GenericPool
implements IPool {
    private final IPoolObjectFactory objectFactory;
    private final Stack<Object> objects;
    private boolean closed;

    public GenericPool(IPoolObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
        this.objects = new Stack();
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkin(Object object) throws Exception {
        this.deactivateObject(object);
        GenericPool genericPool = this;
        synchronized (genericPool) {
            this.assertOpen();
            this.objects.push(object);
        }
    }

    protected void deactivateObject(Object object) throws Exception {
        if (this.objectFactory == null) {
            return;
        }
        this.objectFactory.deactivateObject(object);
    }

    protected void destroyObject(Object object) throws Exception {
        if (this.objectFactory == null) {
            return;
        }
        this.objectFactory.destroyObject(object);
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected void assertOpen() {
        if (this.closed) {
            throw new IllegalStateException("pool closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object checkout(long timeout) throws Exception {
        Object result = null;
        GenericPool genericPool = this;
        synchronized (genericPool) {
            this.assertOpen();
            result = this.objects.isEmpty() ? this.createObject() : this.objects.pop();
        }
        this.activateObject(result);
        return result;
    }

    protected void activateObject(Object object) throws Exception {
        if (this.objectFactory == null) {
            return;
        }
        this.objectFactory.activateObject(object);
    }

    protected Object createObject() throws Exception {
        if (this.objectFactory == null) {
            throw new IllegalStateException("can not create new object");
        }
        Object result = this.objectFactory.createObject();
        if (result == null) {
            throw new IllegalStateException("new object can't be null");
        }
        return result;
    }

    public void close() throws Exception {
        this.closed = true;
    }

    public void destroy(Object object) throws Exception {
        this.destroyObject(object);
    }
}

