/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.number;

import de.intarsys.tools.collection.NestedIterator;
import de.intarsys.tools.number.NumberInstance;
import de.intarsys.tools.number.NumberWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class NumberList
extends NumberWrapper {
    public static char SEPARATOR = (char)59;
    private List list = new ArrayList();

    public void setList(List newList) {
        this.list = newList;
    }

    public List getList() {
        return this.list;
    }

    public boolean add(Object arg0) {
        if (arg0 instanceof NumberWrapper) {
            this.getList().add(arg0);
            return true;
        }
        if (arg0 instanceof Number) {
            this.getList().add(new NumberInstance((Number)arg0));
            return true;
        }
        return false;
    }

    public Iterator iterator() {
        return new NestedIterator(this.getList().iterator());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator i = this.getList().iterator();
        while (i.hasNext()) {
            sb.append(i.next().toString());
            if (!i.hasNext()) continue;
            sb.append(SEPARATOR);
        }
        return sb.toString();
    }

    public void increment(int i) {
        for (NumberWrapper wrapper : this.getList()) {
            wrapper.increment(i);
        }
    }

    public int size() {
        int size = 0;
        for (NumberWrapper element : this.getList()) {
            size += element.size();
        }
        return size;
    }

    public boolean isEmpty() {
        if (this.getList().isEmpty()) {
            return true;
        }
        for (NumberWrapper element : this.getList()) {
            if (element.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Object o) {
        for (NumberWrapper element : this.getList()) {
            if (!element.contains(o)) continue;
            return true;
        }
        return false;
    }

    public Object[] toArray() {
        Object[] numbers = new Number[this.size()];
        Iterator iter = this.getList().iterator();
        int i = 0;
        while (iter.hasNext()) {
            NumberWrapper element = (NumberWrapper)iter.next();
            Number[] elementArray = (Number[])element.toArray();
            int j = 0;
            while (j < elementArray.length) {
                numbers[i] = elementArray[j];
                ++i;
                ++j;
            }
        }
        return numbers;
    }

    public boolean addAll(Collection arg0) {
        for (Object element : arg0) {
            if (this.add(element)) continue;
            return false;
        }
        return true;
    }

    protected double getMin() {
        double min = Double.MAX_VALUE;
        for (NumberWrapper wrapper : this.getList()) {
            if (!(wrapper.getMin() < min)) continue;
            min = wrapper.getMin();
        }
        return min;
    }

    protected double getMax() {
        double max = Double.MIN_VALUE;
        for (NumberWrapper wrapper : this.getList()) {
            if (!(wrapper.getMax() < max)) continue;
            max = wrapper.getMax();
        }
        return max;
    }
}

