/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.conditions;

import de.huxhorn.sulky.conditions.Condition;
import de.huxhorn.sulky.conditions.ConditionGroup;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class And
implements ConditionGroup {
    private static final long serialVersionUID = -8906390235171353778L;
    private List<Condition> conditions;

    public And() {
        this(null);
    }

    public And(List<Condition> conditions) {
        this.conditions = conditions;
    }

    @Override
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    @Override
    public boolean isTrue(Object element) {
        if (this.conditions != null) {
            for (Condition condition : this.conditions) {
                if (condition.isTrue(element)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        And and = (And)o;
        return !(this.conditions == null ? and.conditions != null : !((Object)this.conditions).equals(and.conditions));
    }

    public int hashCode() {
        return this.conditions != null ? ((Object)this.conditions).hashCode() : 0;
    }

    @Override
    public And clone() throws CloneNotSupportedException {
        And result = (And)super.clone();
        if (result.conditions != null) {
            ArrayList<Condition> clonedConditions = new ArrayList<Condition>(this.conditions.size());
            for (Condition condition : result.conditions) {
                clonedConditions.add(condition.clone());
            }
            result.conditions = clonedConditions;
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.conditions == null || this.conditions.size() == 0) {
            result.append("true");
        } else {
            result.append("(");
            boolean first = true;
            for (Condition condition : this.conditions) {
                if (first) {
                    first = false;
                } else {
                    result.append(" && ");
                }
                result.append(condition);
            }
            result.append(")");
        }
        return result.toString();
    }
}

