/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.sender;

import de.huxhorn.lilith.sender.ConnectionState;
import de.huxhorn.lilith.sender.DataOutputStreamFactory;
import de.huxhorn.lilith.sender.SendBytesService;
import de.huxhorn.lilith.sender.WriteByteStrategy;
import de.huxhorn.sulky.io.IOUtilities;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class SimpleSendBytesService
implements SendBytesService {
    public static final int DEFAULT_RECONNECTION_DELAY = 30000;
    public static final int DEFAULT_QUEUE_SIZE = 1000;
    public static final int DEFAULT_POLL_INTERVALL = 100;
    private final Object lock = new Object();
    private final BlockingQueue<byte[]> localEventBytes;
    private WriteByteStrategy writeByteStrategy;
    private DataOutputStreamFactory dataOutputStreamFactory;
    private final int reconnectionDelay;
    private final int queueSize;
    private final int pollIntervall;
    private final AtomicReference<ConnectionState> connectionState = new AtomicReference<ConnectionState>(ConnectionState.Offline);
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private SendBytesThread sendBytesThread;
    private boolean debug;

    public SimpleSendBytesService(DataOutputStreamFactory dataOutputStreamFactory, WriteByteStrategy writeByteStrategy) {
        this(dataOutputStreamFactory, writeByteStrategy, 1000, 30000, 100);
    }

    public SimpleSendBytesService(DataOutputStreamFactory dataOutputStreamFactory, WriteByteStrategy writeByteStrategy, int queueSize, int reconnectionDelay, int pollIntervall) {
        if (dataOutputStreamFactory == null) {
            throw new IllegalArgumentException("dataOutputStreamFactory must not be null!");
        }
        if (writeByteStrategy == null) {
            throw new IllegalArgumentException("writeByteStrategy must not be null!");
        }
        if (queueSize <= 0) {
            throw new IllegalArgumentException("queueSize must be greater than zero!");
        }
        if (reconnectionDelay <= 0) {
            throw new IllegalArgumentException("reconnectionDelay must be greater than zero!");
        }
        if (pollIntervall <= 0) {
            throw new IllegalArgumentException("pollIntervall must be greater than zero!");
        }
        this.localEventBytes = new ArrayBlockingQueue<byte[]>(queueSize, true);
        this.dataOutputStreamFactory = dataOutputStreamFactory;
        this.writeByteStrategy = writeByteStrategy;
        this.queueSize = queueSize;
        this.reconnectionDelay = reconnectionDelay;
        this.pollIntervall = pollIntervall;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public ConnectionState getConnectionState() {
        return this.connectionState.get();
    }

    public void sendBytes(byte[] bytes) {
        if (this.connectionState.get() == ConnectionState.Connected && this.sendBytesThread != null && bytes != null) {
            try {
                this.localEventBytes.put(bytes);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startUp() {
        Object object = this.lock;
        synchronized (object) {
            if (this.sendBytesThread == null) {
                this.shutdown.set(false);
                this.sendBytesThread = new SendBytesThread();
                this.sendBytesThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        this.shutdown.set(true);
        Object object = this.lock;
        synchronized (object) {
            this.connectionState.set(ConnectionState.Canceled);
        }
        if (this.sendBytesThread != null) {
            this.sendBytesThread.interrupt();
            try {
                this.sendBytesThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.sendBytesThread = null;
        }
        this.localEventBytes.clear();
    }

    private class SendBytesThread
    extends Thread {
        private DataOutputStream dataOutputStream;

        public SendBytesThread() {
            super("SendBytes@" + SimpleSendBytesService.this.dataOutputStreamFactory);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeConnection() {
            Object object = SimpleSendBytesService.this.lock;
            synchronized (object) {
                if (this.dataOutputStream != null) {
                    try {
                        this.dataOutputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.dataOutputStream = null;
                    if (SimpleSendBytesService.this.connectionState.get() != ConnectionState.Canceled) {
                        SimpleSendBytesService.this.connectionState.set(ConnectionState.Offline);
                    }
                    if (SimpleSendBytesService.this.debug) {
                        System.err.println("Closed dataOutputStream.");
                    }
                }
                SimpleSendBytesService.this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ReconnectionThread reconnectionThread = new ReconnectionThread();
            reconnectionThread.start();
            ArrayList copy = new ArrayList(SimpleSendBytesService.this.queueSize);
            try {
                while (true) {
                    SimpleSendBytesService.this.localEventBytes.drainTo(copy);
                    if (copy.size() > 0) {
                        DataOutputStream outputStream;
                        Object object = SimpleSendBytesService.this.lock;
                        synchronized (object) {
                            outputStream = this.dataOutputStream;
                        }
                        if (outputStream != null) {
                            try {
                                for (byte[] current : copy) {
                                    SimpleSendBytesService.this.writeByteStrategy.writeBytes(outputStream, current);
                                }
                                outputStream.flush();
                            }
                            catch (Throwable e) {
                                IOUtilities.interruptIfNecessary((Throwable)e);
                                this.closeConnection();
                            }
                        }
                        copy.clear();
                    }
                    if (!SimpleSendBytesService.this.shutdown.get()) {
                        Thread.sleep(SimpleSendBytesService.this.pollIntervall);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            reconnectionThread.interrupt();
            try {
                reconnectionThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.closeConnection();
        }

        private class ReconnectionThread
        extends Thread {
            public ReconnectionThread() {
                super("Reconnection@" + SimpleSendBytesService.this.dataOutputStreamFactory);
                this.setDaemon(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    boolean connect = false;
                    Object object = SimpleSendBytesService.this.lock;
                    synchronized (object) {
                        if (SendBytesThread.this.dataOutputStream == null && SimpleSendBytesService.this.connectionState.get() != ConnectionState.Canceled) {
                            connect = true;
                            SimpleSendBytesService.this.connectionState.set(ConnectionState.Connecting);
                        }
                    }
                    DataOutputStream newStream = null;
                    if (connect) {
                        try {
                            newStream = SimpleSendBytesService.this.dataOutputStreamFactory.createDataOutputStream();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    Object object2 = SimpleSendBytesService.this.lock;
                    synchronized (object2) {
                        if (connect) {
                            if (newStream != null) {
                                if (SimpleSendBytesService.this.connectionState.get() == ConnectionState.Canceled) {
                                    try {
                                        newStream.close();
                                    }
                                    catch (IOException e) {}
                                } else {
                                    SendBytesThread.this.dataOutputStream = newStream;
                                    SimpleSendBytesService.this.connectionState.set(ConnectionState.Connected);
                                }
                            } else if (SimpleSendBytesService.this.connectionState.get() != ConnectionState.Canceled) {
                                SimpleSendBytesService.this.connectionState.set(ConnectionState.Offline);
                            }
                        }
                        try {
                            SimpleSendBytesService.this.lock.wait(SimpleSendBytesService.this.reconnectionDelay);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }
            }
        }
    }
}

