/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.engine.impl.eventproducer;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.engine.EventProducer;
import de.huxhorn.lilith.engine.impl.eventproducer.SourceIdentifierUpdater;
import de.huxhorn.sulky.buffers.AppendOperation;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEventProducer<T extends Serializable>
implements EventProducer<T> {
    private final Logger logger = LoggerFactory.getLogger(AbstractEventProducer.class);
    private AppendOperation<EventWrapper<T>> eventQueue;
    private SourceIdentifier sourceIdentifier;
    private SourceIdentifierUpdater<T> sourceIdentifierUpdater;
    private long localIdCounter;

    protected AbstractEventProducer(SourceIdentifier sourceIdentifier, AppendOperation<EventWrapper<T>> eventQueue, SourceIdentifierUpdater<T> sourceIdentifierUpdater) {
        this.sourceIdentifier = sourceIdentifier;
        this.eventQueue = eventQueue;
        this.sourceIdentifierUpdater = sourceIdentifierUpdater;
        this.localIdCounter = 0L;
    }

    @Override
    public SourceIdentifier getSourceIdentifier() {
        if (this.sourceIdentifier == null) {
            return null;
        }
        try {
            return this.sourceIdentifier.clone();
        }
        catch (CloneNotSupportedException e) {
            return this.sourceIdentifier;
        }
    }

    @Override
    public AppendOperation<EventWrapper<T>> getEventQueue() {
        return this.eventQueue;
    }

    protected void addEvent(T event) {
        if (event == null && this.localIdCounter == 0L) {
            return;
        }
        ++this.localIdCounter;
        if (this.sourceIdentifierUpdater != null) {
            this.sourceIdentifierUpdater.updateIdentifier(this.sourceIdentifier, event);
        }
        EventWrapper wrapper = new EventWrapper(this.getSourceIdentifier(), this.localIdCounter, event);
        this.eventQueue.add((Object)wrapper);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Added event-wrapper for {}.", event);
        }
    }
}

