/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging;

import de.huxhorn.sulky.formatting.SafeString;
import java.util.Arrays;

public class MessageFormatter {
    private static final char DELIM_START = '{';
    private static final char DELIM_STOP = '}';
    private static final char ESCAPE_CHAR = '\\';

    public static String format(String messagePattern, String[] arguments) {
        if (messagePattern == null || arguments == null || arguments.length == 0) {
            return messagePattern;
        }
        StringBuilder result = new StringBuilder();
        int escapeCounter = 0;
        int currentArgument = 0;
        for (int i = 0; i < messagePattern.length(); ++i) {
            char curChar = messagePattern.charAt(i);
            if (curChar == '\\') {
                ++escapeCounter;
                continue;
            }
            if (curChar == '{' && i < messagePattern.length() - 1 && messagePattern.charAt(i + 1) == '}') {
                int escapedEscapes = escapeCounter / 2;
                for (int j = 0; j < escapedEscapes; ++j) {
                    result.append('\\');
                }
                if (escapeCounter % 2 == 1) {
                    result.append('{');
                    result.append('}');
                } else {
                    if (currentArgument < arguments.length) {
                        result.append(arguments[currentArgument]);
                    } else {
                        result.append('{').append('}');
                    }
                    ++currentArgument;
                }
                ++i;
                escapeCounter = 0;
                continue;
            }
            if (escapeCounter > 0) {
                for (int j = 0; j < escapeCounter; ++j) {
                    result.append('\\');
                }
                escapeCounter = 0;
            }
            result.append(curChar);
        }
        return result.toString();
    }

    public static int countArgumentPlaceholders(String messagePattern) {
        if (messagePattern == null) {
            return 0;
        }
        int delim = messagePattern.indexOf(123);
        if (delim == -1) {
            return 0;
        }
        int result = 0;
        boolean isEscaped = false;
        for (int i = 0; i < messagePattern.length(); ++i) {
            char curChar = messagePattern.charAt(i);
            if (curChar == '\\') {
                isEscaped = !isEscaped;
                continue;
            }
            if (curChar == '{') {
                if (!isEscaped && i < messagePattern.length() - 1 && messagePattern.charAt(i + 1) == '}') {
                    ++result;
                    ++i;
                }
                isEscaped = false;
                continue;
            }
            isEscaped = false;
        }
        return result;
    }

    public static ArgumentResult evaluateArguments(String messagePattern, Object[] arguments) {
        String[] stringArgs;
        if (arguments == null) {
            return null;
        }
        int argsCount = MessageFormatter.countArgumentPlaceholders(messagePattern);
        int resultArgCount = arguments.length;
        Throwable throwable = null;
        if (argsCount < arguments.length && arguments[arguments.length - 1] instanceof Throwable) {
            throwable = (Throwable)arguments[arguments.length - 1];
            --resultArgCount;
        }
        if (argsCount == 1 && throwable == null && arguments.length > 1) {
            stringArgs = new String[]{SafeString.toString((Object)arguments)};
        } else {
            stringArgs = new String[resultArgCount];
            for (int i = 0; i < stringArgs.length; ++i) {
                stringArgs[i] = SafeString.toString((Object)arguments[i]);
            }
        }
        return new ArgumentResult(stringArgs, throwable);
    }

    public static class ArgumentResult {
        private Throwable throwable;
        private String[] arguments;

        public ArgumentResult(String[] arguments, Throwable throwable) {
            this.throwable = throwable;
            this.arguments = arguments;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public String[] getArguments() {
            return this.arguments;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("ArgumentResult[throwable=").append(this.throwable);
            result.append(", arguments=");
            if (this.arguments != null) {
                result.append("[");
                boolean isFirst = true;
                for (String current : this.arguments) {
                    if (!isFirst) {
                        result.append(", ");
                    } else {
                        isFirst = false;
                    }
                    if (current != null) {
                        result.append("'").append(current).append("'");
                        continue;
                    }
                    result.append("null");
                }
                result.append("]");
            }
            return result.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArgumentResult result = (ArgumentResult)o;
            if (!Arrays.equals(this.arguments, result.arguments)) {
                return false;
            }
            return !(this.throwable != null ? !this.throwable.equals(result.throwable) : result.throwable != null);
        }

        public int hashCode() {
            int result = this.throwable != null ? this.throwable.hashCode() : 0;
            result = 31 * result + (this.arguments != null ? Arrays.hashCode(this.arguments) : 0);
            return result;
        }
    }
}

