/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.conditions;

import de.huxhorn.lilith.conditions.LilithCondition;
import de.huxhorn.lilith.conditions.SearchStringCondition;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class LevelCondition
implements LilithCondition,
SearchStringCondition {
    private static final long serialVersionUID = -5498023202272568557L;
    public static final String DESCRIPTION = "Level>=";
    private String searchString;
    private transient LoggingEvent.Level level;

    public LevelCondition() {
        this(null);
    }

    public LevelCondition(String searchString) {
        this.setSearchString(searchString);
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
        try {
            this.level = LoggingEvent.Level.valueOf((String)searchString);
        }
        catch (Throwable e) {
            this.level = null;
        }
    }

    public String getSearchString() {
        return this.searchString;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public boolean isTrue(Object value) {
        EventWrapper wrapper;
        Serializable eventObj;
        if (this.searchString == null) {
            return false;
        }
        if (this.searchString.length() == 0) {
            return true;
        }
        if (this.level == null) {
            return false;
        }
        if (value instanceof EventWrapper && (eventObj = (wrapper = (EventWrapper)value).getEvent()) instanceof LoggingEvent) {
            LoggingEvent event = (LoggingEvent)eventObj;
            LoggingEvent.Level eventLevel = event.getLevel();
            return eventLevel != null && this.level.compareTo((Enum)eventLevel) <= 0;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LevelCondition that = (LevelCondition)o;
        return this.level == that.level;
    }

    public int hashCode() {
        return this.level != null ? this.level.hashCode() : 0;
    }

    public LevelCondition clone() throws CloneNotSupportedException {
        LevelCondition result = (LevelCondition)super.clone();
        result.setSearchString(this.searchString);
        return result;
    }

    private Object readResolve() throws ObjectStreamException {
        this.setSearchString(this.searchString);
        return this;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getDescription());
        result.append(this.level);
        return result.toString();
    }
}

