/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.conditions;

import de.huxhorn.lilith.conditions.LilithCondition;
import de.huxhorn.lilith.conditions.SearchStringCondition;
import de.huxhorn.lilith.data.access.AccessEvent;
import de.huxhorn.lilith.data.access.HttpStatus;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class HttpStatusTypeCondition
implements LilithCondition,
SearchStringCondition {
    private static final long serialVersionUID = -3335718950761221210L;
    public static final String DESCRIPTION = "HttpStatusType==";
    private String searchString;
    private transient HttpStatus.Type type;

    public HttpStatusTypeCondition() {
        this(null);
    }

    public HttpStatusTypeCondition(String searchString) {
        this.setSearchString(searchString);
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
        try {
            this.type = HttpStatus.Type.valueOf((String)searchString);
        }
        catch (Throwable e) {
            this.type = null;
        }
    }

    public String getSearchString() {
        return this.searchString;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public boolean isTrue(Object value) {
        EventWrapper wrapper;
        Serializable eventObj;
        if (this.searchString == null) {
            return false;
        }
        if (this.searchString.length() == 0) {
            return true;
        }
        if (this.type == null) {
            return false;
        }
        if (value instanceof EventWrapper && (eventObj = (wrapper = (EventWrapper)value).getEvent()) instanceof AccessEvent) {
            AccessEvent event = (AccessEvent)eventObj;
            HttpStatus.Type eventType = HttpStatus.getType((int)event.getStatusCode());
            return eventType == this.type;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpStatusTypeCondition that = (HttpStatusTypeCondition)o;
        return this.type == that.type;
    }

    public int hashCode() {
        return this.type != null ? this.type.hashCode() : 0;
    }

    public HttpStatusTypeCondition clone() throws CloneNotSupportedException {
        HttpStatusTypeCondition result = (HttpStatusTypeCondition)super.clone();
        result.setSearchString(this.searchString);
        return result;
    }

    private Object readResolve() throws ObjectStreamException {
        this.setSearchString(this.searchString);
        return this;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getDescription());
        result.append(this.type);
        return result.toString();
    }
}

