/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.elgamal;

import java.math.BigInteger;
import java.security.SecureRandom;

final class ElGamalAlgorithm {
    private ElGamalAlgorithm() {
    }

    public static BigInteger decrypt(BigInteger[] bia, BigInteger p, BigInteger x) throws ArithmeticException {
        return bia[0].modPow(x, p).modInverse(p).multiply(bia[1]).mod(p);
    }

    public static BigInteger[] encrypt(BigInteger m, BigInteger p, BigInteger g, BigInteger y) {
        BigInteger k = ElGamalAlgorithm.generateK(p);
        try {
            BigInteger[] bia = new BigInteger[]{g.modPow(k, p), y.modPow(k, p).multiply(m).mod(p)};
            return bia;
        }
        catch (ArithmeticException arithmeticException) {
            throw new RuntimeException("PANIC: Should not happend!!");
        }
    }

    private static BigInteger generateK(BigInteger p) {
        BigInteger k;
        BigInteger ONE = BigInteger.valueOf(1L);
        BigInteger p_1 = p.subtract(ONE);
        SecureRandom sr = new SecureRandom();
        while ((k = new BigInteger(p.bitLength(), sr)).compareTo(ONE) <= 0 || k.compareTo(p_1) >= 0) {
        }
        return k;
    }
}

