/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.dsa;

import java.math.BigInteger;
import java.security.SignatureException;

class SignatureData {
    private BigInteger r;
    private BigInteger s;

    public SignatureData(BigInteger r, BigInteger s) throws SignatureException {
        if (r == null || s == null) {
            throw new SignatureException("Invalid signature");
        }
        if (r.signum() != 1 || s.signum() != 1) {
            throw new SignatureException("Invalid signature");
        }
        this.r = r;
        this.s = s;
    }

    public SignatureData(byte[] data) throws SignatureException {
        try {
            int len;
            int i = 0;
            if (data[i++] != 48 || data[i++] != data.length - 2 || data[i++] != 2) {
                throw new SignatureException("Corrupted signature data");
            }
            if ((len = data[i++]) > 21) {
                throw new SignatureException("Corrupted signature data");
            }
            byte[] rdata = new byte[len];
            int j = 0;
            while (j < len) {
                rdata[j] = data[i++];
                ++j;
            }
            if (data[i++] != 2) {
                throw new SignatureException("Corrupted signature data");
            }
            if ((len = data[i++]) > 21) {
                throw new SignatureException("Corrupted signature data");
            }
            byte[] sdata = new byte[len];
            int j2 = 0;
            while (j2 < len) {
                sdata[j2] = data[i++];
                ++j2;
            }
            this.r = new BigInteger(rdata);
            this.s = new BigInteger(sdata);
            if (i != data.length || this.r.signum() != 1 || this.s.signum() != 1) {
                throw new SignatureException("Corrupted signature data");
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new SignatureException("Corrupted signature data");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SignatureException("Corrupted signature data");
        }
    }

    public byte[] getData() {
        byte[] rdata = this.r.toByteArray();
        byte[] sdata = this.s.toByteArray();
        byte[] data = new byte[6 + rdata.length + sdata.length];
        int i = 0;
        data[i++] = 48;
        data[i++] = (byte)(data.length - 2);
        data[i++] = 2;
        data[i++] = (byte)rdata.length;
        int j = 0;
        while (j < rdata.length) {
            data[i++] = rdata[j];
            ++j;
        }
        data[i++] = 2;
        data[i++] = (byte)sdata.length;
        int j2 = 0;
        while (j2 < sdata.length) {
            data[i++] = sdata[j2];
            ++j2;
        }
        return data;
    }

    public BigInteger getR() {
        return this.r;
    }

    public BigInteger getS() {
        return this.s;
    }
}

