/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.key.RawSecretKey;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public final class TripleDESInnerCBC
extends CipherSpi {
    private static final String PROVIDER = "CryptixCrypto";
    private static final int BLOCK_SIZE = 64;
    private static final String ALG_NAME = "DES/CBC/None";
    private static final int KEY_SIZE = 24;
    private final Cipher _c1;
    private final Cipher _c2;
    private final Cipher _c3;
    private static final int IV_SIZE = 24;
    private byte[] _ivBuf;

    public TripleDESInnerCBC() {
        try {
            this._c1 = Cipher.getInstance(ALG_NAME, PROVIDER);
            this._c2 = Cipher.getInstance(ALG_NAME, PROVIDER);
            this._c3 = Cipher.getInstance(ALG_NAME, PROVIDER);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("Unreachable code reached.");
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new InternalError("Unreachable code reached.");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InternalError("Unreachable code reached.");
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected final byte[] engineDoFinal(byte[] in, int inOff, int inLen) throws IllegalBlockSizeException, BadPaddingException {
        byte[] buf = this._c1.doFinal(in, inOff, inLen);
        buf = this._c2.doFinal(buf, 0, buf.length);
        buf = this._c3.doFinal(buf, 0, buf.length);
        return buf;
    }

    protected final int engineDoFinal(byte[] in, int inOff, int inLen, byte[] out, int outOff) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int outLen = this._c1.doFinal(in, inOff, inLen, out, outOff);
        outLen = this._c2.doFinal(out, outOff, outLen, out, outOff);
        outLen = this._c3.doFinal(out, outOff, outLen, out, outOff);
        return outLen;
    }

    protected final int engineGetBlockSize() {
        return 64;
    }

    protected final byte[] engineGetIV() {
        return (byte[])this._ivBuf.clone();
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new IllegalArgumentException("Key missing");
        }
        if (!key.getFormat().equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("Wrong format: RAW bytes needed");
        }
        byte[] userkey = key.getEncoded();
        if (userkey == null) {
            throw new InvalidKeyException("RAW bytes missing");
        }
        return userkey.length * 8;
    }

    protected final int engineGetOutputSize(int len) {
        return this._c1.getOutputSize(this._c2.getOutputSize(this._c3.getOutputSize(len)));
    }

    protected final AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected final void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException();
        }
        this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
    }

    protected final void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InternalError("Unreachable code reached.");
        }
    }

    protected final void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (opmode != 1 && opmode != 2) {
            throw new IllegalArgumentException("opmode invalid (" + opmode + ")");
        }
        if (key == null) {
            throw new IllegalArgumentException("key invalid (" + key + ")");
        }
        byte[] keyBuf = key.getEncoded();
        if (keyBuf == null) {
            throw new InvalidKeyException("key.getEncoded() == null");
        }
        if (keyBuf.length != 24) {
            throw new InvalidKeyException("Invalid key length");
        }
        RawSecretKey k1 = new RawSecretKey("DES", keyBuf, 0, 8);
        RawSecretKey k2 = new RawSecretKey("DES", keyBuf, 8, 8);
        RawSecretKey k3 = new RawSecretKey("DES", keyBuf, 16, 8);
        if (params == null) {
            this._ivBuf = new byte[24];
            random.nextBytes(this._ivBuf);
        } else if (params instanceof IvParameterSpec) {
            this._ivBuf = ((IvParameterSpec)params).getIV();
            if (this._ivBuf.length != 24) {
                throw new InvalidAlgorithmParameterException("IV too short");
            }
        } else {
            throw new InvalidAlgorithmParameterException("params = " + params);
        }
        IvParameterSpec iv1 = new IvParameterSpec(this._ivBuf, 0, 8);
        IvParameterSpec iv2 = new IvParameterSpec(this._ivBuf, 8, 8);
        IvParameterSpec iv3 = new IvParameterSpec(this._ivBuf, 16, 8);
        if (opmode == 1) {
            this._c1.init(1, (Key)k1, iv1, random);
            this._c2.init(2, (Key)k2, iv2, random);
            this._c3.init(1, (Key)k3, iv3, random);
        } else {
            this._c1.init(2, (Key)k3, iv3, random);
            this._c2.init(1, (Key)k2, iv2, random);
            this._c3.init(2, (Key)k1, iv1, random);
        }
    }

    protected final void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!mode.equals("InnerCBC")) {
            throw new NoSuchAlgorithmException(mode);
        }
    }

    protected final void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (!padding.equals("None")) {
            throw new NoSuchPaddingException(padding);
        }
    }

    protected final byte[] engineUpdate(byte[] in, int inOff, int inLen) {
        byte[] buf = this._c1.update(in, inOff, inLen);
        buf = this._c2.update(buf, 0, buf.length);
        buf = this._c3.update(buf, 0, buf.length);
        return buf;
    }

    protected final int engineUpdate(byte[] in, int inOff, int inLen, byte[] out, int outOff) throws ShortBufferException {
        int outLen = this._c1.update(in, inOff, inLen, out, outOff);
        outLen = this._c2.update(out, outOff, outLen, out, outOff);
        outLen = this._c3.update(out, outOff, outLen, out, outOff);
        return outLen;
    }
}

