/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxb.model.util;

import com.webcohesion.enunciate.modules.jaxb.EnunciateJaxbContext;
import com.webcohesion.enunciate.modules.jaxb.model.Accessor;
import com.webcohesion.enunciate.modules.jaxb.model.SchemaInfo;
import com.webcohesion.enunciate.modules.jaxb.model.TypeDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class JAXBCodeErrors {
    static final String CONFLICTING_JAXB_ACCESSOR_NAMING_ERRORS_PROPERTY = "com.webcohesion.enunciate.modules.jaxb.model.util.JAXBCodeErrors#CONFLICTING_JAXB_ACCESSOR_NAMING_ERRORS_PROPERTY";

    private JAXBCodeErrors() {
    }

    public static List<String> findConflictingAccessorNamingErrors(EnunciateJaxbContext context) {
        ArrayList<String> errors = (ArrayList<String>)context.getContext().getProperty(CONFLICTING_JAXB_ACCESSOR_NAMING_ERRORS_PROPERTY);
        if (errors == null) {
            errors = new ArrayList<String>();
            context.getContext().setProperty(CONFLICTING_JAXB_ACCESSOR_NAMING_ERRORS_PROPERTY, errors);
            for (SchemaInfo schemaInfo : context.getSchemas().values()) {
                for (TypeDefinition typeDefinition : schemaInfo.getTypeDefinitions()) {
                    HashMap<String, Accessor> accessorsBySimpleName = new HashMap<String, Accessor>();
                    for (Accessor accessor : typeDefinition.getAllAccessors()) {
                        String name = accessor.getClientSimpleName();
                        Accessor conflict = (Accessor)accessorsBySimpleName.get(name);
                        if (conflict != null) {
                            errors.add(String.format("%s: accessor \"%s\" conflicts with accessor \"%s\" of %s: both are named \"%s\".", typeDefinition.getQualifiedName(), accessor, conflict, conflict.getTypeDefinition().getQualifiedName(), name));
                            continue;
                        }
                        accessorsBySimpleName.put(name, accessor);
                    }
                }
            }
        }
        return errors;
    }
}

