/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxb;

import com.webcohesion.enunciate.Enunciate;
import com.webcohesion.enunciate.artifacts.BaseArtifact;
import com.webcohesion.enunciate.modules.jaxb.EnunciateJaxbContext;
import com.webcohesion.enunciate.modules.jaxb.model.SchemaInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public class NamespacePropertiesArtifact
extends BaseArtifact {
    private final EnunciateJaxbContext jaxbContext;
    private final Date created = new Date();

    public NamespacePropertiesArtifact(EnunciateJaxbContext jaxbContext) {
        super("jaxb", "namespaces.properties");
        this.jaxbContext = jaxbContext;
        this.setBelongsOnServerSideClasspath(true);
    }

    public String getName() {
        return "namespaces.properties";
    }

    public String getDescription() {
        return "A properties file that contains metadata about JAXB namespaces.";
    }

    public boolean isPublic() {
        return false;
    }

    public Date getCreated() {
        return this.created;
    }

    public void exportTo(File fileOrDirectory, Enunciate enunciate) throws IOException {
        Properties properties = new Properties();
        for (Map.Entry<String, String> ns2prefix : this.jaxbContext.getNamespacePrefixes().entrySet()) {
            if (ns2prefix.getKey() == null) continue;
            properties.put(ns2prefix.getKey(), ns2prefix.getValue());
        }
        String defaultNs = this.jaxbContext.getContext().getConfiguration().getDefaultNamespace();
        if (defaultNs == null) {
            SchemaInfo schemaWithTheMostTypes = null;
            for (SchemaInfo schemaInfo : this.jaxbContext.getSchemas().values()) {
                if (schemaWithTheMostTypes == null) {
                    schemaWithTheMostTypes = schemaInfo;
                    continue;
                }
                if (schemaWithTheMostTypes.getTypeDefinitions().size() >= schemaInfo.getTypeDefinitions().size()) continue;
                schemaWithTheMostTypes = schemaInfo;
            }
            if (schemaWithTheMostTypes != null && schemaWithTheMostTypes.getNamespace() != null && !properties.containsValue(schemaWithTheMostTypes.getNamespace())) {
                defaultNs = schemaWithTheMostTypes.getNamespace();
            }
        }
        if (defaultNs != null) {
            properties.put("{default}", defaultNs);
        }
        FileOutputStream out = new FileOutputStream(fileOrDirectory.isDirectory() ? new File(fileOrDirectory, this.getName()) : fileOrDirectory);
        properties.store(out, "Namespace properties, generated by Enunciate.");
        out.flush();
        out.close();
    }

    public long getSize() {
        return -1L;
    }
}

