/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier;

import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.attestation.statement.AttestationType;
import com.webauthn4j.data.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.CoreRegistrationObject;
import com.webauthn4j.verifier.attestation.statement.AttestationStatementVerifier;
import com.webauthn4j.verifier.attestation.trustworthiness.certpath.CertPathTrustworthinessVerifier;
import com.webauthn4j.verifier.attestation.trustworthiness.self.SelfAttestationTrustworthinessVerifier;
import com.webauthn4j.verifier.exception.BadAaguidException;
import com.webauthn4j.verifier.exception.BadAttestationStatementException;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

class AttestationVerifier {
    private static final AAGUID U2F_AAGUID = AAGUID.ZERO;
    private final List<AttestationStatementVerifier> attestationStatementVerifiers;
    private final CertPathTrustworthinessVerifier certPathTrustworthinessVerifier;
    private final SelfAttestationTrustworthinessVerifier selfAttestationTrustworthinessVerifier;

    AttestationVerifier(@NotNull List<AttestationStatementVerifier> attestationStatementVerifiers, @NotNull CertPathTrustworthinessVerifier certPathTrustworthinessVerifier, @NotNull SelfAttestationTrustworthinessVerifier selfAttestationTrustworthinessVerifier) {
        AssertUtil.notNull(attestationStatementVerifiers, "attestationStatementVerifiers must not be null");
        AssertUtil.notNull(certPathTrustworthinessVerifier, "certPathTrustworthinessVerifier must not be null");
        AssertUtil.notNull(selfAttestationTrustworthinessVerifier, "selfAttestationTrustworthinessVerifier must not be null");
        this.attestationStatementVerifiers = attestationStatementVerifiers;
        this.certPathTrustworthinessVerifier = certPathTrustworthinessVerifier;
        this.selfAttestationTrustworthinessVerifier = selfAttestationTrustworthinessVerifier;
    }

    public void verify(@NotNull CoreRegistrationObject registrationObject) {
        AssertUtil.notNull(registrationObject, "registrationObject must not be null");
        AttestationObject attestationObject = registrationObject.getAttestationObject();
        AttestationType attestationType = this.verifyAttestationStatement(registrationObject);
        this.verifyAAGUID(attestationObject);
        AttestationStatement attestationStatement = attestationObject.getAttestationStatement();
        switch (attestationType) {
            case SELF: {
                if (attestationStatement instanceof CertificateBaseAttestationStatement) {
                    CertificateBaseAttestationStatement certificateBaseAttestationStatement = (CertificateBaseAttestationStatement)attestationStatement;
                    this.selfAttestationTrustworthinessVerifier.verify(certificateBaseAttestationStatement);
                    break;
                }
                throw new IllegalStateException();
            }
            case BASIC: 
            case ATT_CA: {
                if (attestationStatement instanceof CertificateBaseAttestationStatement) {
                    CertificateBaseAttestationStatement certificateBaseAttestationStatement = (CertificateBaseAttestationStatement)attestationStatement;
                    AAGUID aaguid = attestationObject.getAuthenticatorData().getAttestedCredentialData().getAaguid();
                    this.certPathTrustworthinessVerifier.verify(aaguid, certificateBaseAttestationStatement, registrationObject.getTimestamp());
                    break;
                }
                throw new IllegalStateException();
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    void verifyAAGUID(@NotNull AttestationObject attestationObject) {
        AAGUID aaguid;
        if (attestationObject.getFormat().equals("fido-u2f") && !Objects.equals(aaguid = attestationObject.getAuthenticatorData().getAttestedCredentialData().getAaguid(), U2F_AAGUID)) {
            throw new BadAaguidException("AAGUID is expected to be zero filled in U2F attestation, but it isn't.");
        }
    }

    @NotNull
    private AttestationType verifyAttestationStatement(@NotNull CoreRegistrationObject registrationObject) {
        for (AttestationStatementVerifier verifier : this.attestationStatementVerifiers) {
            if (!verifier.supports(registrationObject)) continue;
            return verifier.verify(registrationObject);
        }
        throw new BadAttestationStatementException(String.format("AttestationVerifier is not configured to handle the supplied AttestationStatement format '%s'.", registrationObject.getAttestationObject().getFormat()));
    }
}

