/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.enumerated.reference.internal;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedOrdinalRenderer;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceBlock;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceExtension;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceLink;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceRendering;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceRepository;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceText;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferences;
import com.vladsch.flexmark.ext.enumerated.reference.internal.EnumRefTextCollectingVisitor;
import com.vladsch.flexmark.ext.enumerated.reference.internal.EnumeratedReferenceOptions;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.HeaderIdGenerator;
import com.vladsch.flexmark.html.renderer.HtmlIdGenerator;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.PhasedNodeRenderer;
import com.vladsch.flexmark.html.renderer.RenderingPhase;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class EnumeratedReferenceNodeRenderer
implements PhasedNodeRenderer {
    private final EnumeratedReferenceOptions options;
    private EnumeratedReferences enumeratedOrdinals;
    private Runnable ordinalRunnable;
    private final HtmlIdGenerator headerIdGenerator;

    public EnumeratedReferenceNodeRenderer(DataHolder options) {
        this.options = new EnumeratedReferenceOptions(options);
        this.ordinalRunnable = null;
        this.headerIdGenerator = new HeaderIdGenerator.Factory().create();
    }

    public Set<RenderingPhase> getRenderingPhases() {
        LinkedHashSet<RenderingPhase> phaseSet = new LinkedHashSet<RenderingPhase>();
        phaseSet.add(RenderingPhase.HEAD_TOP);
        phaseSet.add(RenderingPhase.BODY_TOP);
        return phaseSet;
    }

    public void renderDocument(NodeRendererContext context, HtmlWriter html, Document document, RenderingPhase phase) {
        if (phase == RenderingPhase.HEAD_TOP) {
            this.headerIdGenerator.generateIds(document);
        } else if (phase == RenderingPhase.BODY_TOP) {
            this.enumeratedOrdinals = (EnumeratedReferences)EnumeratedReferenceExtension.ENUMERATED_REFERENCE_ORDINALS.getFrom((DataHolder)document);
        }
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(EnumeratedReferenceText.class, (CustomNodeRenderer)new CustomNodeRenderer<EnumeratedReferenceText>(){

            public void render(EnumeratedReferenceText node, NodeRendererContext context, HtmlWriter html) {
                EnumeratedReferenceNodeRenderer.this.render(node, context, html);
            }
        }));
        set.add(new NodeRenderingHandler(EnumeratedReferenceLink.class, (CustomNodeRenderer)new CustomNodeRenderer<EnumeratedReferenceLink>(){

            public void render(EnumeratedReferenceLink node, NodeRendererContext context, HtmlWriter html) {
                EnumeratedReferenceNodeRenderer.this.render(node, context, html);
            }
        }));
        set.add(new NodeRenderingHandler(EnumeratedReferenceBlock.class, (CustomNodeRenderer)new CustomNodeRenderer<EnumeratedReferenceBlock>(){

            public void render(EnumeratedReferenceBlock node, NodeRendererContext context, HtmlWriter html) {
                EnumeratedReferenceNodeRenderer.this.render(node, context, html);
            }
        }));
        return set;
    }

    private void render(final EnumeratedReferenceLink node, NodeRendererContext context, HtmlWriter html) {
        final String text = node.getText().toString();
        if (text.isEmpty()) {
            if (this.ordinalRunnable != null) {
                this.ordinalRunnable.run();
            }
        } else {
            this.enumeratedOrdinals.renderReferenceOrdinals(text, new OrdinalRenderer(this, context, html){

                @Override
                public void startRendering(EnumeratedReferenceRendering[] renderings) {
                    String title = new EnumRefTextCollectingVisitor().collectAndGetText(node.getChars().getBaseSequence(), renderings, null);
                    ((HtmlWriter)((HtmlWriter)this.html.withAttr().attr((CharSequence)"href", (CharSequence)("#" + text))).attr((CharSequence)"title", (CharSequence)title)).tag((CharSequence)"a");
                }

                @Override
                public void endRendering() {
                    this.html.tag((CharSequence)"/a");
                }
            });
        }
    }

    private void render(EnumeratedReferenceText node, NodeRendererContext context, HtmlWriter html) {
        String text = node.getText().toString();
        if (text.isEmpty()) {
            if (this.ordinalRunnable != null) {
                this.ordinalRunnable.run();
            }
        } else {
            Node parent;
            String type = EnumeratedReferenceRepository.getType(text.toString());
            if ((type.isEmpty() || text.equals(type + ":")) && (parent = node.getAncestorOfType(new Class[]{Heading.class})) instanceof Heading) {
                text = (type.isEmpty() ? text : type) + ":" + this.headerIdGenerator.getId(parent);
            }
            this.enumeratedOrdinals.renderReferenceOrdinals(text, new OrdinalRenderer(this, context, html));
        }
    }

    private void render(EnumeratedReferenceBlock node, NodeRendererContext context, HtmlWriter html) {
    }

    public static class Factory
    implements NodeRendererFactory {
        public NodeRenderer apply(DataHolder options) {
            return new EnumeratedReferenceNodeRenderer(options);
        }
    }

    private static class OrdinalRenderer
    implements EnumeratedOrdinalRenderer {
        final EnumeratedReferenceNodeRenderer renderer;
        final NodeRendererContext context;
        final HtmlWriter html;

        public OrdinalRenderer(EnumeratedReferenceNodeRenderer renderer, NodeRendererContext context, HtmlWriter html) {
            this.renderer = renderer;
            this.context = context;
            this.html = html;
        }

        @Override
        public void startRendering(EnumeratedReferenceRendering[] renderings) {
        }

        @Override
        public void setEnumOrdinalRunnable(Runnable runnable) {
            this.renderer.ordinalRunnable = runnable;
        }

        @Override
        public Runnable getEnumOrdinalRunnable() {
            return this.renderer.ordinalRunnable;
        }

        @Override
        public void render(final int referenceOrdinal, EnumeratedReferenceBlock referenceFormat, String defaultText, final boolean needSeparator) {
            final Runnable compoundRunnable = this.renderer.ordinalRunnable;
            if (referenceFormat != null) {
                this.renderer.ordinalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        if (compoundRunnable != null) {
                            compoundRunnable.run();
                        }
                        html.text((CharSequence)String.valueOf(referenceOrdinal));
                        if (needSeparator) {
                            html.text((CharSequence)".");
                        }
                    }
                };
                this.context.renderChildren((Node)referenceFormat);
            } else {
                this.html.text((CharSequence)(defaultText + " "));
                if (compoundRunnable != null) {
                    compoundRunnable.run();
                }
                this.html.text((CharSequence)String.valueOf(referenceOrdinal));
                if (needSeparator) {
                    this.html.text((CharSequence)".");
                }
            }
        }

        @Override
        public void endRendering() {
        }
    }
}

