/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.enumerated.reference.internal;

import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceBlock;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceExtension;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceRepository;
import com.vladsch.flexmark.ext.enumerated.reference.internal.EnumeratedReferenceOptions;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.BlockContent;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EnumeratedReferenceBlockParser
extends AbstractBlockParser {
    static String ENUM_REF_ID = "(?:[^0-9].*)?";
    static Pattern ENUM_REF_ID_PATTERN = Pattern.compile("\\[[\\@|#]\\s*(" + ENUM_REF_ID + ")\\s*\\]");
    static Pattern ENUM_REF_DEF_PATTERN = Pattern.compile("^(\\[[\\@]\\s*(" + ENUM_REF_ID + ")\\s*\\]:)\\s+");
    private final EnumeratedReferenceBlock block = new EnumeratedReferenceBlock();
    private final EnumeratedReferenceOptions options;
    private final int contentOffset;
    private BlockContent content = new BlockContent();

    public EnumeratedReferenceBlockParser(EnumeratedReferenceOptions options, int contentOffset) {
        this.options = options;
        this.contentOffset = contentOffset;
    }

    public BlockContent getBlockContent() {
        return this.content;
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockContinue tryContinue(ParserState state) {
        return BlockContinue.none();
    }

    public void addLine(ParserState state, BasedSequence line) {
        throw new IllegalStateException("Abbreviation Blocks hold a single line");
    }

    public void closeBlock(ParserState state) {
        this.block.setCharsFromContent();
        this.block.setEnumeratedReference((BasedSequence)((BasedSequence)this.block.getChars().subSequence(this.block.getClosingMarker().getEndOffset() - this.block.getChars().getStartOffset())).trimStart());
        this.content = null;
        EnumeratedReferenceRepository enumeratedReferences = (EnumeratedReferenceRepository)((Object)EnumeratedReferenceExtension.ENUMERATED_REFERENCES.getFrom((DataHolder)state.getProperties()));
        enumeratedReferences.put(this.block.getText().toString(), (Object)this.block);
    }

    public void parseInlines(InlineParser inlineParser) {
        Node paragraph = this.block.getFirstChild();
        if (paragraph != null) {
            inlineParser.parse(paragraph.getChars(), paragraph);
        }
    }

    public boolean isContainer() {
        return true;
    }

    public boolean canContain(ParserState state, BlockParser blockParser, Block block) {
        return blockParser.isParagraphParser();
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private final EnumeratedReferenceOptions options;

        private BlockFactory(DataHolder options) {
            super(options);
            this.options = new EnumeratedReferenceOptions(options);
        }

        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            int nextNonSpace;
            if (state.getIndent() >= 4) {
                return BlockStart.none();
            }
            BasedSequence line = state.getLineWithEOL();
            BasedSequence trySequence = (BasedSequence)line.subSequence(nextNonSpace = state.getNextNonSpaceIndex(), line.length());
            Matcher matcher = ENUM_REF_DEF_PATTERN.matcher((CharSequence)trySequence);
            if (matcher.find()) {
                int openingStart = nextNonSpace + matcher.start(1);
                int openingEnd = nextNonSpace + matcher.end(1);
                BasedSequence openingMarker = (BasedSequence)line.subSequence(openingStart, openingStart + 2);
                BasedSequence text = (BasedSequence)line.subSequence(matcher.start(2), matcher.end(2));
                BasedSequence closingMarker = (BasedSequence)line.subSequence(openingEnd - 2, openingEnd);
                int contentOffset = this.options.contentIndent;
                EnumeratedReferenceBlockParser enumeratedReferenceBlockParser = new EnumeratedReferenceBlockParser(this.options, contentOffset);
                enumeratedReferenceBlockParser.block.setOpeningMarker(openingMarker);
                enumeratedReferenceBlockParser.block.setText(text);
                enumeratedReferenceBlockParser.block.setClosingMarker(closingMarker);
                BasedSequence enumeratedReference = (BasedSequence)trySequence.subSequence(matcher.end());
                enumeratedReferenceBlockParser.block.setEnumeratedReference(enumeratedReference);
                Paragraph paragraph = new Paragraph(enumeratedReference);
                enumeratedReferenceBlockParser.block.appendChild((Node)paragraph);
                enumeratedReferenceBlockParser.block.setCharsFromContent();
                return BlockStart.of((BlockParser[])new BlockParser[]{enumeratedReferenceBlockParser}).atIndex(line.length());
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        public Set<Class<? extends CustomBlockParserFactory>> getAfterDependents() {
            return null;
        }

        public Set<Class<? extends CustomBlockParserFactory>> getBeforeDependents() {
            return null;
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        public BlockParserFactory apply(DataHolder options) {
            return new BlockFactory(options);
        }
    }
}

