/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker.dau;

final class EnforcementRule {
    private final boolean enforce;
    private final int rateLimitRemaining;

    public EnforcementRule(boolean enforce, int rateLimitRemaining) {
        this.enforce = enforce;
        this.rateLimitRemaining = rateLimitRemaining;
    }

    public boolean shouldEnforce(int trackedUsers) {
        if (trackedUsers < 0) {
            throw new IllegalArgumentException("trackedUsers cannot be negative");
        }
        return this.enforce && trackedUsers > this.rateLimitRemaining;
    }

    public boolean isActiveEnforcement() {
        return this.enforce;
    }

    public String toString() {
        return "Enforcement " + (this.enforce ? "ON (" + this.rateLimitRemaining + " remaining users)" : "OFF");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnforcementRule rule = (EnforcementRule)o;
        return this.enforce == rule.enforce && this.rateLimitRemaining == rule.rateLimitRemaining;
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.enforce);
        result = 31 * result + this.rateLimitRemaining;
        return result;
    }
}

