/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker.dau;

import com.vaadin.pro.licensechecker.LicenseException;
import com.vaadin.pro.licensechecker.LicenseValidationException;
import com.vaadin.pro.licensechecker.dau.DAUServerResponse;
import com.vaadin.pro.licensechecker.dau.EnforcementException;
import com.vaadin.pro.licensechecker.dau.EnforcementRule;
import com.vaadin.pro.licensechecker.dau.LicenseServerPublisher;
import com.vaadin.pro.licensechecker.dau.Publisher;
import com.vaadin.pro.licensechecker.dau.PublishingException;
import com.vaadin.pro.licensechecker.dau.PublishingPhase;
import com.vaadin.pro.licensechecker.dau.TrackedUser;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DauStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(DauStorage.class);
    private static final String LICENSE_SERVER_URL = System.getProperty("vaadin.licenseServerBaseUrl", "https://tools.vaadin.com/vaadin-license-server");
    private ScheduledFuture<?> publishingFuture;
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(DauStorage.dauThreadFactory());
    private final Map<String, TrackedUser> storage = new HashMap<String, TrackedUser>();
    private final Map<String, Set<String>> blockedUsers = new HashMap<String, Set<String>>();
    private final PublishingTask publishingTask = new PublishingTask();
    private final Publisher publisher;
    private final PublishingSettings publishingSettings;
    private EnforcementRule enforcementRule = new EnforcementRule(false, Integer.MAX_VALUE);
    private Instant enforcementRuleUpdatedAt;
    private String applicationName;
    private volatile int newUsersCounter = 0;

    DauStorage(Publisher publisher, PublishingSettings publishingSettings) {
        this.publisher = publisher;
        this.publishingSettings = publishingSettings;
    }

    static DauStorage getInstance() {
        return Holder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(String applicationName) {
        Map<String, TrackedUser> map = this.storage;
        synchronized (map) {
            if (this.executorService.isShutdown() || this.executorService.isTerminated()) {
                throw new IllegalStateException("DAU storage cannot be restarted after stop has been invoked");
            }
            if (this.publishingFuture != null) {
                LOGGER.debug("Attempt to restart DAU storage after stop");
                return;
            }
            long delay = this.publishingSettings.publishingInterval.toMillis();
            this.publishingFuture = this.executorService.scheduleWithFixedDelay(() -> this.publishUpdates(PublishingPhase.PERIOD), delay, delay, TimeUnit.MILLISECONDS);
        }
        this.applicationName = applicationName;
        LOGGER.debug("Started DAU publishing Job with interval {}", (Object)this.publishingSettings.publishingInterval);
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
        LOGGER.debug("DAU synchronization started for application {}.", (Object)applicationName);
        this.publishUpdates(PublishingPhase.START);
    }

    int getNewUsersCounter() {
        return this.newUsersCounter;
    }

    Map<String, TrackedUser> getUsersInStorage() {
        return this.storage;
    }

    Map<String, Set<String>> getBlockedUsers() {
        return this.blockedUsers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Map<String, TrackedUser> map = this.storage;
        synchronized (map) {
            if (this.publishingFuture != null) {
                LOGGER.debug("Stopping DAU synchronization for application {}.", (Object)this.applicationName);
                this.publishingFuture.cancel(false);
                this.publishingFuture = null;
                this.publishUpdates(PublishingPhase.STOP);
                LOGGER.debug("DAU synchronization stopped for application {}.", (Object)this.applicationName);
            }
            this.executorService.shutdown();
        }
    }

    void track(String trackingHash) throws EnforcementException {
        this.track(trackingHash, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void track(String trackingHash, String identityHash) throws EnforcementException {
        Objects.requireNonNull(trackingHash, "trackingHash cannot be null");
        Map<String, TrackedUser> map = this.storage;
        synchronized (map) {
            boolean isTrackedIdentity;
            boolean isNewTrackingHash;
            boolean bl = isNewTrackingHash = !this.storage.containsKey(trackingHash);
            if (this.blockedUsers.getOrDefault(trackingHash, Collections.emptySet()).contains(identityHash)) {
                LOGGER.debug("User {} with identity {} has already been blocked because of enforcement rule", (Object)trackingHash, (Object)identityHash);
                DauStorage.applyEnforcement(trackingHash, identityHash);
            }
            if (identityHash != null) {
                Set sameIdentityTrackingHashes = this.storage.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(trackingHash)).filter(entry -> ((TrackedUser)entry.getValue()).getUserIdentityHashes().contains(identityHash)).map(Map.Entry::getKey).collect(Collectors.toSet());
                boolean bl2 = isTrackedIdentity = !sameIdentityTrackingHashes.isEmpty();
                if (isNewTrackingHash && isTrackedIdentity) {
                    LOGGER.debug("User {} with identity {} is already linked with other tracking hashes {}.", new Object[]{trackingHash, identityHash, sameIdentityTrackingHashes});
                }
                if (sameIdentityTrackingHashes.stream().anyMatch(otherTrackingHash -> this.blockedUsers.getOrDefault(otherTrackingHash, Collections.emptySet()).contains(identityHash))) {
                    LOGGER.debug("User {} with identity {} has already been blocked because of enforcement rule on another device", (Object)trackingHash, (Object)identityHash);
                    DauStorage.applyEnforcement(trackingHash, identityHash);
                }
            } else {
                isTrackedIdentity = false;
            }
            TrackedUser trackedUser = this.storage.computeIfAbsent(trackingHash, TrackedUser::new);
            boolean isAnonymous = !trackedUser.hasLinkedIdentities();
            boolean newIdentity = trackedUser.linkUserIdentity(identityHash);
            if (isNewTrackingHash && !isTrackedIdentity || newIdentity && !isAnonymous) {
                ++this.newUsersCounter;
                LOGGER.debug("Tracking user {}", (Object)trackedUser);
                if (this.shouldEnforce()) {
                    LOGGER.warn("{}, currently tracked users: {}. Enforcement applied for user {} identified by {}", new Object[]{this.enforcementRule, this.newUsersCounter, trackingHash, identityHash});
                    this.blockedUsers.computeIfAbsent(trackingHash, k -> new HashSet()).add(identityHash);
                    this.publishingTask.checkEnforcementUpdates();
                    DauStorage.applyEnforcement(trackingHash, identityHash);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean shouldEnforceThisUser() {
        Map<String, TrackedUser> map = this.storage;
        synchronized (map) {
            return this.shouldEnforce(this.newUsersCounter + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldEnforce() {
        Map<String, TrackedUser> map = this.storage;
        synchronized (map) {
            return this.shouldEnforce(this.newUsersCounter);
        }
    }

    private boolean shouldEnforce(int users) {
        return this.enforcementRule.shouldEnforce(users);
    }

    private static void applyEnforcement(String trackingHash, String identityHash) {
        throw new EnforcementException("Daily active user limit exceeded. Enforcement applied to user " + trackingHash + (identityHash != null ? " with identity " + identityHash : ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publishUpdates(PublishingPhase phase) {
        LOGGER.debug("Publishing {} DAU updates", (Object)phase);
        if (phase != PublishingPhase.START) {
            Map<String, TrackedUser> map = this.storage;
            synchronized (map) {
                this.publishingTask.addAll(this.storage.values());
                this.newUsersCounter = 0;
                if (phase == PublishingPhase.STOP) {
                    this.clearStorage();
                } else {
                    this.flushInactiveUsers();
                }
            }
        }
        this.publishingTask.cancelRetry();
        try {
            this.updateEnforcementRule(this.publishingTask.apply(phase), Instant.now());
        }
        catch (Exception ex) {
            if (phase == PublishingPhase.START && ex instanceof LicenseException) {
                throw (LicenseException)ex;
            }
            this.publishingTask.retry(phase, 1, ex);
        }
    }

    private void clearStorage() {
        this.storage.clear();
        this.blockedUsers.clear();
    }

    private void flushInactiveUsers() {
        ZonedDateTime dateTimeNowUTC = Instant.now().atZone(ZoneId.of("UTC"));
        Instant midnightUTC = dateTimeNowUTC.toLocalDate().atStartOfDay().toInstant(ZoneOffset.UTC);
        HashSet removedUsers = new HashSet(this.storage.size());
        this.storage.entrySet().removeIf(entry -> {
            Instant creationTime = ((TrackedUser)entry.getValue()).getCreationTime();
            boolean removed = creationTime.isBefore(midnightUTC);
            if (removed) {
                removedUsers.add(entry.getKey());
            }
            return removed;
        });
        this.blockedUsers.entrySet().removeIf(entry -> removedUsers.contains(entry.getKey()));
    }

    private void updateEnforcementRule(DAUServerResponse serverResponse, Instant publishingTime) {
        EnforcementRule enforcementRule = serverResponse.getEnforcementRule();
        if (enforcementRule != null && (this.enforcementRuleUpdatedAt == null || this.enforcementRuleUpdatedAt.isBefore(publishingTime))) {
            this.enforcementRule = enforcementRule;
            if (!enforcementRule.isActiveEnforcement()) {
                this.blockedUsers.clear();
            }
            this.enforcementRuleUpdatedAt = publishingTime;
            if (serverResponse.getTrackedUsers() != null && !serverResponse.getTrackedUsers().isEmpty()) {
                this.storage.putAll(serverResponse.getTrackedUsers().stream().collect(Collectors.toMap(TrackedUser::getTrackingHash, Function.identity())));
            }
            LOGGER.debug("Publishing DAU updates completed: {}", (Object)enforcementRule);
        }
    }

    void checkSubscriptionKey() {
        try {
            this.publisher.publish("vaadin-license-checker", Collections.emptySet(), PublishingPhase.CHECK);
        }
        catch (LicenseException ex) {
            throw ex;
        }
        catch (PublishingException ex) {
            Throwable cause = ex.getCause();
            if (cause != null) {
                throw new LicenseValidationException(ex.getMessage(), cause);
            }
            throw new LicenseValidationException(ex.getMessage());
        }
        catch (Exception ex) {
            throw new LicenseException(ex.getMessage(), ex);
        }
    }

    private static ThreadFactory dauThreadFactory() {
        ThreadFactory wrapped = Executors.defaultThreadFactory();
        return r -> {
            Thread thread = wrapped.newThread(r);
            thread.setName("DAU-Publisher-" + thread.getId());
            return thread;
        };
    }

    static /* synthetic */ String access$000() {
        return LICENSE_SERVER_URL;
    }

    static class PublishingSettings {
        private final Duration publishingInterval;
        private final Duration retryInterval;

        PublishingSettings(Duration publishingInterval, Duration retryInterval) {
            this.publishingInterval = Objects.requireNonNull(publishingInterval, "publishingInterval must not be null");
            this.retryInterval = Objects.requireNonNull(retryInterval, "retryInterval must not be null");
        }
    }

    private class PublishingTask
    implements Function<PublishingPhase, DAUServerResponse> {
        private final List<TrackedUser> unsentData = new ArrayList<TrackedUser>();
        private CompletableFuture<DAUServerResponse> retryFuture;
        private Long lastDelay;

        private PublishingTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addAll(Collection<TrackedUser> data) {
            List<TrackedUser> list = this.unsentData;
            synchronized (list) {
                this.unsentData.addAll(data);
            }
        }

        private CompletableFuture<DAUServerResponse> scheduleNextAttempt(int attempt, PublishingPhase phase, LongConsumer logger) {
            long retryDelay;
            long defaultDelay = DauStorage.this.publishingSettings.retryInterval.toMillis();
            if (DauStorage.this.shouldEnforce()) {
                retryDelay = defaultDelay;
            } else {
                long maxDelay = DauStorage.this.publishingSettings.publishingInterval.toMillis() / 2L;
                retryDelay = this.lastDelay != null ? this.lastDelay : defaultDelay;
                retryDelay += (long)((double)((long)(attempt - 1) * defaultDelay) * 0.5);
                retryDelay = Math.min(retryDelay, maxDelay);
                this.lastDelay = retryDelay;
            }
            logger.accept(retryDelay);
            long finalDelay = retryDelay;
            Executor delayedExecutor = command -> DauStorage.this.executorService.schedule(command, finalDelay, TimeUnit.MILLISECONDS);
            return CompletableFuture.supplyAsync(() -> DauStorage.this.publishingTask.apply(phase), delayedExecutor);
        }

        private void retry(PublishingPhase phase, int attempt, Throwable error) {
            if (phase == PublishingPhase.STOP) {
                LOGGER.warn("Failed to publish {} DAU updates.", (Object)phase, (Object)error);
                return;
            }
            Instant publishingTime = Instant.now();
            this.retryFuture = this.scheduleNextAttempt(attempt, phase, retryDelay -> {
                if (phase == PublishingPhase.ENFORCE) {
                    LOGGER.warn("Enforcement is ON. Scheduling re-check attempt {} at {}", (Object)attempt, (Object)LocalTime.now().plus(retryDelay, ChronoUnit.MILLIS));
                } else {
                    LOGGER.warn("Attempt {} to publish {} DAU updates failed. Scheduling retry at {}", new Object[]{attempt, phase, LocalTime.now().plus(retryDelay, ChronoUnit.MILLIS), error});
                }
            });
            this.retryFuture.whenComplete((result, ex) -> {
                if (ex instanceof CancellationException) {
                    return;
                }
                if (ex != null) {
                    this.retry(phase, attempt + 1, (Throwable)ex);
                } else {
                    this.cancelRetry();
                    DauStorage.this.updateEnforcementRule(result, publishingTime);
                    if (phase == PublishingPhase.ENFORCE && DauStorage.this.shouldEnforce()) {
                        this.retry(phase, attempt + 1, null);
                    }
                }
            });
        }

        private void cancelRetry() {
            if (this.retryFuture != null && !this.retryFuture.isDone()) {
                LOGGER.debug("Retry request cancelled");
                this.retryFuture.cancel(true);
            }
            this.lastDelay = null;
            this.retryFuture = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DAUServerResponse apply(PublishingPhase phase) {
            ArrayList<TrackedUser> copy;
            Object object = this.unsentData;
            synchronized (object) {
                copy = new ArrayList<TrackedUser>(this.unsentData);
                this.unsentData.clear();
            }
            try {
                object = DauStorage.this.publisher.publish(DauStorage.this.applicationName, copy, phase);
                return object;
            }
            catch (Exception ex) {
                List<TrackedUser> list = this.unsentData;
                synchronized (list) {
                    this.unsentData.addAll(0, copy);
                }
                if (ex instanceof PublishingException || ex instanceof LicenseException) {
                    throw ex;
                }
                throw new PublishingException("Publishing failed with an unexpected exception", ex);
            }
            finally {
                copy.clear();
            }
        }

        private void checkEnforcementUpdates() {
            this.cancelRetry();
            this.retry(PublishingPhase.ENFORCE, 1, null);
        }
    }

    private static class Holder {
        private static DauStorage INSTANCE = new DauStorage(new LicenseServerPublisher(DauStorage.access$000()), new PublishingSettings(Duration.ofHours(24L), Duration.ofMinutes(5L)));

        private Holder() {
        }
    }
}

