/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexTxAware;
import com.orientechnologies.orient.core.index.OIndexTxAwareMultiValue;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientElementIterable;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tinkerpop.blueprints.util.StringFactory;
import com.tinkerpop.blueprints.util.WrappingCloseableIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class OrientIndex<T extends OrientElement>
implements Index<T> {
    protected static final String VERTEX = "Vertex";
    protected static final String EDGE = "Edge";
    protected static final String CONFIG_CLASSNAME = "blueprintsIndexClass";
    protected static final String SEPARATOR = "!=!";
    protected OrientBaseGraph graph;
    protected OIndex<?> underlying;
    protected Class<? extends Element> indexClass;

    protected OrientIndex(OrientBaseGraph graph, String indexName, Class<? extends Element> indexClass, OType iType) {
        this.graph = graph;
        this.indexClass = indexClass;
        this.create(indexName, this.indexClass, iType);
    }

    protected OrientIndex(OrientBaseGraph orientGraph, OIndex<?> rawIndex) {
        this.graph = orientGraph;
        this.underlying = rawIndex instanceof OIndexTxAwareMultiValue ? rawIndex : new OIndexTxAwareMultiValue((ODatabaseRecord)orientGraph.getRawGraph(), (OIndex)rawIndex);
        this.load(rawIndex.getConfiguration());
    }

    public OIndex<?> getRawIndex() {
        return this.underlying;
    }

    public String getIndexName() {
        return this.underlying.getName();
    }

    public Class<T> getIndexClass() {
        return this.indexClass;
    }

    public void put(String key, Object value, T element) {
        String keyTemp = key + SEPARATOR + value;
        ODocument doc = ((OrientElement)element).getRecord();
        if (!doc.getIdentity().isValid()) {
            doc.save();
        }
        this.graph.autoStartTransaction();
        this.underlying.put((Object)keyTemp, (OIdentifiable)doc);
    }

    public CloseableIterable<T> get(String key, Object iValue) {
        String keyTemp = key + SEPARATOR + iValue;
        ArrayList<OIdentifiable> records = null;
        if (this.underlying instanceof OIndexTxAware) {
            try {
                records = (Collection)this.underlying.get((Object)keyTemp);
            }
            catch (NullPointerException e) {
                records = new ArrayList<OIdentifiable>();
            }
            OTransactionIndexChanges indexChanges = this.graph.getRawGraph().getTransaction().getIndexChanges(this.underlying.getName());
            if (indexChanges != null) {
                OTransactionIndexChangesPerKey value;
                if (indexChanges.containsChangesPerKey((Object)keyTemp) && (value = indexChanges.getChangesPerKey((Object)keyTemp)) != null) {
                    for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : value.entries) {
                        if (entry.operation == OTransactionIndexChanges.OPERATION.REMOVE) {
                            if (entry.value == null) {
                                records.clear();
                                break;
                            }
                            records.remove(entry.value);
                            continue;
                        }
                        if (entry.operation != OTransactionIndexChanges.OPERATION.PUT) continue;
                        records.add(entry.value);
                    }
                }
                if (indexChanges.containsChangesCrossKey() && (value = indexChanges.getChangesCrossKey()) != null) {
                    for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : value.entries) {
                        if (entry.operation == OTransactionIndexChanges.OPERATION.REMOVE) {
                            if (entry.value == null) {
                                records.clear();
                                break;
                            }
                            records.remove(entry.value);
                            continue;
                        }
                        if (entry.operation != OTransactionIndexChanges.OPERATION.PUT) continue;
                        records.add(entry.value);
                    }
                }
            }
            Iterator it = records.iterator();
            while (it.hasNext()) {
                if (it.next() != null) continue;
                it.remove();
            }
        } else {
            records = (ArrayList<OIdentifiable>)this.underlying.get((Object)keyTemp);
        }
        if (records == null || records.isEmpty()) {
            return new WrappingCloseableIterable(Collections.emptySet());
        }
        return new OrientElementIterable(this.graph, records);
    }

    public CloseableIterable<T> query(String key, Object query) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public long count(String key, Object value) {
        String keyTemp = key + SEPARATOR + value;
        Collection records = (Collection)this.underlying.get((Object)keyTemp);
        return records.size();
    }

    public void remove(String key, Object value, T element) {
        String keyTemp = key + SEPARATOR + value;
        this.graph.autoStartTransaction();
        try {
            this.underlying.remove((Object)keyTemp, (OIdentifiable)((OrientElement)element).getRecord());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected void putBasic(String key, T element) {
        this.underlying.put((Object)key, (OIdentifiable)((OrientElement)element).getRecord());
    }

    public String toString() {
        return StringFactory.indexString((Index)this);
    }

    protected void removeElement(T vertex) {
        this.graph.autoStartTransaction();
        ODocument vertexDoc = ((OrientElement)vertex).getRecord();
        this.underlying.remove((OIdentifiable)vertexDoc);
    }

    private void create(String indexName, Class<? extends Element> indexClass, OType iKeyType) {
        this.indexClass = indexClass;
        if (iKeyType == null) {
            iKeyType = OType.STRING;
        }
        this.underlying = new OIndexTxAwareMultiValue((ODatabaseRecord)this.graph.getRawGraph(), this.graph.getRawGraph().getMetadata().getIndexManager().createIndex(indexName, OClass.INDEX_TYPE.NOTUNIQUE.toString(), (OIndexDefinition)new OSimpleKeyIndexDefinition(new OType[]{iKeyType}), null, null));
        String className = Vertex.class.isAssignableFrom(indexClass) ? VERTEX : (Edge.class.isAssignableFrom(indexClass) ? EDGE : indexClass.getName());
        this.underlying.getConfiguration().field(CONFIG_CLASSNAME, (Object)className);
    }

    private void load(ODocument indexConfiguration) {
        String indexClassName = (String)indexConfiguration.field(CONFIG_CLASSNAME);
        if (VERTEX.equals(indexClassName)) {
            this.indexClass = OrientVertex.class;
        } else if (EDGE.equals(indexClassName)) {
            this.indexClass = OrientEdge.class;
        } else {
            try {
                this.indexClass = Class.forName(indexClassName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Index class '" + indexClassName + "' is not registered. Supported ones: Vertex, Edge and custom class that extends them");
            }
        }
    }

    public void close() {
        if (this.underlying != null) {
            this.underlying.flush();
            this.underlying = null;
        }
        this.graph = null;
    }
}

