/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.util.ElementHelper;
import java.util.Map;

public abstract class OrientElement
implements Element,
OSerializableStream,
OIdentifiable {
    private static final long serialVersionUID = 1L;
    public static final String LABEL_FIELD_NAME = "label";
    public static final Object DEF_ORIGINAL_ID_FIELDNAME = "origId";
    protected final OrientBaseGraph graph;
    protected OIdentifiable rawElement;

    protected OrientElement(OrientBaseGraph rawGraph, OIdentifiable iRawElement) {
        this.graph = rawGraph;
        this.rawElement = iRawElement;
    }

    public abstract String getBaseClassName();

    public abstract String getElementType();

    public void remove() {
        this.graph.autoStartTransaction();
        this.getRecord().delete();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T extends OrientElement> T setProperties(Object ... fields) {
        if (fields == null || fields.length <= 0 || fields[0] == null) return (T)this;
        this.graph.autoStartTransaction();
        if (fields.length == 1) {
            Object f = fields[0];
            if (!(f instanceof Map)) throw new IllegalArgumentException("Invalid fields: expecting a pairs of fields as String,Object or a single Map<String,Object>, but found: " + f);
            for (Map.Entry entry : ((Map)f).entrySet()) {
                OrientElement.setPropertyInternal(this, (ODocument)this.rawElement.getRecord(), entry.getKey().toString(), entry.getValue());
            }
            return (T)this;
        } else {
            for (int i = 0; i < fields.length; i += 2) {
                OrientElement.setPropertyInternal(this, (ODocument)this.rawElement.getRecord(), fields[i].toString(), fields[i + 1]);
            }
        }
        return (T)this;
    }

    public void setProperty(String key, Object value) {
        ElementHelper.validateProperty((Element)this, (String)key, (Object)value);
        this.graph.autoStartTransaction();
        this.getRecord().field(key, value);
        this.save();
    }

    public <T> T removeProperty(String key) {
        this.graph.autoStartTransaction();
        Object oldValue = this.getRecord().removeField(key);
        this.save();
        return (T)oldValue;
    }

    public <T> T getProperty(String key) {
        if (key == null) {
            return null;
        }
        if (key.equals("_class")) {
            return (T)this.getRecord().getSchemaClass().getName();
        }
        if (key.equals("_version")) {
            return (T)new Integer(this.getRecord().getVersion());
        }
        if (key.equals("_rid")) {
            return (T)this.rawElement.getIdentity().toString();
        }
        return (T)this.getRecord().field(key);
    }

    public Object getId() {
        return this.getIdentity();
    }

    public void save() {
        this.save(null);
    }

    public void save(String iClusterName) {
        if (this.rawElement instanceof ODocument) {
            if (iClusterName != null) {
                ((ODocument)this.rawElement).save(iClusterName);
            } else {
                ((ODocument)this.rawElement).save();
            }
        }
    }

    public int hashCode() {
        return this.rawElement == null ? 0 : this.rawElement.hashCode();
    }

    public byte[] toStream() throws OSerializationException {
        return this.rawElement.getIdentity().toString().getBytes();
    }

    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        ODocument record = this.getRecord();
        ((ORecordId)record.getIdentity()).fromString(new String(iStream));
        record.setInternalStatus(ORecordElement.STATUS.NOT_LOADED);
        return this;
    }

    public ORID getIdentity() {
        if (this.rawElement == null) {
            return ORecordId.EMPTY_RECORD_ID;
        }
        ORID rid = this.rawElement.getIdentity();
        if (!rid.isValid()) {
            this.graph.autoStartTransaction();
            this.save();
        }
        return rid;
    }

    public ODocument getRecord() {
        if (this.rawElement instanceof ODocument) {
            return (ODocument)this.rawElement;
        }
        ODocument doc = (ODocument)this.rawElement.getRecord();
        if (doc == null) {
            return null;
        }
        this.rawElement = doc;
        return doc;
    }

    public boolean equals(Object object) {
        return ElementHelper.areEqual((Element)this, (Object)object);
    }

    public int compare(OIdentifiable iFirst, OIdentifiable iSecond) {
        if (iFirst == null || iSecond == null) {
            return -1;
        }
        return iFirst.compareTo((Object)iSecond);
    }

    public int compareTo(OIdentifiable iOther) {
        if (iOther == null) {
            return 1;
        }
        ORID myRID = this.getIdentity();
        ORID otherRID = iOther.getIdentity();
        if (myRID == null && otherRID == null) {
            return 0;
        }
        return myRID.compareTo((Object)otherRID);
    }

    protected void checkClass() {
        ODocument doc = this.getRecord();
        doc.deserializeFields(new String[0]);
        OClass cls = doc.getSchemaClass();
        if (cls == null || !cls.isSubClassOf(this.getBaseClassName())) {
            throw new IllegalArgumentException("The document received is not a " + this.getElementType() + ". Found class '" + cls + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String checkForClassInSchema(String iClassName) {
        if (iClassName == null) {
            return null;
        }
        OSchema schema = this.graph.getRawGraph().getMetadata().getSchema();
        if (!schema.existsClass(iClassName)) {
            boolean txActive = this.graph.getRawGraph().getTransaction().isActive();
            try {
                if (txActive) {
                    OLogManager.instance().warn((Object)this, "Committing the active transaction to create the new type '%s' as subclass of '%s'. The transaction will be reopen right after that. To avoid this behavior create the classes outside the transaction", new Object[]{iClassName, this.getBaseClassName()});
                    this.graph.commit();
                }
                schema.createClass(iClassName, schema.getClass(this.getBaseClassName()));
                return iClassName;
            }
            catch (OSchemaException e) {
                if (schema.existsClass(iClassName)) return iClassName;
                throw e;
            }
            finally {
                if (txActive) {
                    this.graph.autoStartTransaction();
                }
            }
        } else {
            OClass cls = schema.getClass(iClassName);
            if (cls.isSubClassOf(this.getBaseClassName())) return iClassName;
            throw new IllegalArgumentException("Class '" + iClassName + "' is not an instance of " + this.getBaseClassName());
        }
    }

    protected static void setPropertyInternal(Element element, ODocument doc, String key, Object value) {
        ElementHelper.validateProperty((Element)element, (String)key, (Object)value);
        doc.field(key, value);
    }

    public OrientBaseGraph getGraph() {
        return this.graph;
    }
}

