/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.util.wrappers.readonly;

import com.tinkerpop.blueprints.pgm.CloseableSequence;
import com.tinkerpop.blueprints.pgm.Element;
import com.tinkerpop.blueprints.pgm.Index;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.StringFactory;
import com.tinkerpop.blueprints.pgm.util.wrappers.readonly.util.ReadOnlyEdgeSequence;
import com.tinkerpop.blueprints.pgm.util.wrappers.readonly.util.ReadOnlyVertexSequence;

public class ReadOnlyIndex<T extends Element>
implements Index<T> {
    protected final Index<T> rawIndex;

    public ReadOnlyIndex(Index<T> rawIndex) {
        this.rawIndex = rawIndex;
    }

    @Override
    public void remove(String key, Object value, T element) {
        throw new UnsupportedOperationException("It is not possible to mutate a ReadOnlyGraph");
    }

    @Override
    public void put(String key, Object value, T element) {
        throw new UnsupportedOperationException("It is not possible to mutate a ReadOnlyGraph");
    }

    @Override
    public CloseableSequence<T> get(String key, Object value) {
        if (Vertex.class.isAssignableFrom(this.getIndexClass())) {
            return new ReadOnlyVertexSequence(this.rawIndex.get(key, value).iterator());
        }
        return new ReadOnlyEdgeSequence(this.rawIndex.get(key, value).iterator());
    }

    @Override
    public long count(String key, Object value) {
        return this.rawIndex.count(key, value);
    }

    @Override
    public Index.Type getIndexType() {
        return Index.Type.MANUAL;
    }

    @Override
    public String getIndexName() {
        return this.rawIndex.getIndexName();
    }

    @Override
    public Class<T> getIndexClass() {
        return this.rawIndex.getIndexClass();
    }

    public String toString() {
        return StringFactory.indexString(this);
    }
}

