/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.util.wrappers.event.listener;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Graph;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.util.wrappers.event.listener.GraphChangedListener;

public class ConsoleGraphChangedListener
implements GraphChangedListener {
    private final Graph graph;

    public ConsoleGraphChangedListener(Graph graph) {
        this.graph = graph;
    }

    @Override
    public void vertexAdded(Vertex vertex) {
        System.out.println("Vertex [" + vertex.toString() + "] added to graph [" + this.graph.toString() + "]");
    }

    @Override
    public void vertexPropertyChanged(Vertex vertex, String key, Object setValue) {
        System.out.println("Vertex [" + vertex.toString() + "] property [" + key + "] set to value of [" + setValue + "] in graph [" + this.graph.toString() + "]");
    }

    @Override
    public void vertexPropertyRemoved(Vertex vertex, String key, Object removedValue) {
        System.out.println("Vertex [" + vertex.toString() + "] property [" + key + "] with value of [" + removedValue + "] removed in graph [" + this.graph.toString() + "]");
    }

    @Override
    public void vertexRemoved(Vertex vertex) {
        System.out.println("Vertex [" + vertex.toString() + "] removed from graph [" + this.graph.toString() + "]");
    }

    @Override
    public void edgeAdded(Edge edge) {
        System.out.println("Edge [" + edge.toString() + "] added to graph [" + this.graph.toString() + "]");
    }

    @Override
    public void edgePropertyChanged(Edge edge, String key, Object setValue) {
        System.out.println("Edge [" + edge.toString() + "] property [" + key + "] set to value of [" + setValue + "] in graph [" + this.graph.toString() + "]");
    }

    @Override
    public void edgePropertyRemoved(Edge edge, String key, Object removedValue) {
        System.out.println("Edge [" + edge.toString() + "] property [" + key + "] with value of [" + removedValue + "] removed in graph [" + this.graph.toString() + "]");
    }

    @Override
    public void edgeRemoved(Edge edge) {
        System.out.println("Edge [" + edge.toString() + "] removed from graph [" + this.graph.toString() + "]");
    }

    @Override
    public void graphCleared() {
        System.out.println("Graph [" + this.graph.toString() + "] cleared.");
    }
}

