/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.util.io.graphml;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Element;
import com.tinkerpop.blueprints.pgm.Graph;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.util.io.graphml.GraphMLWriterHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class GraphMLWriter {
    private final Graph graph;
    private boolean normalize = false;
    private Map<String, String> vertexKeyTypes = null;
    private Map<String, String> edgeKeyTypes = null;

    public GraphMLWriter(Graph graph) {
        this.graph = graph;
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public void setVertexKeyTypes(Map<String, String> vertexKeyTypes) {
        this.vertexKeyTypes = vertexKeyTypes;
    }

    public void setEdgeKeyTypes(Map<String, String> edgeKeyTypes) {
        this.edgeKeyTypes = edgeKeyTypes;
    }

    public void outputGraph(OutputStream graphMLOutputStream) throws IOException {
        if (null == this.vertexKeyTypes || null == this.edgeKeyTypes) {
            HashMap<String, String> vertexKeyTypes = new HashMap<String, String>();
            HashMap<String, String> edgeKeyTypes = new HashMap<String, String>();
            for (Vertex vertex : this.graph.getVertices()) {
                for (String string : vertex.getPropertyKeys()) {
                    if (vertexKeyTypes.containsKey(string)) continue;
                    vertexKeyTypes.put(string, GraphMLWriter.getStringType(vertex.getProperty(string)));
                }
                for (Edge edge : vertex.getOutEdges(new String[0])) {
                    for (String key : edge.getPropertyKeys()) {
                        if (edgeKeyTypes.containsKey(key)) continue;
                        edgeKeyTypes.put(key, GraphMLWriter.getStringType(edge.getProperty(key)));
                    }
                }
            }
            if (null == this.vertexKeyTypes) {
                this.vertexKeyTypes = vertexKeyTypes;
            }
            if (null == this.edgeKeyTypes) {
                this.edgeKeyTypes = edgeKeyTypes;
            }
        }
        XMLOutputFactory inputFactory = XMLOutputFactory.newInstance();
        try {
            Iterable<Object> vertices;
            Collection<Object> keyset;
            XMLStreamWriter writer = inputFactory.createXMLStreamWriter(graphMLOutputStream, "UTF8");
            if (this.normalize) {
                writer = new GraphMLWriterHelper.IndentingXMLStreamWriter(writer);
                ((GraphMLWriterHelper.IndentingXMLStreamWriter)writer).setIndentStep("    ");
            }
            writer.writeStartDocument();
            writer.writeStartElement("graphml");
            writer.writeAttribute("xmlns", "http://graphml.graphdrawing.org/xmlns");
            if (this.normalize) {
                keyset = new LinkedList();
                keyset.addAll(this.vertexKeyTypes.keySet());
                Collections.sort((List)keyset);
            } else {
                keyset = this.vertexKeyTypes.keySet();
            }
            for (String string : keyset) {
                writer.writeStartElement("key");
                writer.writeAttribute("id", string);
                writer.writeAttribute("for", "node");
                writer.writeAttribute("attr.name", string);
                writer.writeAttribute("attr.type", this.vertexKeyTypes.get(string));
                writer.writeEndElement();
            }
            if (this.normalize) {
                keyset = new LinkedList();
                keyset.addAll(this.edgeKeyTypes.keySet());
                Collections.sort((List)keyset);
            } else {
                keyset = this.edgeKeyTypes.keySet();
            }
            for (String string : keyset) {
                writer.writeStartElement("key");
                writer.writeAttribute("id", string);
                writer.writeAttribute("for", "edge");
                writer.writeAttribute("attr.name", string);
                writer.writeAttribute("attr.type", this.edgeKeyTypes.get(string));
                writer.writeEndElement();
            }
            writer.writeStartElement("graph");
            writer.writeAttribute("id", "G");
            writer.writeAttribute("edgedefault", "directed");
            if (this.normalize) {
                vertices = new LinkedList();
                for (Vertex vertex : this.graph.getVertices()) {
                    ((Collection)vertices).add(vertex);
                }
                Collections.sort((List)vertices, new ElementComparator());
            } else {
                vertices = this.graph.getVertices();
            }
            for (Vertex vertex : vertices) {
                Collection<String> keys;
                writer.writeStartElement("node");
                writer.writeAttribute("id", vertex.getId().toString());
                if (this.normalize) {
                    keys = new LinkedList();
                    keys.addAll(vertex.getPropertyKeys());
                    Collections.sort((List)keys);
                } else {
                    keys = vertex.getPropertyKeys();
                }
                for (String key : keys) {
                    writer.writeStartElement("data");
                    writer.writeAttribute("key", key);
                    Object value = vertex.getProperty(key);
                    if (null != value) {
                        writer.writeCharacters(value.toString());
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (this.normalize) {
                LinkedList<Edge> linkedList = new LinkedList<Edge>();
                for (Vertex vertex : this.graph.getVertices()) {
                    for (Edge edge : vertex.getOutEdges(new String[0])) {
                        linkedList.add(edge);
                    }
                }
                Collections.sort(linkedList, new ElementComparator());
                for (Edge edge : linkedList) {
                    writer.writeStartElement("edge");
                    writer.writeAttribute("id", edge.getId().toString());
                    writer.writeAttribute("source", edge.getOutVertex().getId().toString());
                    writer.writeAttribute("target", edge.getInVertex().getId().toString());
                    writer.writeAttribute("label", edge.getLabel());
                    LinkedList<String> keys = new LinkedList<String>();
                    keys.addAll(edge.getPropertyKeys());
                    Collections.sort(keys);
                    for (String key : keys) {
                        writer.writeStartElement("data");
                        writer.writeAttribute("key", key);
                        Object value = edge.getProperty(key);
                        if (null != value) {
                            writer.writeCharacters(value.toString());
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
            } else {
                for (Vertex vertex : this.graph.getVertices()) {
                    for (Edge edge : vertex.getOutEdges(new String[0])) {
                        writer.writeStartElement("edge");
                        writer.writeAttribute("id", edge.getId().toString());
                        writer.writeAttribute("source", edge.getOutVertex().getId().toString());
                        writer.writeAttribute("target", edge.getInVertex().getId().toString());
                        writer.writeAttribute("label", edge.getLabel());
                        for (String key : edge.getPropertyKeys()) {
                            writer.writeStartElement("data");
                            writer.writeAttribute("key", key);
                            Object value = edge.getProperty(key);
                            if (null != value) {
                                writer.writeCharacters(value.toString());
                            }
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                }
            }
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            writer.close();
        }
        catch (XMLStreamException xse) {
            throw new IOException(xse);
        }
    }

    public static void outputGraph(Graph graph, OutputStream graphMLOutputStream) throws IOException {
        GraphMLWriter writer = new GraphMLWriter(graph);
        writer.outputGraph(graphMLOutputStream);
    }

    public static void outputGraph(Graph graph, OutputStream graphMLOutputStream, Map<String, String> vertexKeyTypes, Map<String, String> edgeKeyTypes) throws IOException {
        GraphMLWriter writer = new GraphMLWriter(graph);
        writer.setVertexKeyTypes(vertexKeyTypes);
        writer.setEdgeKeyTypes(edgeKeyTypes);
        writer.outputGraph(graphMLOutputStream);
    }

    private static String getStringType(Object object) {
        if (object instanceof String) {
            return "string";
        }
        if (object instanceof Integer) {
            return "int";
        }
        if (object instanceof Long) {
            return "long";
        }
        if (object instanceof Float) {
            return "float";
        }
        if (object instanceof Number) {
            return "double";
        }
        if (object instanceof Boolean) {
            return "boolean";
        }
        return "string";
    }

    private static class ElementComparator
    implements Comparator<Element> {
        private ElementComparator() {
        }

        @Override
        public int compare(Element a, Element b) {
            return a.getId().toString().compareTo(b.getId().toString());
        }
    }
}

