/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestInternal;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import java.util.HashMap;
import java.util.List;

public class OServerCommandPostCommand
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"GET|command/*", "POST|command/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: command/<database>/<language>/<command-text>[/limit][/<fetchPlan>]");
        String language = urlParts.length > 2 ? urlParts[2].trim() : "sql";
        String text = urlParts.length > 3 ? urlParts[3].trim() : iRequest.content;
        int limit = urlParts.length > 4 ? Integer.parseInt(urlParts[4].trim()) : -1;
        String fetchPlan = urlParts.length > 5 ? urlParts[5] : null;
        String accept = iRequest.getHeader("accept");
        if (iRequest.content != null) {
            text = iRequest.content;
        }
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        iRequest.data.commandInfo = "Command";
        iRequest.data.commandDetail = text;
        ODatabaseDocumentTx db = null;
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            OCommandRequestText cmd = (OCommandRequestText)OCommandManager.instance().getRequester(language);
            cmd.setText(text);
            cmd.setLimit(limit);
            cmd.setFetchPlan(fetchPlan);
            OCommandExecutor executor = OCommandManager.instance().getExecutor((OCommandRequestInternal)cmd);
            executor.setContext(cmd.getContext());
            executor.setProgressListener(cmd.getProgressListener());
            executor.parse((OCommandRequest)cmd);
            if (!executor.isIdempotent() && iRequest.httpMethod.equals("GET")) {
                throw new OCommandExecutionException("Cannot execute non idempotent command using HTTP GET");
            }
            Object response = db.command((OCommandRequest)cmd).execute(new Object[0]);
            fetchPlan = executor.getFetchPlan();
            String format = null;
            if (iRequest.parameters.get("format") != null) {
                format = iRequest.parameters.get("format");
            }
            if (fetchPlan != null) {
                format = format != null ? format + ",fetchPlan:" + fetchPlan : "fetchPlan:" + fetchPlan;
            }
            HashMap<String, Object> additionalContent = null;
            List tips = (List)executor.getContext().getVariable("tips");
            if (tips != null) {
                additionalContent = new HashMap<String, Object>(1);
                additionalContent.put("warnings", tips);
            }
            iResponse.writeResult(response, format, accept, additionalContent);
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

