/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.query;

import com.orientechnologies.orient.core.command.OCommandContext;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;

public class QueryContext {
    public final OCommandContext context;
    public final IndexSearcher searcher;
    public final Query query;
    public final Filter filter;
    public final Sort sort;
    public QueryContextCFG cfg;
    public boolean facet = false;
    public boolean drillDown = false;
    public TaxonomyReader reader;
    private FacetsConfig facetConfig;
    private String facetField;
    private String drillDownQuery;

    public QueryContext(OCommandContext context, IndexSearcher searcher, Query query) {
        this(context, searcher, query, null, null);
    }

    public QueryContext(OCommandContext context, IndexSearcher searcher, Query query, Filter filter) {
        this(context, searcher, query, filter, null);
    }

    public QueryContext(OCommandContext context, IndexSearcher searcher, Query query, Filter filter, Sort sort) {
        this.context = context;
        this.searcher = searcher;
        this.query = query;
        this.filter = filter;
        this.sort = sort;
        this.initCFG();
    }

    private void initCFG() {
        this.cfg = this.filter != null && this.sort != null ? QueryContextCFG.FILTER_SORT : (this.filter == null && this.sort == null ? QueryContextCFG.NO_FILTER_NO_SORT : (this.filter != null ? QueryContextCFG.FILTER : QueryContextCFG.SORT));
    }

    public QueryContext setFacet(boolean facet) {
        this.facet = facet;
        return this;
    }

    public QueryContext setReader(TaxonomyReader reader) {
        this.reader = reader;
        return this;
    }

    public void setFacetConfig(FacetsConfig facetConfig) {
        this.facetConfig = facetConfig;
    }

    public FacetsConfig getFacetConfig() {
        return this.facetConfig;
    }

    public void setFacetField(String facetField) {
        this.facetField = facetField;
    }

    public String getFacetField() {
        return this.facetField;
    }

    public void setDrillDownQuery(String drillDownQuery) {
        this.drillDownQuery = drillDownQuery;
        this.drillDown = drillDownQuery != null;
    }

    public boolean isDrillDown() {
        return this.drillDown;
    }

    public String getDrillDownQuery() {
        return this.drillDownQuery;
    }

    public static enum QueryContextCFG {
        NO_FILTER_NO_SORT,
        FILTER_SORT,
        FILTER,
        SORT;

    }
}

