/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.manager;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.lucene.OLuceneIndexType;
import com.orientechnologies.lucene.OLuceneMapEntryIterator;
import com.orientechnologies.lucene.query.QueryContext;
import com.orientechnologies.lucene.utils.OLuceneIndexUtils;
import com.orientechnologies.orient.core.OOrientListener;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.OContextualRecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.TrackingIndexWriter;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.ControlledRealTimeReopenThread;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;

public abstract class OLuceneIndexManagerAbstract<V>
extends OSharedResourceAdaptiveExternal
implements OIndexEngine<V>,
OOrientListener {
    public static final String RID = "RID";
    public static final String KEY = "KEY";
    public static final String STORED = "_STORED";
    public static final Version LUCENE_VERSION = Version.LUCENE_47;
    public static final String OLUCENE_BASE_DIR = "luceneIndexes";
    protected SearcherManager searcherManager;
    protected OIndexDefinition index;
    protected TrackingIndexWriter mgrWriter;
    protected String indexName;
    protected String clusterIndexName;
    protected OStreamSerializer serializer;
    protected boolean automatic;
    protected ControlledRealTimeReopenThread nrt;
    protected ODocument metadata;
    protected Version version;
    private OIndex managedIndex;
    private boolean rebuilding;
    private long reopenToken;
    protected Map<String, Boolean> collectionFields = new HashMap<String, Boolean>();

    public OLuceneIndexManagerAbstract() {
        super(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean(), OGlobalConfiguration.MVRBTREE_TIMEOUT.getValueAsInteger(), true);
        Orient.instance().registerListener((OOrientListener)this);
    }

    public void create(OIndexDefinition indexDefinition, String clusterIndexName, OStreamSerializer valueSerializer, boolean isAutomatic) {
    }

    public void createIndex(OIndexDefinition indexDefinition, String clusterIndexName, OStreamSerializer valueSerializer, boolean isAutomatic, ODocument metadata) {
        this.initIndex(this.indexName, indexDefinition, clusterIndexName, valueSerializer, isAutomatic, metadata);
    }

    public abstract IndexWriter openIndexWriter(Directory var1, ODocument var2) throws IOException;

    public abstract IndexWriter createIndexWriter(Directory var1, ODocument var2) throws IOException;

    public void addDocument(Document doc) {
        try {
            this.reopenToken = this.mgrWriter.addDocument((Iterable)doc);
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on adding new document '%s' to Lucene index", (Throwable)e, new Object[]{doc});
        }
    }

    public void deleteDocument(Query query) {
        try {
            this.reopenToken = this.mgrWriter.deleteDocuments(query);
            if (!this.mgrWriter.getIndexWriter().hasDeletions()) {
                OLogManager.instance().error((Object)this, "Error on deleting document by query '%s' to Lucene index", (Throwable)new OIndexException("Error deleting document"), new Object[]{query});
            }
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on deleting document by query '%s' to Lucene index", (Throwable)e, new Object[]{query});
        }
    }

    public boolean remove(Object key, OIdentifiable value) {
        Query query = null;
        query = this.isCollectionDelete() ? OLuceneIndexType.createDeleteQuery(value, this.index.getFields(), key) : OLuceneIndexType.createQueryId(value);
        if (query != null) {
            this.deleteDocument(query);
        }
        return true;
    }

    public void commit() {
        try {
            this.mgrWriter.getIndexWriter().commit();
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on committing Lucene index", (Throwable)e, new Object[0]);
        }
    }

    public void deleteWithoutLoad(String indexName) {
        this.internalDelete(indexName);
    }

    protected void internalDelete(String indexName) {
        try {
            ODatabaseDocumentInternal database;
            OAbstractPaginatedStorage storageLocalAbstract;
            if (this.mgrWriter != null && this.mgrWriter.getIndexWriter() != null) {
                this.closeIndex();
            }
            if ((storageLocalAbstract = (OAbstractPaginatedStorage)(database = this.getDatabase()).getStorage().getUnderlying()) instanceof OLocalPaginatedStorage) {
                OLocalPaginatedStorage localAbstract = (OLocalPaginatedStorage)storageLocalAbstract;
                File f = new File(this.getIndexPath(localAbstract, indexName));
                OLuceneIndexUtils.deleteFolder(f);
                f = new File(this.getIndexBasePath(localAbstract));
                OLuceneIndexUtils.deleteFolderIfEmpty(f);
            }
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on deleting Lucene index", (Throwable)e, new Object[0]);
        }
    }

    public void delete() {
        if (this.mgrWriter == null) {
            return;
        }
        try {
            ODatabaseDocumentInternal database;
            OAbstractPaginatedStorage storageLocalAbstract;
            if (this.mgrWriter.getIndexWriter() != null) {
                this.closeIndex();
            }
            if ((storageLocalAbstract = (OAbstractPaginatedStorage)(database = this.getDatabase()).getStorage().getUnderlying()) instanceof OLocalPaginatedStorage) {
                File f = new File(this.getIndexPath((OLocalPaginatedStorage)storageLocalAbstract));
                OLuceneIndexUtils.deleteFolder(f);
                f = new File(this.getIndexBasePath((OLocalPaginatedStorage)storageLocalAbstract));
                OLuceneIndexUtils.deleteFolderIfEmpty(f);
            }
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on deleting Lucene index", (Throwable)e, new Object[0]);
        }
    }

    public Iterator<Map.Entry<Object, V>> iterator() {
        try {
            IndexReader reader = this.getSearcher().getIndexReader();
            return new OLuceneMapEntryIterator(reader, this.index);
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on creating iterator against Lucene index", (Throwable)e, new Object[0]);
            return new HashSet().iterator();
        }
    }

    public void clear() {
        try {
            this.mgrWriter.getIndexWriter().deleteAll();
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on clearing Lucene index", (Throwable)e, new Object[0]);
        }
    }

    public void flush() {
        try {
            this.mgrWriter.getIndexWriter().commit();
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on flushing Lucene index", (Throwable)e, new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.closeIndex();
        }
        catch (Throwable e) {
            OLogManager.instance().error((Object)this, "Error on closing Lucene index", e, new Object[0]);
        }
    }

    public void rollback() {
        try {
            this.mgrWriter.getIndexWriter().rollback();
            this.reOpen(this.metadata);
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on rolling back Lucene index", (Throwable)e, new Object[0]);
        }
    }

    public void load(String indexName, OIndexDefinition indexDefinition, OStreamSerializer valueSerializer, boolean isAutomatic) {
        this.initIndex(indexName, indexDefinition, null, valueSerializer, isAutomatic, this.metadata);
    }

    public void load(String indexName, OIndexDefinition indexDefinition, boolean isAutomatic, ODocument metadata) {
        this.initIndex(indexName, indexDefinition, null, null, isAutomatic, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size(OIndexEngine.ValuesTransformer<V> transformer) {
        IndexReader reader = null;
        IndexSearcher searcher = null;
        try {
            reader = this.getSearcher().getIndexReader();
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on getting size of Lucene index", (Throwable)e, new Object[0]);
        }
        finally {
            if (searcher != null) {
                this.release(searcher);
            }
        }
        return reader.numDocs();
    }

    public void release(IndexSearcher searcher) {
        try {
            this.searcherManager.release((Object)searcher);
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on releasing index searcher  of Lucene index", (Throwable)e, new Object[0]);
        }
    }

    public void setManagedIndex(OIndex index) {
        this.managedIndex = index;
    }

    public boolean isRebuilding() {
        return this.rebuilding;
    }

    public void setRebuilding(boolean rebuilding) {
        this.rebuilding = rebuilding;
    }

    public Analyzer getAnalyzer(ODocument metadata) {
        StandardAnalyzer analyzer = null;
        if (metadata != null && metadata.field("analyzer") != null) {
            String analyzerString = (String)metadata.field("analyzer");
            if (analyzerString != null) {
                try {
                    Class<?> classAnalyzer = Class.forName(analyzerString);
                    Constructor<?> constructor = classAnalyzer.getConstructor(Version.class);
                    analyzer = (Analyzer)constructor.newInstance(this.getLuceneVersion(metadata));
                }
                catch (ClassNotFoundException e) {
                    throw new OIndexException("Analyzer: " + analyzerString + " not found", (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    Class<?> classAnalyzer = null;
                    try {
                        classAnalyzer = Class.forName(analyzerString);
                        analyzer = (Analyzer)classAnalyzer.newInstance();
                    }
                    catch (Throwable e1) {
                        throw new OIndexException("Couldn't instantiate analyzer:  public constructor  not found", e1);
                    }
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Error on getting analyzer for Lucene index", (Throwable)e, new Object[0]);
                }
            }
        } else {
            analyzer = new StandardAnalyzer(this.getLuceneVersion(metadata));
        }
        return analyzer;
    }

    public Version getLuceneVersion(ODocument metadata) {
        if (this.version == null) {
            this.version = LUCENE_VERSION;
        }
        return this.version;
    }

    protected void initIndex(String indexName, OIndexDefinition indexDefinition, String clusterIndexName, OStreamSerializer valueSerializer, boolean isAutomatic, ODocument metadata) {
        this.index = indexDefinition;
        this.indexName = indexName;
        this.serializer = valueSerializer;
        this.automatic = isAutomatic;
        this.clusterIndexName = clusterIndexName;
        this.metadata = metadata;
        try {
            this.index = indexDefinition;
            this.checkCollectionIndex(indexDefinition);
            this.reOpen(metadata);
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on initializing Lucene index", (Throwable)e, new Object[0]);
        }
    }

    private void checkCollectionIndex(OIndexDefinition indexDefinition) {
        List fields = indexDefinition.getFields();
        OClass aClass = this.getDatabase().getMetadata().getSchema().getClass(indexDefinition.getClassName());
        for (String field : fields) {
            OProperty property = aClass.getProperty(field);
            if (property.getType().isEmbedded() && property.getLinkedType() != null) {
                this.collectionFields.put(field, true);
                continue;
            }
            this.collectionFields.put(field, false);
        }
    }

    protected Field.Store isToStore(String f) {
        return this.collectionFields.get(f) != false ? Field.Store.YES : Field.Store.NO;
    }

    protected boolean isCollectionDelete() {
        boolean collectionDelete = false;
        for (Boolean aBoolean : this.collectionFields.values()) {
            collectionDelete = collectionDelete || aBoolean != false;
        }
        return collectionDelete;
    }

    public IndexSearcher getSearcher() throws IOException {
        try {
            this.nrt.waitForGeneration(this.reopenToken);
        }
        catch (InterruptedException e) {
            OLogManager.instance().error((Object)this, "Error on get searcher from Lucene index", (Throwable)e, new Object[0]);
        }
        return (IndexSearcher)this.searcherManager.acquire();
    }

    protected void closeIndex() throws IOException {
        OLogManager.instance().debug((Object)this, "Closing Lucene index '" + this.indexName + "'...", new Object[0]);
        if (this.nrt != null) {
            this.nrt.interrupt();
            this.nrt.close();
        }
        if (this.searcherManager != null) {
            this.searcherManager.close();
        }
        if (this.mgrWriter != null) {
            this.mgrWriter.getIndexWriter().commit();
            this.mgrWriter.getIndexWriter().close();
        }
    }

    private void reOpen(ODocument metadata) throws IOException {
        ODatabaseDocumentInternal database = this.getDatabase();
        OAbstractPaginatedStorage storageLocalAbstract = (OAbstractPaginatedStorage)database.getStorage().getUnderlying();
        RAMDirectory dir = null;
        if (storageLocalAbstract instanceof OLocalPaginatedStorage) {
            String pathname = this.getIndexPath((OLocalPaginatedStorage)storageLocalAbstract);
            OLogManager.instance().debug((Object)this, "Opening NIOFS Lucene db=%s, path=%s", new Object[]{database.getName(), pathname});
            dir = NIOFSDirectory.open((File)new File(pathname));
        } else {
            OLogManager.instance().debug((Object)this, "Opening RAM Lucene index db=%s", new Object[]{database.getName()});
            dir = new RAMDirectory();
        }
        IndexWriter indexWriter = this.createIndexWriter((Directory)dir, metadata);
        this.mgrWriter = new TrackingIndexWriter(indexWriter);
        this.searcherManager = new SearcherManager(indexWriter, true, null);
        if (this.nrt != null) {
            this.nrt.close();
        }
        this.nrt = new ControlledRealTimeReopenThread(this.mgrWriter, (ReferenceManager)this.searcherManager, 60.0, 0.1);
        this.nrt.setDaemon(true);
        this.nrt.start();
        this.flush();
    }

    public void sendTotalHits(OCommandContext context, TopDocs docs) {
        if (context != null) {
            if (context.getVariable("totalHits") == null) {
                context.setVariable("totalHits", (Object)docs.totalHits);
            } else {
                context.setVariable("totalHits", null);
            }
            context.setVariable((this.indexName + ".totalHits").replace(".", "_"), (Object)docs.totalHits);
        }
    }

    public void sendLookupTime(OCommandContext context, final TopDocs docs, final Integer limit, long startFetching) {
        if (context != null) {
            final long finalTime = System.currentTimeMillis() - startFetching;
            context.setVariable((this.indexName + ".lookupTime").replace(".", "_"), (Object)new HashMap<String, Object>(){
                {
                    this.put("limit", limit);
                    this.put("totalTime", finalTime);
                    this.put("totalHits", docs.totalHits);
                    this.put("returnedHits", docs.scoreDocs.length);
                    this.put("maxScore", Float.valueOf(docs.getMaxScore()));
                }
            });
        }
    }

    private String getIndexPath(OLocalPaginatedStorage storageLocalAbstract, String indexName) {
        return storageLocalAbstract.getStoragePath() + File.separator + OLUCENE_BASE_DIR + File.separator + indexName;
    }

    private String getIndexPath(OLocalPaginatedStorage storageLocalAbstract) {
        return this.getIndexPath(storageLocalAbstract, this.indexName);
    }

    protected String getIndexBasePath(OLocalPaginatedStorage storageLocalAbstract) {
        return storageLocalAbstract.getStoragePath() + File.separator + OLUCENE_BASE_DIR;
    }

    protected ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    public OIndexCursor descCursor(OIndexEngine.ValuesTransformer<V> vValuesTransformer) {
        return null;
    }

    public abstract void onRecordAddedToResultSet(QueryContext var1, OContextualRecordId var2, Document var3, ScoreDoc var4);

    public int getVersion() {
        return 0;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void onShutdown() {
        this.close();
    }

    public void onStorageRegistered(OStorage storage) {
    }

    public void onStorageUnregistered(OStorage storage) {
    }

    public abstract Document buildDocument(Object var1, OIdentifiable var2);

    public abstract Query buildQuery(Object var1) throws ParseException;

    public abstract Analyzer analyzer(String var1);
}

