/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.lucene.OLuceneIndex;
import com.orientechnologies.lucene.OLuceneIndexEngine;
import com.orientechnologies.lucene.index.OLuceneFullTextIndex;
import com.orientechnologies.lucene.index.OLuceneSpatialIndex;
import com.orientechnologies.lucene.manager.OLuceneFullTextIndexManager;
import com.orientechnologies.lucene.manager.OLuceneSpatialIndexManager;
import com.orientechnologies.lucene.shape.OShapeFactoryImpl;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class OLuceneIndexFactory
implements OIndexFactory,
ODatabaseLifecycleListener {
    private static final Set<String> TYPES;
    private static final Set<String> ALGORITHMS;
    public static final String LUCENE_ALGORITHM = "LUCENE";

    public OLuceneIndexFactory() {
        this(false);
    }

    public OLuceneIndexFactory(boolean manual) {
        if (!manual) {
            Orient.instance().addDbLifecycleListener((ODatabaseLifecycleListener)this);
        }
    }

    public int getLastVersion() {
        return 0;
    }

    public Set<String> getTypes() {
        return TYPES;
    }

    public Set<String> getAlgorithms() {
        return ALGORITHMS;
    }

    public OIndexInternal<?> createIndex(String name, ODatabaseDocumentInternal database, String indexType, String algorithm, String valueContainerAlgorithm, ODocument metadata, int version) throws OConfigurationException {
        return this.createIndex(name, database, indexType, algorithm, valueContainerAlgorithm, metadata);
    }

    public ODatabaseLifecycleListener.PRIORITY getPriority() {
        return ODatabaseLifecycleListener.PRIORITY.REGULAR;
    }

    public void onCreate(ODatabaseInternal iDatabase) {
    }

    public void onOpen(ODatabaseInternal iDatabase) {
    }

    public void onClose(ODatabaseInternal iDatabase) {
    }

    public void onDrop(ODatabaseInternal iDatabase) {
        try {
            OLogManager.instance().debug((Object)this, "Dropping Lucene indexes...", new Object[0]);
            for (OIndex idx : iDatabase.getMetadata().getIndexManager().getIndexes()) {
                if (!(idx.getInternal() instanceof OLuceneIndex)) continue;
                OLogManager.instance().debug((Object)this, "- index '%s'", new Object[]{idx.getName()});
                idx.delete();
            }
        }
        catch (Exception e) {
            OLogManager.instance().warn((Object)this, "Error on dropping Lucene indexes", (Throwable)e, new Object[0]);
        }
    }

    public void onCreateClass(ODatabaseInternal iDatabase, OClass iClass) {
    }

    public void onDropClass(ODatabaseInternal iDatabase, OClass iClass) {
    }

    protected OIndexInternal<?> createIndex(String name, ODatabaseDocumentInternal oDatabaseRecord, String indexType, String algorithm, String valueContainerAlgorithm, ODocument metadata) throws OConfigurationException {
        return this.createLuceneIndex(name, oDatabaseRecord, indexType, valueContainerAlgorithm, metadata);
    }

    private OIndexInternal<?> createLuceneIndex(String name, ODatabaseDocumentInternal database, String indexType, String valueContainerAlgorithm, ODocument metadata) {
        OStorage storage = database.getStorage().getUnderlying();
        if (OClass.INDEX_TYPE.FULLTEXT.toString().equals(indexType)) {
            return new OLuceneFullTextIndex(name, indexType, LUCENE_ALGORITHM, new OLuceneIndexEngine(new OLuceneFullTextIndexManager(), indexType), valueContainerAlgorithm, metadata, storage);
        }
        if (OClass.INDEX_TYPE.SPATIAL.toString().equals(indexType)) {
            return new OLuceneSpatialIndex(name, indexType, LUCENE_ALGORITHM, new OLuceneIndexEngine(new OLuceneSpatialIndexManager(OShapeFactoryImpl.INSTANCE), indexType), valueContainerAlgorithm, metadata, storage);
        }
        throw new OConfigurationException("Unsupported type : " + indexType);
    }

    static {
        HashSet<String> types = new HashSet<String>();
        types.add(OClass.INDEX_TYPE.FULLTEXT.toString());
        types.add(OClass.INDEX_TYPE.SPATIAL.toString());
        TYPES = Collections.unmodifiableSet(types);
        HashSet<String> algorithms = new HashSet<String>();
        algorithms.add(LUCENE_ALGORITHM);
        ALGORITHMS = Collections.unmodifiableSet(algorithms);
    }
}

