/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.OMetadataDefault;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.storage.impl.local.OStorageRecoverEventListener;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientConfigurableGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.Collection;
import java.util.Iterator;

public class OGraphRepair {
    private OStorageRecoverEventListener eventListener;

    public void repair(OrientBaseGraph graph, OCommandOutputListener outputListener) {
        this.message(outputListener, "Repair of graph '" + graph.getRawGraph().getURL() + "' is started ...\n");
        long beginTime = System.currentTimeMillis();
        ORepairStats stats = new ORepairStats();
        this.repairEdges(graph, stats, outputListener);
        this.repairVertices(graph, stats, outputListener);
        this.message(outputListener, "Repair of graph '" + graph.getRawGraph().getURL() + "' completed in " + (System.currentTimeMillis() - beginTime / 1000L) + " secs\n");
        this.message(outputListener, " scannedEdges.....: " + stats.scannedEdges + "\n");
        this.message(outputListener, " removedEdges.....: " + stats.removedEdges + "\n");
        this.message(outputListener, " scannedVertices..: " + stats.scannedVertices + "\n");
        this.message(outputListener, " scannedLinks.....: " + stats.scannedLinks + "\n");
        this.message(outputListener, " removedLinks.....: " + stats.removedLinks + "\n");
        this.message(outputListener, " repairedVertices.: " + stats.repairedVertices + "\n");
    }

    protected void repairEdges(OrientBaseGraph graph, ORepairStats stats, OCommandOutputListener outputListener) {
        ODatabaseDocumentTx db = graph.getRawGraph();
        OMetadataDefault metadata = db.getMetadata();
        OSchema schema = metadata.getSchema();
        OrientConfigurableGraph.Settings settings = graph.settings;
        boolean useVertexFieldsForEdgeLabels = settings.isUseVertexFieldsForEdgeLabels();
        OClass edgeClass = schema.getClass("E");
        if (edgeClass != null) {
            long countEdges = db.countClass(edgeClass.getName());
            this.message(outputListener, "Scanning " + countEdges + " edges...\n");
            for (ODocument edge : db.browseClass(edgeClass.getName())) {
                ORID edgeId = edge.getIdentity();
                ++stats.scannedEdges;
                if (this.eventListener != null) {
                    this.eventListener.onScannedEdge(edge);
                }
                boolean removeEdge = false;
                OIdentifiable out = OrientEdge.getConnection(edge, Direction.OUT);
                if (out == null) {
                    removeEdge = true;
                } else {
                    String outFieldName;
                    Object outEdges;
                    ODocument outVertex = (ODocument)out.getRecord();
                    if (outVertex == null) {
                        removeEdge = true;
                    }
                    if ((outEdges = outVertex.field(outFieldName = OrientVertex.getConnectionFieldName(Direction.OUT, edge.getClassName(), useVertexFieldsForEdgeLabels))) == null) {
                        removeEdge = true;
                    } else if (outEdges instanceof ORidBag) {
                        if (!((ORidBag)outEdges).contains((OIdentifiable)edgeId)) {
                            removeEdge = true;
                        }
                    } else if (outEdges instanceof Collection) {
                        if (!((Collection)outEdges).contains(edgeId)) {
                            removeEdge = true;
                        }
                    } else if (outEdges instanceof OIdentifiable && ((OIdentifiable)outEdges).getIdentity().equals(edgeId)) {
                        removeEdge = true;
                    }
                }
                OIdentifiable in = OrientEdge.getConnection(edge, Direction.IN);
                if (in == null) {
                    removeEdge = true;
                } else {
                    String inFieldName;
                    Object inEdges;
                    ODocument inVertex = (ODocument)in.getRecord();
                    if (inVertex == null) {
                        removeEdge = true;
                    }
                    if ((inEdges = inVertex.field(inFieldName = OrientVertex.getConnectionFieldName(Direction.IN, edge.getClassName(), useVertexFieldsForEdgeLabels))) == null) {
                        removeEdge = true;
                    } else if (inEdges instanceof ORidBag) {
                        if (!((ORidBag)inEdges).contains((OIdentifiable)edgeId)) {
                            removeEdge = true;
                        }
                    } else if (inEdges instanceof Collection) {
                        if (!((Collection)inEdges).contains(edgeId)) {
                            removeEdge = true;
                        }
                    } else if (inEdges instanceof OIdentifiable && ((OIdentifiable)inEdges).getIdentity().equals(edgeId)) {
                        removeEdge = true;
                    }
                }
                if (!removeEdge) continue;
                try {
                    edge.delete();
                    ++stats.removedEdges;
                    if (this.eventListener == null) continue;
                    this.eventListener.onRemovedEdge(edge);
                }
                catch (Exception e) {
                    this.message(outputListener, "Error on deleting edge " + edge.getIdentity() + " (" + e.getMessage() + ")");
                }
            }
            this.message(outputListener, "Scanning edges completed\n");
        }
    }

    protected void repairVertices(OrientBaseGraph graph, ORepairStats stats, OCommandOutputListener outputListener) {
        ODatabaseDocumentTx db = graph.getRawGraph();
        OMetadataDefault metadata = db.getMetadata();
        OSchema schema = metadata.getSchema();
        OClass vertexClass = schema.getClass("V");
        if (vertexClass != null) {
            long countVertices = db.countClass(vertexClass.getName());
            this.message(outputListener, "Scanning " + countVertices + " vertices...\n");
            for (ODocument vertex : db.browseClass(vertexClass.getName())) {
                ++stats.scannedVertices;
                if (this.eventListener != null) {
                    this.eventListener.onScannedVertex(vertex);
                }
                OrientVertex v = new OrientVertex(graph, (OIdentifiable)vertex);
                boolean modifiedVertex = false;
                for (String fieldName : vertex.fieldNames()) {
                    Object o;
                    Iterator it;
                    Object fieldValue;
                    OPair<Direction, String> connection = v.getConnection(Direction.BOTH, fieldName, null);
                    if (connection == null || (fieldValue = vertex.rawField(fieldName)) == null) continue;
                    if (fieldValue instanceof OIdentifiable) {
                        if (!this.isEdgeBroken((OIdentifiable)vertex, fieldName, (Direction)connection.getKey(), (OIdentifiable)fieldValue, stats, graph.settings.isUseVertexFieldsForEdgeLabels())) continue;
                        modifiedVertex = true;
                        vertex.field(fieldName, null);
                        continue;
                    }
                    if (fieldValue instanceof Collection) {
                        Collection coll = (Collection)fieldValue;
                        it = coll.iterator();
                        while (it.hasNext()) {
                            o = it.next();
                            if (!this.isEdgeBroken((OIdentifiable)vertex, fieldName, (Direction)connection.getKey(), (OIdentifiable)o, stats, graph.settings.isUseVertexFieldsForEdgeLabels())) continue;
                            modifiedVertex = true;
                            it.remove();
                        }
                        continue;
                    }
                    if (!(fieldValue instanceof ORidBag)) continue;
                    ORidBag ridbag = (ORidBag)fieldValue;
                    it = ridbag.rawIterator();
                    while (it.hasNext()) {
                        o = it.next();
                        if (!this.isEdgeBroken((OIdentifiable)vertex, fieldName, (Direction)connection.getKey(), (OIdentifiable)o, stats, graph.settings.isUseVertexFieldsForEdgeLabels())) continue;
                        modifiedVertex = true;
                        it.remove();
                    }
                }
                if (!modifiedVertex) continue;
                ++stats.repairedVertices;
                if (this.eventListener != null) {
                    this.eventListener.onRepairedVertex(vertex);
                }
                vertex.save();
            }
            this.message(outputListener, "Scanning vertices completed\n");
        }
    }

    private void onScannedLink(ORepairStats stats, OIdentifiable fieldValue) {
        ++stats.scannedLinks;
        if (this.eventListener != null) {
            this.eventListener.onScannedLink(fieldValue);
        }
    }

    private void onRemovedLink(ORepairStats stats, OIdentifiable fieldValue) {
        ++stats.removedLinks;
        if (this.eventListener != null) {
            this.eventListener.onRemovedLink(fieldValue);
        }
    }

    public OStorageRecoverEventListener getEventListener() {
        return this.eventListener;
    }

    public OGraphRepair setEventListener(OStorageRecoverEventListener eventListener) {
        this.eventListener = eventListener;
        return this;
    }

    private void message(OCommandOutputListener outputListener, String message) {
        if (outputListener != null) {
            outputListener.onMessage(message);
        }
    }

    private boolean isEdgeBroken(OIdentifiable vertex, String fieldName, Direction direction, OIdentifiable edgeRID, ORepairStats stats, boolean useVertexFieldsForEdgeLabels) {
        this.onScannedLink(stats, edgeRID);
        boolean broken = false;
        if (edgeRID == null) {
            broken = true;
        } else {
            ODocument record = null;
            try {
                record = (ODocument)edgeRID.getIdentity().getRecord();
            }
            catch (ORecordNotFoundException e) {
                broken = true;
            }
            if (record == null) {
                broken = true;
            } else {
                OImmutableClass immutableClass = ODocumentInternal.getImmutableSchemaClass((ODocument)record);
                if (immutableClass == null || !immutableClass.isVertexType() && !immutableClass.isEdgeType()) {
                    broken = true;
                } else if (immutableClass.isVertexType()) {
                    String inverseFieldName = OrientVertex.getInverseConnectionFieldName(fieldName, useVertexFieldsForEdgeLabels);
                    Object inverseEdgeContainer = record.field(inverseFieldName);
                    if (inverseEdgeContainer == null) {
                        broken = true;
                    } else if (inverseEdgeContainer instanceof OIdentifiable) {
                        if (!inverseEdgeContainer.equals(vertex)) {
                            broken = true;
                        }
                    } else if (inverseEdgeContainer instanceof Collection) {
                        if (!((Collection)inverseEdgeContainer).contains(vertex)) {
                            broken = true;
                        }
                    } else if (inverseEdgeContainer instanceof ORidBag && !((ORidBag)inverseEdgeContainer).contains(vertex)) {
                        broken = true;
                    }
                } else {
                    OIdentifiable backRID = OrientEdge.getConnection(record, direction);
                    if (backRID == null || !backRID.equals(vertex)) {
                        broken = true;
                    }
                }
            }
        }
        if (broken) {
            this.onRemovedLink(stats, edgeRID);
            return true;
        }
        return false;
    }

    private class ORepairStats {
        long scannedEdges = 0L;
        long removedEdges = 0L;
        long scannedVertices = 0L;
        long scannedLinks = 0L;
        long removedLinks = 0L;
        long repairedVertices = 0L;

        private ORepairStats() {
        }
    }
}

