/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElementIterator;
import java.util.Iterator;

class OrientElementScanIterable<T extends Element>
implements CloseableIterable<T> {
    private final String elementClass;
    private final OrientBaseGraph graph;
    private final boolean polymorphic;

    public OrientElementScanIterable(OrientBaseGraph graph, String elementClass, boolean polymorphic) {
        this.graph = graph;
        this.elementClass = elementClass;
        this.polymorphic = polymorphic;
    }

    public Iterator<T> iterator() {
        ODatabaseDocumentTx rawGraph = this.graph.getRawGraph();
        return new OrientElementIterator(this.graph, (Iterator<?>)new ORecordIteratorClass((ODatabaseDocumentInternal)rawGraph, rawGraph, this.elementClass, this.polymorphic));
    }

    public void close() {
    }
}

