/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.EmptyStackException;
import java.util.Random;
import java.util.Stack;
import oracle.security.crypto.provider.JCEUtil;
import oracle.security.pki.BadPaddingException;
import oracle.security.pki.Cipher;
import oracle.security.pki.CipherSpi;
import oracle.security.pki.DESedeSecretKey;
import oracle.security.pki.IllegalBlockSizeException;
import oracle.security.pki.IvParameterSpec;
import oracle.security.pki.PBEParameterSpec;
import oracle.security.pki.ShortBufferException;

public class PBEwSHA1aDESedecbc
extends CipherSpi {
    private Cipher b;
    private AlgorithmParameters c;
    private static final int d = 24;
    private static final int e = 8;
    private static final int f = 20;
    static Stack a = new Stack();

    protected void a(String string) {
    }

    protected void b(String string) {
    }

    protected int b() {
        return this.b.getBlockSize();
    }

    protected int a(int n) {
        return this.b.getOutputSize(n);
    }

    protected byte[] c() {
        return this.b.getIV();
    }

    protected AlgorithmParameters d() {
        return this.b.getParameters();
    }

    protected void a(int n, Key key, Random random) throws InvalidKeyException {
        try {
            this.a(n, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InternalError(invalidAlgorithmParameterException.getMessage());
        }
    }

    protected void a(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, Random random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (key == null) {
            throw new InvalidKeyException("Missing password");
        }
        if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof PBEParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter is not PBEParameterSpec");
        }
        try {
            byte[] byArray;
            this.b = Cipher.getInstance("3DES/CBC/PKCS5Padding");
            if (algorithmParameterSpec == null) {
                if (random == null) {
                    random = new Random();
                }
                byArray = new byte[this.b.getBlockSize()];
                random.nextBytes(byArray);
                algorithmParameterSpec = new PBEParameterSpec(byArray, 12);
            }
            byArray = this.a(key, (PBEParameterSpec)algorithmParameterSpec);
            IvParameterSpec ivParameterSpec = this.b(byArray);
            DESedeSecretKey dESedeSecretKey = this.a(byArray);
            this.b.init(n, (Key)dESedeSecretKey, ivParameterSpec, random);
        }
        catch (Exception exception) {
            throw new InvalidAlgorithmParameterException(exception.getMessage());
        }
    }

    protected void a(int n, Key key, AlgorithmParameters algorithmParameters, Random random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameters != null && !algorithmParameters.getAlgorithm().equals("PBE")) {
            throw new InvalidAlgorithmParameterException("AlgorithmParameter is not of PBE");
        }
        try {
            this.c = algorithmParameters;
            AlgorithmParameterSpec algorithmParameterSpec = null;
            if (algorithmParameters != null) {
                Class<?> clazz = Class.forName("oracle.security.pki.PBEParamaterSpec");
                algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(clazz);
            }
            this.a(n, key, algorithmParameterSpec, random);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException("AlgorithmParameter is not of PBE");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InternalError("PBEParameterSpec is not found");
        }
    }

    protected byte[] a(byte[] byArray, int n, int n2) {
        return this.b.update(byArray, n, n2);
    }

    protected int a(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        return this.b.update(byArray, n, n2, byArray2, n3);
    }

    protected byte[] b(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        return this.b.doFinal(byArray, n, n2);
    }

    protected int b(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.b.doFinal(byArray, n, n2, byArray2, n3);
    }

    private byte[] a(Key key, PBEParameterSpec pBEParameterSpec) throws NoSuchAlgorithmException, IOException, InvalidKeyException {
        int n;
        int n2;
        int n3;
        byte[] byArray = pBEParameterSpec.getSalt();
        byte[] byArray2 = key.getEncoded();
        int n4 = pBEParameterSpec.getIterationCount();
        int n5 = this.b.getBlockSize();
        int n6 = 24 + n5;
        int n7 = 20;
        int n8 = (int)Math.ceil((double)n6 / (double)n7);
        int n9 = n6 - (n8 - 1) * n7;
        byte[] byArray3 = new byte[n6];
        byte[][] byArray4 = new byte[n8][n7];
        byte[][] byArray5 = new byte[n4][n7];
        byte[] byArray6 = new byte[byArray.length + 4];
        for (int i = 0; i < byArray.length; ++i) {
            byArray6[i] = byArray[i];
        }
        for (n3 = 0; n3 < n8; ++n3) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(n3);
            byte[] byArray7 = byteArrayOutputStream.toByteArray();
            for (n2 = 0; n2 < 4; ++n2) {
                byArray6[byArray.length + n2] = byArray7[n2];
            }
            byArray5[0] = PBEwSHA1aDESedecbc.a(byArray2, byArray6);
            for (n2 = 1; n2 < n4; ++n2) {
                byArray5[n2] = PBEwSHA1aDESedecbc.a(byArray2, byArray5[n2 - 1]);
            }
            for (n2 = 0; n2 < n7; ++n2) {
                byArray4[n3][n2] = byArray5[0][n2];
            }
            for (n2 = 1; n2 < n4; ++n2) {
                for (n = 0; n < n7; ++n) {
                    byte[] byArray8 = byArray4[n3];
                    int n10 = n;
                    byArray8[n10] = (byte)(byArray8[n10] ^ byArray5[n2][n]);
                }
            }
        }
        --n8;
        n3 = 0;
        for (n2 = 0; n2 < n8; ++n2) {
            for (n = 0; n < n7; ++n) {
                byArray3[n3++] = byArray4[n2][n];
            }
        }
        for (n2 = 0; n2 < n9; ++n2) {
            byArray3[n3++] = byArray4[n8][n2];
        }
        return byArray3;
    }

    private DESedeSecretKey a(byte[] byArray) {
        byte[] byArray2 = new byte[24];
        System.arraycopy(byArray, 0, byArray2, 0, 24);
        return new DESedeSecretKey(byArray2);
    }

    private IvParameterSpec b(byte[] byArray) {
        return new IvParameterSpec(byArray, byArray.length - 8, 8);
    }

    static byte[] a(byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException {
        int n;
        byte[] byArray3;
        MessageDigest messageDigest = null;
        try {
            if (!a.empty()) {
                messageDigest = (MessageDigest)a.pop();
            }
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        if (messageDigest == null) {
            messageDigest = JCEUtil.getMessageDigestInstance((String)"SHA");
        } else {
            messageDigest.reset();
        }
        byte[] byArray4 = new byte[64 + byArray2.length];
        byte[] byArray5 = new byte[84];
        if (byArray.length > 64) {
            messageDigest.reset();
            byArray3 = messageDigest.digest(byArray);
            byArray = byArray3;
        }
        for (n = 0; n < byArray.length; ++n) {
            byArray4[n] = (byte)(byArray[n] ^ 0x36);
            byArray5[n] = (byte)(byArray[n] ^ 0x5C);
        }
        for (n = byArray.length; n < 64; ++n) {
            byArray4[n] = 54;
            byArray5[n] = 92;
        }
        for (n = 0; n < byArray2.length; ++n) {
            byArray4[n + 64] = byArray2[n];
        }
        messageDigest.reset();
        byArray3 = messageDigest.digest(byArray4);
        n = 64;
        int n2 = 0;
        while (n < 84) {
            byArray5[n] = byArray3[n2];
            ++n;
            ++n2;
        }
        messageDigest.reset();
        byte[] byArray6 = messageDigest.digest(byArray5);
        a.push(messageDigest);
        return byArray6;
    }
}

