/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.WhoisRecord;
import com.microsoft.graph.security.requests.HostWithReferenceRequestBuilder;
import com.microsoft.graph.security.requests.WhoisHistoryRecordCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.security.requests.WhoisHistoryRecordWithReferenceRequestBuilder;
import com.microsoft.graph.security.requests.WhoisRecordRequest;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WhoisRecordRequestBuilder
extends BaseRequestBuilder<WhoisRecord> {
    public WhoisRecordRequestBuilder(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    @Nonnull
    public WhoisRecordRequest buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Nonnull
    public WhoisRecordRequest buildRequest(@Nonnull List<? extends Option> requestOptions) {
        return new WhoisRecordRequest(this.getRequestUrl(), this.getClient(), requestOptions);
    }

    @Nonnull
    public HostWithReferenceRequestBuilder host() {
        return new HostWithReferenceRequestBuilder(this.getRequestUrlWithAdditionalSegment("host"), this.getClient(), null);
    }

    @Nonnull
    public WhoisHistoryRecordCollectionWithReferencesRequestBuilder history() {
        return new WhoisHistoryRecordCollectionWithReferencesRequestBuilder(this.getRequestUrlWithAdditionalSegment("history"), this.getClient(), null);
    }

    @Nonnull
    public WhoisHistoryRecordWithReferenceRequestBuilder history(@Nonnull String id) {
        return new WhoisHistoryRecordWithReferenceRequestBuilder(this.getRequestUrlWithAdditionalSegment("history") + "/" + id, this.getClient(), null);
    }
}

