/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth;

import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.Configuration;
import com.google.common.base.Preconditions;
import com.microsoft.azure.toolkit.lib.AzService;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.auth.AzureEnvironmentUtils;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class AzureCloud
implements AzService {
    public List<AzureEnvironment> list() {
        return AzureEnvironment.knownEnvironments();
    }

    public List<String> listNames() {
        return AzureEnvironment.knownEnvironments().stream().map(AzureEnvironmentUtils::getCloudName).collect(Collectors.toList());
    }

    public AzureEnvironment get() {
        String cloud = Azure.az().config().getCloud();
        return StringUtils.isNotBlank((CharSequence)cloud) ? AzureEnvironmentUtils.stringToAzureEnvironment(cloud) : null;
    }

    public String getName() {
        AzureEnvironment env = this.get();
        return env == null ? null : AzureEnvironmentUtils.getCloudName(env);
    }

    public void refresh() {
    }

    public AzureEnvironment getOrDefault() {
        return (AzureEnvironment)ObjectUtils.firstNonNull((Object[])new AzureEnvironment[]{this.get(), AzureEnvironment.AZURE});
    }

    public AzureCloud set(AzureEnvironment environment) {
        Objects.requireNonNull(environment, "Azure environment shall not be null.");
        Configuration.getGlobalConfiguration().put("AZURE_AUTHORITY_HOST", environment.getActiveDirectoryEndpoint());
        AzureConfiguration az = Azure.az().config();
        if (StringUtils.isNotBlank((CharSequence)az.getProxySource())) {
            String proxyAuthPrefix = "";
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{az.getProxyUsername(), az.getProxyPassword()})) {
                proxyAuthPrefix = az.getProxyUsername() + ":" + az.getProxyPassword() + "@";
            }
            String proxy = String.format("http://%s%s:%d", proxyAuthPrefix, az.getHttpProxyHost(), az.getHttpProxyPort());
            Configuration.getGlobalConfiguration().put("HTTP_PROXY", proxy);
            Configuration.getGlobalConfiguration().put("HTTPS_PROXY", proxy);
        }
        String cloud = AzureEnvironmentUtils.getCloudName(environment);
        Azure.az().config().setCloud(cloud);
        return this;
    }

    public AzureCloud setByName(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (Object)"Azure environment name shall not be null.");
        return this.set(AzureEnvironmentUtils.stringToAzureEnvironment(name));
    }

    public List<Subscription> getSubscriptions() {
        throw new UnsupportedOperationException("Cannot get subscriptions from service: AzureCloud.");
    }
}

