/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth;

import com.azure.identity.DeviceCodeInfo;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.azure.toolkit.lib.auth.AuthType;
import com.microsoft.azure.toolkit.lib.common.exception.InvalidConfigurationException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class AuthConfiguration {
    @Nonnull
    private AuthType type;
    private String client;
    private String tenant;
    private String environment;
    @JsonIgnore
    private String key;
    private String certificate;
    @JsonIgnore
    private String certificatePassword;
    @JsonIgnore
    private transient Consumer<DeviceCodeInfo> deviceCodeConsumer;
    @JsonIgnore
    private transient Runnable doAfterLogin;
    @JsonIgnore
    private transient ExecutorService executorService;
    private String username;
    private List<String> selectedSubscriptions;

    @JsonCreator
    public AuthConfiguration(@JsonProperty(value="type") @Nonnull AuthType type) {
        this.type = type;
    }

    public void setType(AuthType type) {
        if (this.type != AuthType.AUTO && type != this.type) {
            throw new IllegalArgumentException("type can't be changed");
        }
        this.type = type;
    }

    public void validate() throws InvalidConfigurationException {
        String tenant = this.getTenant();
        String client = this.getClient();
        String key = this.getKey();
        String certificate = this.getCertificate();
        String errorMessage = null;
        if (StringUtils.isBlank((CharSequence)tenant)) {
            errorMessage = "Cannot find 'tenant'";
        } else if (StringUtils.isBlank((CharSequence)client)) {
            errorMessage = "Cannot find 'client'";
        } else if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{key, certificate})) {
            errorMessage = "Cannot find either 'key' or 'certificate'";
        } else if (StringUtils.isNotBlank((CharSequence)key) && StringUtils.isNotBlank((CharSequence)certificate)) {
            errorMessage = "It is wrong to specify both 'key' and 'certificate'";
        }
        if (Objects.nonNull(errorMessage)) {
            throw new InvalidConfigurationException(errorMessage);
        }
    }

    public void setClient(String client) {
        this.client = client;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    @JsonIgnore
    public void setKey(String key) {
        this.key = key;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    @JsonIgnore
    public void setCertificatePassword(String certificatePassword) {
        this.certificatePassword = certificatePassword;
    }

    @JsonIgnore
    public void setDeviceCodeConsumer(Consumer<DeviceCodeInfo> deviceCodeConsumer) {
        this.deviceCodeConsumer = deviceCodeConsumer;
    }

    @JsonIgnore
    public void setDoAfterLogin(Runnable doAfterLogin) {
        this.doAfterLogin = doAfterLogin;
    }

    @JsonIgnore
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setSelectedSubscriptions(List<String> selectedSubscriptions) {
        this.selectedSubscriptions = selectedSubscriptions;
    }

    @Nonnull
    public AuthType getType() {
        return this.type;
    }

    public String getClient() {
        return this.client;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getKey() {
        return this.key;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public String getCertificatePassword() {
        return this.certificatePassword;
    }

    public Consumer<DeviceCodeInfo> getDeviceCodeConsumer() {
        return this.deviceCodeConsumer;
    }

    public Runnable getDoAfterLogin() {
        return this.doAfterLogin;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public String getUsername() {
        return this.username;
    }

    public List<String> getSelectedSubscriptions() {
        return this.selectedSubscriptions;
    }
}

