/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.primitives;

import com.microsoft.azure.servicebus.primitives.ClientConstants;
import com.microsoft.azure.servicebus.primitives.RequestResponseLink;
import com.microsoft.azure.servicebus.primitives.RequestResponseUtils;
import com.microsoft.azure.servicebus.primitives.Util;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CommonRequestResponseOperations {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(CommonRequestResponseOperations.class);

    CommonRequestResponseOperations() {
    }

    static CompletableFuture<Collection<Message>> peekMessagesAsync(RequestResponseLink requestResponseLink, Duration operationTimeout, long fromSequenceNumber, int messageCount, String sessionId) {
        TRACE_LOGGER.debug("Peeking '{}' messages from sequence number '{}' in entity '{}', sessionId '{}'", new Object[]{messageCount, fromSequenceNumber, requestResponseLink.getLinkPath(), sessionId});
        HashMap<String, Object> requestBodyMap = new HashMap<String, Object>();
        requestBodyMap.put("from-sequence-number", fromSequenceNumber);
        requestBodyMap.put("message-count", messageCount);
        if (sessionId != null) {
            requestBodyMap.put("session-id", sessionId);
        }
        Message requestMessage = RequestResponseUtils.createRequestMessageFromPropertyBag("com.microsoft:peek-message", requestBodyMap, Util.adjustServerTimeout(operationTimeout));
        CompletableFuture<Message> responseFuture = requestResponseLink.requestAysnc(requestMessage, operationTimeout);
        return responseFuture.thenComposeAsync(responseMessage -> {
            CompletableFuture returningFuture = new CompletableFuture();
            int statusCode = RequestResponseUtils.getResponseStatusCode(responseMessage);
            if (statusCode == 200) {
                Object messages;
                ArrayList<Message> peekedMessages = new ArrayList<Message>();
                Object responseBodyMap = ((AmqpValue)responseMessage.getBody()).getValue();
                if (responseBodyMap != null && responseBodyMap instanceof Map && (messages = ((Map)responseBodyMap).get("messages")) != null && messages instanceof Iterable) {
                    for (Object message : (Iterable)messages) {
                        if (!(message instanceof Map)) continue;
                        Message peekedMessage = Message.Factory.create();
                        Binary messagePayLoad = (Binary)((Map)message).get("message");
                        peekedMessage.decode(messagePayLoad.getArray(), messagePayLoad.getArrayOffset(), messagePayLoad.getLength());
                        peekedMessages.add(peekedMessage);
                    }
                }
                TRACE_LOGGER.debug("Peeked '{}' messages from sequence number '{}' in entity '{}', sessionId '{}'", new Object[]{peekedMessages.size(), fromSequenceNumber, requestResponseLink.getLinkPath(), sessionId});
                returningFuture.complete(peekedMessages);
            } else if (statusCode == 204 || statusCode == 404 && ClientConstants.MESSAGE_NOT_FOUND_ERROR.equals(RequestResponseUtils.getResponseErrorCondition(responseMessage))) {
                TRACE_LOGGER.debug("Peek from sequence number '{}' in entity '{}', sessionId '{}' didnot find any messages", new Object[]{fromSequenceNumber, requestResponseLink.getLinkPath(), sessionId});
                returningFuture.complete(new ArrayList());
            } else {
                Exception failureException = RequestResponseUtils.genereateExceptionFromResponse(responseMessage);
                TRACE_LOGGER.error("Peeking messages from sequence number '{}' in entity '{}', sessionId '{}' failed", new Object[]{fromSequenceNumber, requestResponseLink.getLinkPath(), sessionId, failureException});
                returningFuture.completeExceptionally(failureException);
            }
            return returningFuture;
        });
    }

    static CompletableFuture<Void> sendCBSTokenAsync(RequestResponseLink requestResponseLink, Duration operationTimeout, String token, String tokenType, String tokenAudience) {
        TRACE_LOGGER.debug("Sending CBS Token of type '{}' to '{}'", (Object)tokenType, (Object)tokenAudience);
        Message requestMessage = RequestResponseUtils.createRequestMessageFromValueBody("put-token", token, Util.adjustServerTimeout(operationTimeout));
        requestMessage.getApplicationProperties().getValue().put("type", tokenType);
        requestMessage.getApplicationProperties().getValue().put("name", tokenAudience);
        CompletableFuture<Message> responseFuture = requestResponseLink.requestAysnc(requestMessage, operationTimeout);
        return responseFuture.thenComposeAsync(responseMessage -> {
            CompletableFuture returningFuture = new CompletableFuture();
            int statusCode = RequestResponseUtils.getResponseStatusCode(responseMessage);
            if (statusCode == 200 || statusCode == 202) {
                TRACE_LOGGER.debug("CBS Token of type '{}' sent to '{}'", (Object)tokenType, (Object)tokenAudience);
                returningFuture.complete(null);
            } else {
                Exception failureException = RequestResponseUtils.genereateExceptionFromResponse(responseMessage);
                TRACE_LOGGER.error("Sending CBS Token to '{}' failed", (Object)tokenAudience);
                returningFuture.completeExceptionally(failureException);
            }
            return returningFuture;
        });
    }
}

