/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import com.microsoft.azure.servicebus.IMessageReceiver;
import com.microsoft.azure.servicebus.IMessageSender;
import com.microsoft.azure.servicebus.IMessageSession;
import com.microsoft.azure.servicebus.MessageReceiver;
import com.microsoft.azure.servicebus.MessageSender;
import com.microsoft.azure.servicebus.MessageSession;
import com.microsoft.azure.servicebus.ReceiveMode;
import com.microsoft.azure.servicebus.Utils;
import com.microsoft.azure.servicebus.primitives.ConnectionStringBuilder;
import com.microsoft.azure.servicebus.primitives.MessagingFactory;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import java.util.concurrent.CompletableFuture;

public final class ClientFactory {
    private static final ReceiveMode DEFAULTRECEIVEMODE = ReceiveMode.PEEKLOCK;

    private ClientFactory() {
    }

    public static IMessageSender createMessageSenderFromConnectionString(String amqpConnectionString) throws InterruptedException, ServiceBusException {
        return Utils.completeFuture(ClientFactory.createMessageSenderFromConnectionStringAsync(amqpConnectionString));
    }

    public static IMessageSender createMessageSenderFromConnectionStringBuilder(ConnectionStringBuilder amqpConnectionStringBuilder) throws InterruptedException, ServiceBusException {
        return Utils.completeFuture(ClientFactory.createMessageSenderFromConnectionStringBuilderAsync(amqpConnectionStringBuilder));
    }

    static IMessageSender createMessageSenderFromEntityPath(MessagingFactory messagingFactory, String entityPath) throws InterruptedException, ServiceBusException {
        return Utils.completeFuture(ClientFactory.createMessageSenderFromEntityPathAsync(messagingFactory, entityPath));
    }

    public static CompletableFuture<IMessageSender> createMessageSenderFromConnectionStringAsync(String amqpConnectionString) {
        Utils.assertNonNull("amqpConnectionString", amqpConnectionString);
        return ClientFactory.createMessageSenderFromConnectionStringBuilderAsync(new ConnectionStringBuilder(amqpConnectionString));
    }

    public static CompletableFuture<IMessageSender> createMessageSenderFromConnectionStringBuilderAsync(ConnectionStringBuilder amqpConnectionStringBuilder) {
        Utils.assertNonNull("amqpConnectionStringBuilder", amqpConnectionStringBuilder);
        MessageSender sender = new MessageSender(amqpConnectionStringBuilder);
        return sender.initializeAsync().thenApply(v -> sender);
    }

    static CompletableFuture<IMessageSender> createMessageSenderFromEntityPathAsync(MessagingFactory messagingFactory, String entityPath) {
        Utils.assertNonNull("messagingFactory", messagingFactory);
        MessageSender sender = new MessageSender(messagingFactory, entityPath);
        return sender.initializeAsync().thenApply(v -> sender);
    }

    public static IMessageReceiver createMessageReceiverFromConnectionString(String amqpConnectionString) throws InterruptedException, ServiceBusException {
        return ClientFactory.createMessageReceiverFromConnectionString(amqpConnectionString, DEFAULTRECEIVEMODE);
    }

    public static IMessageReceiver createMessageReceiverFromConnectionString(String amqpConnectionString, ReceiveMode receiveMode) throws InterruptedException, ServiceBusException {
        return Utils.completeFuture(ClientFactory.createMessageReceiverFromConnectionStringAsync(amqpConnectionString, receiveMode));
    }

    public static IMessageReceiver createMessageReceiverFromConnectionStringBuilder(ConnectionStringBuilder amqpConnectionStringBuilder) throws InterruptedException, ServiceBusException {
        return ClientFactory.createMessageReceiverFromConnectionStringBuilder(amqpConnectionStringBuilder, DEFAULTRECEIVEMODE);
    }

    public static IMessageReceiver createMessageReceiverFromConnectionStringBuilder(ConnectionStringBuilder amqpConnectionStringBuilder, ReceiveMode receiveMode) throws InterruptedException, ServiceBusException {
        return Utils.completeFuture(ClientFactory.createMessageReceiverFromConnectionStringBuilderAsync(amqpConnectionStringBuilder, receiveMode));
    }

    static IMessageReceiver createMessageReceiverFromEntityPath(MessagingFactory messagingFactory, String entityPath) throws InterruptedException, ServiceBusException {
        return ClientFactory.createMessageReceiverFromEntityPath(messagingFactory, entityPath, DEFAULTRECEIVEMODE);
    }

    static IMessageReceiver createMessageReceiverFromEntityPath(MessagingFactory messagingFactory, String entityPath, ReceiveMode receiveMode) throws InterruptedException, ServiceBusException {
        return Utils.completeFuture(ClientFactory.createMessageReceiverFromEntityPathAsync(messagingFactory, entityPath, receiveMode));
    }

    public static CompletableFuture<IMessageReceiver> createMessageReceiverFromConnectionStringAsync(String amqpConnectionString) {
        return ClientFactory.createMessageReceiverFromConnectionStringAsync(amqpConnectionString, DEFAULTRECEIVEMODE);
    }

    public static CompletableFuture<IMessageReceiver> createMessageReceiverFromConnectionStringAsync(String amqpConnectionString, ReceiveMode receiveMode) {
        Utils.assertNonNull("amqpConnectionString", amqpConnectionString);
        return ClientFactory.createMessageReceiverFromConnectionStringBuilderAsync(new ConnectionStringBuilder(amqpConnectionString), receiveMode);
    }

    public static CompletableFuture<IMessageReceiver> createMessageReceiverFromConnectionStringBuilderAsync(ConnectionStringBuilder amqpConnectionStringBuilder) {
        return ClientFactory.createMessageReceiverFromConnectionStringBuilderAsync(amqpConnectionStringBuilder, DEFAULTRECEIVEMODE);
    }

    public static CompletableFuture<IMessageReceiver> createMessageReceiverFromConnectionStringBuilderAsync(ConnectionStringBuilder amqpConnectionStringBuilder, ReceiveMode receiveMode) {
        Utils.assertNonNull("amqpConnectionStringBuilder", amqpConnectionStringBuilder);
        MessageReceiver receiver = new MessageReceiver(amqpConnectionStringBuilder, receiveMode);
        return receiver.initializeAsync().thenApply(v -> receiver);
    }

    static CompletableFuture<IMessageReceiver> createMessageReceiverFromEntityPathAsync(MessagingFactory messagingFactory, String entityPath) {
        return ClientFactory.createMessageReceiverFromEntityPathAsync(messagingFactory, entityPath, DEFAULTRECEIVEMODE);
    }

    static CompletableFuture<IMessageReceiver> createMessageReceiverFromEntityPathAsync(MessagingFactory messagingFactory, String entityPath, ReceiveMode receiveMode) {
        Utils.assertNonNull("messagingFactory", messagingFactory);
        MessageReceiver receiver = new MessageReceiver(messagingFactory, entityPath, receiveMode);
        return receiver.initializeAsync().thenApply(v -> receiver);
    }

    public static IMessageSession acceptSessionFromConnectionString(String amqpConnectionString, String sessionId) throws InterruptedException, ServiceBusException {
        return ClientFactory.acceptSessionFromConnectionString(amqpConnectionString, sessionId, DEFAULTRECEIVEMODE);
    }

    public static IMessageSession acceptSessionFromConnectionString(String amqpConnectionString, String sessionId, ReceiveMode receiveMode) throws InterruptedException, ServiceBusException {
        return Utils.completeFuture(ClientFactory.acceptSessionFromConnectionStringAsync(amqpConnectionString, sessionId, receiveMode));
    }

    public static IMessageSession acceptSessionFromConnectionStringBuilder(ConnectionStringBuilder amqpConnectionStringBuilder, String sessionId) throws InterruptedException, ServiceBusException {
        return ClientFactory.acceptSessionFromConnectionStringBuilder(amqpConnectionStringBuilder, sessionId, DEFAULTRECEIVEMODE);
    }

    public static IMessageSession acceptSessionFromConnectionStringBuilder(ConnectionStringBuilder amqpConnectionStringBuilder, String sessionId, ReceiveMode receiveMode) throws InterruptedException, ServiceBusException {
        return Utils.completeFuture(ClientFactory.acceptSessionFromConnectionStringBuilderAsync(amqpConnectionStringBuilder, sessionId, receiveMode));
    }

    static IMessageSession acceptSessionFromEntityPath(MessagingFactory messagingFactory, String entityPath, String sessionId) throws InterruptedException, ServiceBusException {
        return ClientFactory.acceptSessionFromEntityPath(messagingFactory, entityPath, sessionId, DEFAULTRECEIVEMODE);
    }

    static IMessageSession acceptSessionFromEntityPath(MessagingFactory messagingFactory, String entityPath, String sessionId, ReceiveMode receiveMode) throws InterruptedException, ServiceBusException {
        return Utils.completeFuture(ClientFactory.acceptSessionFromEntityPathAsync(messagingFactory, entityPath, sessionId, receiveMode));
    }

    public static CompletableFuture<IMessageSession> acceptSessionFromConnectionStringAsync(String amqpConnectionString, String sessionId) {
        return ClientFactory.acceptSessionFromConnectionStringAsync(amqpConnectionString, sessionId, DEFAULTRECEIVEMODE);
    }

    public static CompletableFuture<IMessageSession> acceptSessionFromConnectionStringAsync(String amqpConnectionString, String sessionId, ReceiveMode receiveMode) {
        Utils.assertNonNull("amqpConnectionString", amqpConnectionString);
        return ClientFactory.acceptSessionFromConnectionStringBuilderAsync(new ConnectionStringBuilder(amqpConnectionString), sessionId, receiveMode);
    }

    public static CompletableFuture<IMessageSession> acceptSessionFromConnectionStringBuilderAsync(ConnectionStringBuilder amqpConnectionStringBuilder, String sessionId) {
        return ClientFactory.acceptSessionFromConnectionStringBuilderAsync(amqpConnectionStringBuilder, sessionId, DEFAULTRECEIVEMODE);
    }

    public static CompletableFuture<IMessageSession> acceptSessionFromConnectionStringBuilderAsync(ConnectionStringBuilder amqpConnectionStringBuilder, String sessionId, ReceiveMode receiveMode) {
        Utils.assertNonNull("amqpConnectionStringBuilder", amqpConnectionStringBuilder);
        MessageSession session = new MessageSession(amqpConnectionStringBuilder, sessionId, receiveMode);
        return session.initializeAsync().thenApply(v -> session);
    }

    static CompletableFuture<IMessageSession> acceptSessionFromEntityPathAsync(MessagingFactory messagingFactory, String entityPath, String sessionId) {
        return ClientFactory.acceptSessionFromEntityPathAsync(messagingFactory, entityPath, sessionId, DEFAULTRECEIVEMODE);
    }

    static CompletableFuture<IMessageSession> acceptSessionFromEntityPathAsync(MessagingFactory messagingFactory, String entityPath, String sessionId, ReceiveMode receiveMode) {
        Utils.assertNonNull("messagingFactory", messagingFactory);
        MessageSession session = new MessageSession(messagingFactory, entityPath, sessionId, receiveMode);
        return session.initializeAsync().thenApply(v -> session);
    }
}

