/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.agent;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.agent.internal.coresync.AgentNotificationsHandler;
import com.microsoft.applicationinsights.agent.internal.coresync.InstrumentedClassType;
import com.microsoft.applicationinsights.agent.internal.coresync.impl.ImplementationsCoordinator;
import com.microsoft.applicationinsights.internal.agent.ArgsFormatter;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.schemav2.DependencyKind;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import com.microsoft.applicationinsights.internal.util.ThreadLocalCleaner;
import com.microsoft.applicationinsights.telemetry.Duration;
import com.microsoft.applicationinsights.telemetry.ExceptionTelemetry;
import com.microsoft.applicationinsights.telemetry.RemoteDependencyTelemetry;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;

final class CoreAgentNotificationsHandler
implements AgentNotificationsHandler {
    private static final String EXCEPTION_THROWN_ID = "__java_sdk__exceptionThrown__";
    private final ThreadLocalCleaner cleaner = new ThreadLocalCleaner(){

        @Override
        public void clean() {
            CoreAgentNotificationsHandler.this.threadDataThreadLocal.remove();
        }
    };
    private ThreadLocalData threadDataThreadLocal = new ThreadLocalData();
    private TelemetryClient telemetryClient = new TelemetryClient();
    private final String name;

    public ThreadLocalCleaner getCleaner() {
        return this.cleaner;
    }

    public CoreAgentNotificationsHandler(String name) {
        this.name = name;
    }

    public void exceptionCaught(String classAndMethodNames, Throwable throwable) {
        try {
            if (throwable instanceof Exception) {
                this.telemetryClient.trackException((Exception)throwable);
            }
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    public void httpMethodStarted(String classAndMethodNames, String url) {
        this.startMethod(InstrumentedClassType.HTTP.toString(), this.name, url);
    }

    public void sqlStatementExecuteQueryPossibleQueryPlan(String name, Statement statement, String sqlStatement) {
        this.startSqlMethod(statement, sqlStatement, null);
    }

    public void preparedStatementMethodStarted(String classAndMethodNames, PreparedStatement statement, String sqlStatement, Object[] args) {
        this.startSqlMethod(statement, sqlStatement, args);
    }

    public void sqlStatementMethodStarted(String name, Statement statement, String sqlStatement) {
        this.startSqlMethod(statement, sqlStatement, null);
    }

    public void preparedStatementExecuteBatchMethodStarted(String classAndMethodNames, PreparedStatement statement, String sqlStatement, int batchCounter) {
        String batchData = String.format("Batch of %d", batchCounter);
        this.startSqlMethod(statement, sqlStatement, new Object[]{batchData});
    }

    public String getName() {
        return this.name;
    }

    public void httpMethodFinished(String identifier, String method, String correlationId, String uri, String target, int result, long deltaInNS) {
        if (!LocalStringsUtils.isNullOrEmpty(uri) && (uri.startsWith("https://dc.services.visualstudio.com") || uri.startsWith("https://rt.services.visualstudio.com"))) {
            return;
        }
        long deltaInMS = CoreAgentNotificationsHandler.nanoToMilliseconds(deltaInNS);
        RemoteDependencyTelemetry telemetry = new RemoteDependencyTelemetry(identifier, null, new Duration(deltaInMS), true);
        telemetry.setId(correlationId);
        telemetry.setResultCode(Integer.toString(result));
        telemetry.setType("HTTP");
        telemetry.getContext().getProperties().put("URI", uri);
        telemetry.getContext().getProperties().put("Method", method);
        if (target != null && !target.isEmpty()) {
            if (telemetry.getTarget() == null) {
                telemetry.setTarget(target);
            } else {
                telemetry.setTarget(telemetry.getTarget() + " | " + target);
            }
        }
        InternalLogger.INSTANCE.trace("'%s' sent an HTTP method: '%s', uri: '%s', duration=%s ms", identifier, method, uri, deltaInMS);
        this.telemetryClient.track(telemetry);
    }

    public void jedisMethodStarted(String name) {
        int index = name.lastIndexOf(35);
        if (index != -1) {
            name = name.substring(0, index);
        }
        this.startMethod(InstrumentedClassType.Redis.toString(), name, new String[0]);
    }

    public void methodStarted(String name) {
        String classType;
        int index = name.lastIndexOf(35);
        if (index != -1) {
            classType = name.substring(index + 1);
            name = name.substring(0, index);
        } else {
            classType = InstrumentedClassType.OTHER.toString();
        }
        this.startMethod(classType, name, new String[0]);
    }

    public void methodFinished(String name, Throwable throwable) {
        if (!this.finalizeMethod(0L, null, throwable)) {
            InternalLogger.INSTANCE.error("Agent has detected a 'Finish' method '%s' with exception '%s' event without a 'Start'", name, throwable == null ? "unknown" : throwable.getClass().getName());
        }
    }

    public void methodFinished(String name, String type, long thresholdInMS) {
        if (!this.finalizeMethod(thresholdInMS, null, null)) {
            InternalLogger.INSTANCE.error("Agent has detected a 'Finish' method ('%s') event without a 'Start'", name);
        }
    }

    public void methodFinished(String name, long thresholdInMS) {
        if (!this.finalizeMethod(thresholdInMS, null, null)) {
            InternalLogger.INSTANCE.error("Agent has detected a 'Finish' method ('%s') event without a 'Start'", name);
        }
    }

    public void methodFinished(String classAndMethodNames, long deltaInNS, Object[] args, Throwable throwable) {
        long durationInMS = CoreAgentNotificationsHandler.nanoToMilliseconds(deltaInNS);
        Duration duration = new Duration(durationInMS);
        RemoteDependencyTelemetry telemetry = new RemoteDependencyTelemetry(classAndMethodNames, null, duration, throwable == null);
        telemetry.setDependencyKind(DependencyKind.Other);
        if (args != null) {
            String argsAsString = new ArgsFormatter().format(args);
            telemetry.getContext().getProperties().put("Args", argsAsString);
        }
        InternalLogger.INSTANCE.trace("Sending RDD event for '%s', duration=%s ms", classAndMethodNames, durationInMS);
        this.telemetryClient.track(telemetry);
        if (throwable != null) {
            ExceptionTelemetry exceptionTelemetry = new ExceptionTelemetry(throwable);
            this.telemetryClient.track(exceptionTelemetry);
        }
    }

    public void exceptionThrown(Exception e) {
        throw new UnsupportedOperationException();
    }

    public void exceptionThrown(Exception e, int stackSize) {
        ThreadData localData = (ThreadData)this.threadDataThreadLocal.get();
        MethodData methodData = null;
        try {
            if (localData.methods != null && !localData.methods.isEmpty()) {
                for (MethodData m : localData.methods) {
                    if (!EXCEPTION_THROWN_ID.equals(m.name)) continue;
                    return;
                }
            }
            methodData = new MethodData();
            methodData.interval = 0L;
            methodData.type = InstrumentedClassType.OTHER.toString();
            methodData.arguments = null;
            methodData.name = EXCEPTION_THROWN_ID;
            localData.methods.addFirst(methodData);
            ExceptionTelemetry et = new ExceptionTelemetry(e, stackSize);
            this.telemetryClient.track(et);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (methodData != null) {
            localData.methods.remove(methodData);
        }
    }

    private void startSqlMethod(Statement statement, String sqlStatement, Object[] additionalArgs) {
        try {
            Connection connection = null;
            String url = null;
            if (statement != null) {
                try {
                    DatabaseMetaData metaData;
                    connection = statement.getConnection();
                    if (connection != null && (metaData = connection.getMetaData()) != null) {
                        url = metaData.getURL();
                    }
                }
                catch (Throwable t) {
                    url = "jdbc:Unknown DB URL (failed to fetch from connection)";
                }
            }
            Object[] sqlMetaData = additionalArgs == null ? new Object[]{url, sqlStatement, connection} : new Object[]{url, sqlStatement, connection, additionalArgs};
            this.startSqlMethod(InstrumentedClassType.SQL.toString(), this.name, sqlMetaData);
            ThreadData threadData = (ThreadData)this.threadDataThreadLocal.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void startMethod(String type, String name, String ... arguments) {
        long start = System.nanoTime();
        ThreadData localData = (ThreadData)this.threadDataThreadLocal.get();
        MethodData methodData = new MethodData();
        methodData.interval = start;
        methodData.type = type;
        methodData.arguments = arguments;
        methodData.name = name;
        localData.methods.addFirst(methodData);
    }

    private void startSqlMethod(String type, String name, Object ... arguments) {
        long start = System.nanoTime();
        ThreadData localData = (ThreadData)this.threadDataThreadLocal.get();
        MethodData methodData = new MethodData();
        methodData.interval = start;
        methodData.type = type;
        methodData.arguments = arguments;
        methodData.name = name;
        localData.methods.addFirst(methodData);
    }

    private boolean finalizeMethod(long thresholdInMS, Object result, Throwable throwable) {
        long asMS;
        long finish = System.nanoTime();
        ThreadData localData = (ThreadData)this.threadDataThreadLocal.get();
        if (localData.methods == null || localData.methods.isEmpty()) {
            return false;
        }
        MethodData methodData = localData.methods.removeFirst();
        if (methodData == null) {
            return true;
        }
        methodData.interval = finish - methodData.interval;
        if (throwable == null && thresholdInMS > 0L && (asMS = CoreAgentNotificationsHandler.nanoToMilliseconds(methodData.interval)) < thresholdInMS) {
            return true;
        }
        methodData.result = result;
        this.report(methodData, throwable);
        return true;
    }

    private void report(MethodData methodData, Throwable throwable) {
        if ("SQL".equalsIgnoreCase(methodData.type)) {
            this.sendSQLTelemetry(methodData, throwable);
        } else if ("HTTP".equalsIgnoreCase(methodData.type)) {
            this.sendHTTPTelemetry(methodData, throwable);
        } else {
            this.sendInstrumentationTelemetry(methodData, throwable);
        }
    }

    private void sendInstrumentationTelemetry(MethodData methodData, Throwable throwable) {
        Duration duration = new Duration(CoreAgentNotificationsHandler.nanoToMilliseconds(methodData.interval));
        RemoteDependencyTelemetry telemetry = new RemoteDependencyTelemetry(methodData.name, null, duration, throwable == null);
        telemetry.setType(methodData.type);
        InternalLogger.INSTANCE.trace("Sending RDD event for '%s'", methodData.name);
        this.telemetryClient.track(telemetry);
        if (throwable != null) {
            ExceptionTelemetry exceptionTelemetry = new ExceptionTelemetry(throwable);
            this.telemetryClient.track(exceptionTelemetry);
        }
    }

    private void sendHTTPTelemetry(MethodData methodData, Throwable throwable) {
        if (methodData.arguments != null && methodData.arguments.length == 1) {
            String url = methodData.arguments[0].toString();
            long durationInMilliSeconds = CoreAgentNotificationsHandler.nanoToMilliseconds(methodData.interval);
            Duration duration = new Duration(durationInMilliSeconds);
            InternalLogger.INSTANCE.trace("Sending HTTP RDD event, URL: '%s', duration=%s ms", url, durationInMilliSeconds);
            RemoteDependencyTelemetry telemetry = new RemoteDependencyTelemetry(url, null, duration, throwable == null);
            telemetry.setDependencyKind(DependencyKind.Http);
            this.telemetryClient.trackDependency(telemetry);
            if (throwable != null) {
                ExceptionTelemetry exceptionTelemetry = new ExceptionTelemetry(throwable);
                this.telemetryClient.track(exceptionTelemetry);
            }
        }
    }

    private void sendSQLTelemetry(MethodData methodData, Throwable throwable) {
        if (methodData.arguments == null || methodData.arguments.length == 0) {
            InternalLogger.INSTANCE.error("sendSQLTelemetry: no arguments found.", new Object[0]);
            return;
        }
        try {
            String dependencyName = "";
            if (methodData.arguments[0] != null) {
                dependencyName = methodData.arguments[0].toString();
            }
            String commandName = "";
            if (methodData.arguments.length > 1 && methodData.arguments[1] != null) {
                commandName = methodData.arguments[1].toString();
            }
            long durationInMilliSeconds = CoreAgentNotificationsHandler.nanoToMilliseconds(methodData.interval);
            Duration duration = new Duration(durationInMilliSeconds);
            RemoteDependencyTelemetry telemetry = new RemoteDependencyTelemetry(dependencyName, commandName, duration, throwable == null);
            telemetry.setDependencyKind(DependencyKind.SQL);
            StringBuilder sb = null;
            if (methodData.arguments.length > 3) {
                sb = this.formatAdditionalSqlArguments(methodData);
                if (sb != null) {
                    telemetry.getContext().getProperties().put("Args", sb.toString());
                }
            } else if (durationInMilliSeconds > ImplementationsCoordinator.INSTANCE.getQueryPlanThresholdInMS() && (sb = this.fetchExplainQuery(commandName, methodData.arguments[2])) != null) {
                telemetry.getContext().getProperties().put("Query Plan", sb.toString());
            }
            InternalLogger.INSTANCE.trace("Sending Sql RDD event for '%s', command: '%s', duration=%s ms", dependencyName, commandName, durationInMilliSeconds);
            this.telemetryClient.track(telemetry);
            if (throwable != null) {
                InternalLogger.INSTANCE.trace("Sending Sql exception", new Object[0]);
                ExceptionTelemetry exceptionTelemetry = new ExceptionTelemetry(throwable);
                this.telemetryClient.track(exceptionTelemetry);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static long nanoToMilliseconds(long nanoSeconds) {
        return nanoSeconds / 1000000L;
    }

    private StringBuilder formatAdditionalSqlArguments(MethodData methodData) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(" [");
            Object[] args = (Object[])methodData.arguments[3];
            if (args != null && args.length > 0) {
                for (Object arg : args) {
                    if (arg == null) {
                        sb.append("null,");
                        continue;
                    }
                    sb.append(arg.toString());
                    sb.append(',');
                }
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append(']');
            return sb;
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder fetchExplainQuery(String commandName, Object object) {
        StringBuilder explainSB = null;
        Statement explain = null;
        ResultSet rs = null;
        try {
            if (commandName.startsWith("SELECT ")) {
                Connection connection = (Connection)object;
                if (connection == null) {
                    StringBuilder stringBuilder = explainSB;
                    return stringBuilder;
                }
                explain = connection.createStatement();
                rs = explain.executeQuery("EXPLAIN " + commandName);
                explainSB = new StringBuilder();
                while (rs.next()) {
                    explainSB.append('[');
                    int columns = rs.getMetaData().getColumnCount();
                    if (columns == 1) {
                        explainSB.append(rs.getString(1));
                    } else {
                        for (int i1 = 1; i1 < rs.getMetaData().getColumnCount(); ++i1) {
                            explainSB.append(rs.getMetaData().getColumnName(i1));
                            explainSB.append(':');
                            Object obj = rs.getObject(i1);
                            explainSB.append(obj == null ? "" : obj.toString());
                            explainSB.append(',');
                        }
                        explainSB.deleteCharAt(explainSB.length() - 1);
                    }
                    explainSB.append("],");
                }
                explainSB.deleteCharAt(explainSB.length() - 1);
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (explain != null) {
                try {
                    explain.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return explainSB;
    }

    static final class ThreadLocalData
    extends ThreadLocal<ThreadData> {
        private ThreadData threadData;

        ThreadLocalData() {
        }

        @Override
        protected ThreadData initialValue() {
            this.threadData = new ThreadData();
            return this.threadData;
        }
    }

    private static class ThreadData {
        public final LinkedList<MethodData> methods = new LinkedList();

        private ThreadData() {
        }
    }

    private static class MethodData {
        public String name;
        public Object[] arguments;
        public long interval;
        public String type;
        public Object result;

        private MethodData() {
        }
    }
}

