/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field.verifier;

import java.text.DateFormatSymbols;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javafx.collections.ObservableMap;
import javafx.util.Callback;
import jidefx.scene.control.field.verifier.IntegerCalendarFieldPatternVerifier;
import jidefx.scene.control.field.verifier.IntegerDateFieldPatternVerifier;
import jidefx.scene.control.field.verifier.IntegerTemporalPatternVerifier;
import jidefx.scene.control.field.verifier.IntegerTemporalPatternVerifierNotAdjustable;
import jidefx.scene.control.field.verifier.LongTemporalPatternVerifier;
import jidefx.scene.control.field.verifier.LongTemporalPatternVerifierNotAdjustable;
import jidefx.scene.control.field.verifier.StringCalendarFieldPatternVerifier;
import jidefx.scene.control.field.verifier.StringDateFieldPatternVerifier;
import jidefx.scene.control.field.verifier.StringValuesPatternVerifier;

public final class PatternVerifierUtils {
    private static final Map<Character, TemporalField> FIELD_MAP = new HashMap<Character, TemporalField>();
    private static final Map<Character, TemporalUnit> UNIT_MAP = new HashMap<Character, TemporalUnit>();

    public static void initializePatternVerifiersForDateFormatUsingCalendar(ObservableMap<String, Callback<String, Boolean>> verifiers) {
        StringCalendarFieldPatternVerifier eraGroupVerifier = new StringCalendarFieldPatternVerifier(0, new DateFormatSymbols().getEras());
        verifiers.put((Object)"GGG", (Object)eraGroupVerifier);
        verifiers.put((Object)"GG", (Object)eraGroupVerifier);
        verifiers.put((Object)"G", (Object)eraGroupVerifier);
        verifiers.put((Object)"yyyyy", (Object)new IntegerCalendarFieldPatternVerifier(1, 0, 99999, true));
        verifiers.put((Object)"yyyy", (Object)new IntegerCalendarFieldPatternVerifier(1, 0, 9999, true));
        verifiers.put((Object)"yy", (Object)new IntegerCalendarFieldPatternVerifier(1, 0, 99, true));
        verifiers.put((Object)"y", (Object)new IntegerCalendarFieldPatternVerifier(1, 0, 9999, false));
        String[] months = new DateFormatSymbols().getMonths();
        verifiers.put((Object)"MMMMM", (Object)new StringCalendarFieldPatternVerifier(2, months));
        verifiers.put((Object)"MMMM", (Object)new StringCalendarFieldPatternVerifier(2, months));
        String[] shortMonths = new DateFormatSymbols().getShortMonths();
        verifiers.put((Object)"MMM", (Object)new StringCalendarFieldPatternVerifier(2, shortMonths));
        verifiers.put((Object)"MM", (Object)new IntegerCalendarFieldPatternVerifier(2, 1, 12, true));
        verifiers.put((Object)"M", (Object)new IntegerCalendarFieldPatternVerifier(2, 1, 12, false));
        verifiers.put((Object)"ww", (Object)new IntegerCalendarFieldPatternVerifier(3, true));
        verifiers.put((Object)"w", (Object)new IntegerCalendarFieldPatternVerifier(3, false));
        verifiers.put((Object)"W", (Object)new IntegerCalendarFieldPatternVerifier(4, true));
        verifiers.put((Object)"DDD", (Object)new IntegerCalendarFieldPatternVerifier(6, true));
        verifiers.put((Object)"D", (Object)new IntegerCalendarFieldPatternVerifier(6, false));
        verifiers.put((Object)"dd", (Object)new IntegerCalendarFieldPatternVerifier(5, true));
        verifiers.put((Object)"d", (Object)new IntegerCalendarFieldPatternVerifier(5, false));
        verifiers.put((Object)"F", (Object)new IntegerCalendarFieldPatternVerifier(8, true));
        String[] weekdays = new DateFormatSymbols().getWeekdays();
        verifiers.put((Object)"EEEE", (Object)new StringCalendarFieldPatternVerifier(7, weekdays));
        String[] shortWeekdays = new DateFormatSymbols().getShortWeekdays();
        StringCalendarFieldPatternVerifier dayInWeekVerifier = new StringCalendarFieldPatternVerifier(7, shortWeekdays);
        verifiers.put((Object)"EEE", (Object)dayInWeekVerifier);
        verifiers.put((Object)"EE", (Object)dayInWeekVerifier);
        verifiers.put((Object)"E", (Object)dayInWeekVerifier);
        StringCalendarFieldPatternVerifier ampmVerifier = new StringCalendarFieldPatternVerifier(9, new DateFormatSymbols().getAmPmStrings());
        verifiers.put((Object)"aaa", (Object)ampmVerifier);
        verifiers.put((Object)"aa", (Object)ampmVerifier);
        verifiers.put((Object)"a", (Object)ampmVerifier);
        verifiers.put((Object)"HH", (Object)new IntegerCalendarFieldPatternVerifier(11, 0, 23, true));
        verifiers.put((Object)"H", (Object)new IntegerCalendarFieldPatternVerifier(11, 0, 23, false));
        verifiers.put((Object)"kk", (Object)new IntegerCalendarFieldPatternVerifier(11, 1, 24, true));
        verifiers.put((Object)"k", (Object)new IntegerCalendarFieldPatternVerifier(11, 1, 24, false));
        verifiers.put((Object)"KK", (Object)new IntegerCalendarFieldPatternVerifier(10, 0, 11, true));
        verifiers.put((Object)"K", (Object)new IntegerCalendarFieldPatternVerifier(10, 0, 11, false));
        verifiers.put((Object)"hh", (Object)new IntegerCalendarFieldPatternVerifier(10, 1, 12, true));
        verifiers.put((Object)"h", (Object)new IntegerCalendarFieldPatternVerifier(10, 1, 12, false));
        verifiers.put((Object)"mm", (Object)new IntegerCalendarFieldPatternVerifier(12, true));
        verifiers.put((Object)"m", (Object)new IntegerCalendarFieldPatternVerifier(12, false));
        verifiers.put((Object)"ss", (Object)new IntegerCalendarFieldPatternVerifier(13, true));
        verifiers.put((Object)"s", (Object)new IntegerCalendarFieldPatternVerifier(13, false));
        verifiers.put((Object)"SSS", (Object)new IntegerCalendarFieldPatternVerifier(14, true));
        verifiers.put((Object)"S", (Object)new IntegerCalendarFieldPatternVerifier(14, false));
        StringValuesPatternVerifier<String> zoneShort = new StringValuesPatternVerifier<String>(PatternVerifierUtils.getZoneStrings(false)){

            @Override
            public String toTargetValue(String fieldValue) {
                return fieldValue;
            }

            @Override
            public String fromTargetValue(String previousFieldValue, String targetValue) {
                return targetValue;
            }
        };
        verifiers.put((Object)"zzz", (Object)zoneShort);
        verifiers.put((Object)"zz", (Object)zoneShort);
        verifiers.put((Object)"z", (Object)zoneShort);
    }

    private static String[] getZoneStrings(boolean longFormat) {
        String[][] zones = new DateFormatSymbols().getZoneStrings();
        ArrayList<String> z = new ArrayList<String>();
        if (longFormat) {
            for (String[] zone : zones) {
                if (z.contains(zone[1])) continue;
                z.add(zone[1]);
            }
            for (String[] zone : zones) {
                if (z.contains(zone[3])) continue;
                z.add(zone[3]);
            }
        } else {
            for (String[] zone : zones) {
                if (z.contains(zone[2])) continue;
                z.add(zone[2]);
            }
            for (String[] zone : zones) {
                if (z.contains(zone[4])) continue;
                z.add(zone[4]);
            }
        }
        return z.toArray(new String[z.size()]);
    }

    public static void initializePatternVerifiersForDateFormatUsingDate(ObservableMap<String, Callback<String, Boolean>> verifiers) {
        StringDateFieldPatternVerifier eraGroupVerifier = new StringDateFieldPatternVerifier(0, new DateFormatSymbols().getEras());
        verifiers.put((Object)"GGG", (Object)eraGroupVerifier);
        verifiers.put((Object)"GG", (Object)eraGroupVerifier);
        verifiers.put((Object)"G", (Object)eraGroupVerifier);
        verifiers.put((Object)"yyyyy", (Object)new IntegerDateFieldPatternVerifier(1, 0, 99999, true));
        verifiers.put((Object)"yyyy", (Object)new IntegerDateFieldPatternVerifier(1, 0, 9999, true));
        verifiers.put((Object)"yy", (Object)new IntegerDateFieldPatternVerifier(1, 0, 99, true));
        verifiers.put((Object)"y", (Object)new IntegerDateFieldPatternVerifier(1, 0, 9999, false));
        String[] months = new DateFormatSymbols().getMonths();
        verifiers.put((Object)"MMMMM", (Object)new StringDateFieldPatternVerifier(2, months));
        verifiers.put((Object)"MMMM", (Object)new StringDateFieldPatternVerifier(2, months));
        String[] shortMonths = new DateFormatSymbols().getShortMonths();
        verifiers.put((Object)"MMM", (Object)new StringDateFieldPatternVerifier(2, shortMonths));
        verifiers.put((Object)"MM", (Object)new IntegerDateFieldPatternVerifier(2, 1, 12, true));
        verifiers.put((Object)"M", (Object)new IntegerDateFieldPatternVerifier(2, 1, 12, false));
        verifiers.put((Object)"ww", (Object)new IntegerDateFieldPatternVerifier(3, true));
        verifiers.put((Object)"w", (Object)new IntegerDateFieldPatternVerifier(3, false));
        verifiers.put((Object)"W", (Object)new IntegerDateFieldPatternVerifier(4, true));
        verifiers.put((Object)"DDD", (Object)new IntegerDateFieldPatternVerifier(6, true));
        verifiers.put((Object)"D", (Object)new IntegerDateFieldPatternVerifier(6, false));
        verifiers.put((Object)"dd", (Object)new IntegerDateFieldPatternVerifier(5, true));
        verifiers.put((Object)"d", (Object)new IntegerDateFieldPatternVerifier(5, false));
        verifiers.put((Object)"F", (Object)new IntegerDateFieldPatternVerifier(8, true));
        String[] weekdays = new DateFormatSymbols().getWeekdays();
        verifiers.put((Object)"EEEE", (Object)new StringDateFieldPatternVerifier(7, weekdays));
        String[] shortWeekdays = new DateFormatSymbols().getShortWeekdays();
        StringDateFieldPatternVerifier dayInWeekVerifier = new StringDateFieldPatternVerifier(7, shortWeekdays);
        verifiers.put((Object)"EEE", (Object)dayInWeekVerifier);
        verifiers.put((Object)"EE", (Object)dayInWeekVerifier);
        verifiers.put((Object)"E", (Object)dayInWeekVerifier);
        StringDateFieldPatternVerifier ampmVerifier = new StringDateFieldPatternVerifier(9, new DateFormatSymbols().getAmPmStrings());
        verifiers.put((Object)"aaa", (Object)ampmVerifier);
        verifiers.put((Object)"aa", (Object)ampmVerifier);
        verifiers.put((Object)"a", (Object)ampmVerifier);
        verifiers.put((Object)"HH", (Object)new IntegerDateFieldPatternVerifier(11, 0, 23, true));
        verifiers.put((Object)"H", (Object)new IntegerDateFieldPatternVerifier(11, 0, 23, false));
        verifiers.put((Object)"kk", (Object)new IntegerDateFieldPatternVerifier(11, 1, 24, true));
        verifiers.put((Object)"k", (Object)new IntegerDateFieldPatternVerifier(11, 1, 24, false));
        verifiers.put((Object)"KK", (Object)new IntegerDateFieldPatternVerifier(10, 0, 11, true));
        verifiers.put((Object)"K", (Object)new IntegerDateFieldPatternVerifier(10, 0, 11, false));
        verifiers.put((Object)"hh", (Object)new IntegerDateFieldPatternVerifier(10, 1, 12, true));
        verifiers.put((Object)"h", (Object)new IntegerDateFieldPatternVerifier(10, 1, 12, false));
        verifiers.put((Object)"mm", (Object)new IntegerDateFieldPatternVerifier(12, true));
        verifiers.put((Object)"m", (Object)new IntegerDateFieldPatternVerifier(12, false));
        verifiers.put((Object)"ss", (Object)new IntegerDateFieldPatternVerifier(13, true));
        verifiers.put((Object)"s", (Object)new IntegerDateFieldPatternVerifier(13, false));
        verifiers.put((Object)"SSS", (Object)new IntegerDateFieldPatternVerifier(14, true));
        verifiers.put((Object)"S", (Object)new IntegerDateFieldPatternVerifier(14, false));
        StringValuesPatternVerifier<String> zoneShort = new StringValuesPatternVerifier<String>(PatternVerifierUtils.getZoneStrings(false)){

            @Override
            public String toTargetValue(String fieldValue) {
                return fieldValue;
            }

            @Override
            public String fromTargetValue(String previousFieldValue, String targetValue) {
                return targetValue;
            }
        };
        verifiers.put((Object)"zzz", (Object)zoneShort);
        verifiers.put((Object)"zz", (Object)zoneShort);
        verifiers.put((Object)"z", (Object)zoneShort);
    }

    public static void initializePatternVerifiersForDateTimeFormatter(ObservableMap<String, Callback<String, Boolean>> verifiers) {
        PatternVerifierUtils.installForPatternVerifierField(verifiers, "G");
        PatternVerifierUtils.installForPatternVerifierField(verifiers, "u");
        PatternVerifierUtils.installForPatternVerifierField(verifiers, "y");
        PatternVerifierUtils.installForPatternVerifierField(verifiers, "D", 3);
        PatternVerifierUtils.installForPatternVerifierField(verifiers, "M");
        PatternVerifierUtils.installForPatternVerifierField(verifiers, "L");
        PatternVerifierUtils.installForPatternVerifierField(verifiers, "d", 2);
        PatternVerifierUtils.installForPatternVerifierField(verifiers, "Q");
        PatternVerifierUtils.installForPatternVerifierField(verifiers, "q");
        PatternVerifierUtils.installForPatternVerifierField(verifiers, "Y");
        PatternVerifierUtils.installForPatternVerifierField(verifiers, "w", 2, false);
        PatternVerifierUtils.installForPatternVerifierField(verifiers, "W", 1, false);
        PatternVerifierUtils.installForPatternVerifierField(verifiers, "E");
        PatternVerifierUtils.installForPatternVerifierField(verifiers, "e");
        PatternVerifierUtils.installForPatternVerifierField(verifiers, "c", 1);
        PatternVerifierUtils.installForPatternVerifierField(verifiers, "F", 1, false);
        PatternVerifierUtils.installForPatternVerifierField(verifiers, "a", 1);
        PatternVerifierUtils.installForPatternVerifierField(verifiers, "h", 2);
        PatternVerifierUtils.installForPatternVerifierField(verifiers, "K", 2);
        PatternVerifierUtils.installForPatternVerifierField(verifiers, "k", 2);
        PatternVerifierUtils.installForPatternVerifierField(verifiers, "H", 2);
        PatternVerifierUtils.installForPatternVerifierField(verifiers, "m", 2);
        PatternVerifierUtils.installForPatternVerifierField(verifiers, "s", 2);
        PatternVerifierUtils.installForPatternVerifierLongField(verifiers, "S", 9, false);
        PatternVerifierUtils.installForPatternVerifierLongField(verifiers, "A", 1);
        PatternVerifierUtils.installForPatternVerifierLongField(verifiers, "n");
        PatternVerifierUtils.installForPatternVerifierLongField(verifiers, "N");
    }

    private static void installForPatternVerifierField(ObservableMap<String, Callback<String, Boolean>> verifiers, String letter) {
        PatternVerifierUtils.installForPatternVerifierField(verifiers, letter, 5);
    }

    private static void installForPatternVerifierField(ObservableMap<String, Callback<String, Boolean>> verifiers, String letter, int maxCount) {
        PatternVerifierUtils.installForPatternVerifierField(verifiers, letter, maxCount, true);
    }

    private static void installForPatternVerifierField(ObservableMap<String, Callback<String, Boolean>> verifiers, String letter, int maxCount, boolean adjustable) {
        String pattern = letter;
        for (int i = 0; i < maxCount; ++i) {
            TemporalField field = FIELD_MAP.get(Character.valueOf(letter.charAt(0)));
            TemporalUnit unit = UNIT_MAP.get(Character.valueOf(letter.charAt(0)));
            verifiers.put((Object)pattern, (Object)(adjustable ? new IntegerTemporalPatternVerifier(field, unit, pattern, pattern.length() != 1) : new IntegerTemporalPatternVerifierNotAdjustable(field, unit, pattern, pattern.length() != 1)));
            pattern = pattern + letter;
        }
    }

    private static void installForPatternVerifierLongField(ObservableMap<String, Callback<String, Boolean>> verifiers, String letter) {
        PatternVerifierUtils.installForPatternVerifierLongField(verifiers, letter, 5);
    }

    private static void installForPatternVerifierLongField(ObservableMap<String, Callback<String, Boolean>> verifiers, String letter, int maxCount) {
        PatternVerifierUtils.installForPatternVerifierLongField(verifiers, letter, maxCount, true);
    }

    private static void installForPatternVerifierLongField(ObservableMap<String, Callback<String, Boolean>> verifiers, String letter, int maxCount, boolean adjustable) {
        String pattern = letter;
        for (int i = 0; i < maxCount; ++i) {
            TemporalField field = FIELD_MAP.get(Character.valueOf(letter.charAt(0)));
            TemporalUnit unit = UNIT_MAP.get(Character.valueOf(letter.charAt(0)));
            verifiers.put((Object)pattern, (Object)(adjustable ? new LongTemporalPatternVerifier(field, unit, pattern, pattern.length() != 1) : new LongTemporalPatternVerifierNotAdjustable(field, unit, pattern, pattern.length() != 1)));
            pattern = pattern + letter;
        }
    }

    static {
        FIELD_MAP.put(Character.valueOf('G'), ChronoField.ERA);
        FIELD_MAP.put(Character.valueOf('y'), ChronoField.YEAR);
        FIELD_MAP.put(Character.valueOf('u'), ChronoField.YEAR);
        FIELD_MAP.put(Character.valueOf('Q'), IsoFields.QUARTER_OF_YEAR);
        FIELD_MAP.put(Character.valueOf('q'), IsoFields.QUARTER_OF_YEAR);
        FIELD_MAP.put(Character.valueOf('Y'), ChronoField.YEAR);
        FIELD_MAP.put(Character.valueOf('w'), ChronoField.ALIGNED_WEEK_OF_YEAR);
        FIELD_MAP.put(Character.valueOf('W'), ChronoField.ALIGNED_WEEK_OF_MONTH);
        FIELD_MAP.put(Character.valueOf('M'), ChronoField.MONTH_OF_YEAR);
        FIELD_MAP.put(Character.valueOf('L'), ChronoField.MONTH_OF_YEAR);
        FIELD_MAP.put(Character.valueOf('D'), ChronoField.DAY_OF_YEAR);
        FIELD_MAP.put(Character.valueOf('d'), ChronoField.DAY_OF_MONTH);
        FIELD_MAP.put(Character.valueOf('F'), ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH);
        FIELD_MAP.put(Character.valueOf('E'), ChronoField.DAY_OF_WEEK);
        FIELD_MAP.put(Character.valueOf('c'), ChronoField.DAY_OF_WEEK);
        FIELD_MAP.put(Character.valueOf('e'), ChronoField.DAY_OF_WEEK);
        FIELD_MAP.put(Character.valueOf('a'), ChronoField.AMPM_OF_DAY);
        FIELD_MAP.put(Character.valueOf('H'), ChronoField.HOUR_OF_DAY);
        FIELD_MAP.put(Character.valueOf('k'), ChronoField.CLOCK_HOUR_OF_DAY);
        FIELD_MAP.put(Character.valueOf('K'), ChronoField.HOUR_OF_AMPM);
        FIELD_MAP.put(Character.valueOf('h'), ChronoField.HOUR_OF_AMPM);
        FIELD_MAP.put(Character.valueOf('m'), ChronoField.MINUTE_OF_HOUR);
        FIELD_MAP.put(Character.valueOf('s'), ChronoField.SECOND_OF_MINUTE);
        FIELD_MAP.put(Character.valueOf('S'), ChronoField.NANO_OF_SECOND);
        FIELD_MAP.put(Character.valueOf('A'), ChronoField.MILLI_OF_DAY);
        FIELD_MAP.put(Character.valueOf('n'), ChronoField.NANO_OF_SECOND);
        FIELD_MAP.put(Character.valueOf('N'), ChronoField.NANO_OF_DAY);
        UNIT_MAP.put(Character.valueOf('G'), ChronoUnit.ERAS);
        UNIT_MAP.put(Character.valueOf('y'), ChronoUnit.YEARS);
        UNIT_MAP.put(Character.valueOf('u'), ChronoUnit.YEARS);
        UNIT_MAP.put(Character.valueOf('Q'), ChronoUnit.MONTHS);
        UNIT_MAP.put(Character.valueOf('q'), ChronoUnit.MONTHS);
        UNIT_MAP.put(Character.valueOf('Y'), ChronoUnit.YEARS);
        UNIT_MAP.put(Character.valueOf('w'), ChronoUnit.WEEKS);
        UNIT_MAP.put(Character.valueOf('W'), ChronoUnit.WEEKS);
        UNIT_MAP.put(Character.valueOf('M'), ChronoUnit.MONTHS);
        UNIT_MAP.put(Character.valueOf('L'), ChronoUnit.MONTHS);
        UNIT_MAP.put(Character.valueOf('D'), ChronoUnit.DAYS);
        UNIT_MAP.put(Character.valueOf('d'), ChronoUnit.DAYS);
        UNIT_MAP.put(Character.valueOf('F'), ChronoUnit.WEEKS);
        UNIT_MAP.put(Character.valueOf('E'), ChronoUnit.DAYS);
        UNIT_MAP.put(Character.valueOf('c'), ChronoUnit.DAYS);
        UNIT_MAP.put(Character.valueOf('e'), ChronoUnit.DAYS);
        UNIT_MAP.put(Character.valueOf('a'), ChronoUnit.HALF_DAYS);
        UNIT_MAP.put(Character.valueOf('H'), ChronoUnit.HOURS);
        UNIT_MAP.put(Character.valueOf('k'), ChronoUnit.HOURS);
        UNIT_MAP.put(Character.valueOf('K'), ChronoUnit.HOURS);
        UNIT_MAP.put(Character.valueOf('h'), ChronoUnit.HOURS);
        UNIT_MAP.put(Character.valueOf('m'), ChronoUnit.MINUTES);
        UNIT_MAP.put(Character.valueOf('s'), ChronoUnit.SECONDS);
        UNIT_MAP.put(Character.valueOf('S'), ChronoUnit.NANOS);
        UNIT_MAP.put(Character.valueOf('A'), ChronoUnit.MILLIS);
        UNIT_MAP.put(Character.valueOf('n'), ChronoUnit.NANOS);
        UNIT_MAP.put(Character.valueOf('N'), ChronoUnit.NANOS);
    }
}

