/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field;

import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.util.Callback;
import jidefx.scene.control.decoration.DecorationUtils;
import jidefx.scene.control.decoration.Decorator;
import jidefx.scene.control.decoration.PredefinedDecorators;
import jidefx.scene.control.field.FieldsResource;
import jidefx.scene.control.field.FormattedTextField;
import jidefx.scene.control.field.popup.PopupContent;
import jidefx.scene.control.popup.BalloonPopupOutline;
import jidefx.scene.control.popup.PopupOutline;
import jidefx.scene.control.popup.ShapedPopup;

public class PopupField<T>
extends FormattedTextField<T> {
    private static final String STYLE_CLASS_DEFAULT = "popup-field";
    private ShapedPopup _shapedPopup;
    private Decorator<Button> _popupButtonDecorator;
    private BooleanProperty _popupButtonVisibleProperty;
    private ObjectProperty<Callback<T, PopupContent<T>>> _popupContentFactory;

    @Override
    protected void initializeStyle() {
        super.initializeStyle();
        this.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_DEFAULT});
    }

    public BooleanProperty popupButtonVisibleProperty() {
        if (this._popupButtonVisibleProperty == null) {
            this._popupButtonVisibleProperty = new SimpleBooleanProperty(this, "popupButtonVisible"){

                protected void invalidated() {
                    super.invalidated();
                    boolean visible = this.get();
                    if (visible && PopupField.this.getPopupContentFactory() != null) {
                        PopupField.this.showPopupButton();
                    } else {
                        PopupField.this.hidePopupButton();
                    }
                }
            };
        }
        return this._popupButtonVisibleProperty;
    }

    public boolean isPopupButtonVisible() {
        return this.popupButtonVisibleProperty().get();
    }

    public void setPopupButtonVisible(boolean popupButtonVisible) {
        this.popupButtonVisibleProperty().set(popupButtonVisible);
    }

    private void showPopupButton() {
        if (this._popupButtonDecorator == null) {
            this._popupButtonDecorator = this.createPopupButtonDecorator();
            ((Button)this._popupButtonDecorator.getNode()).disableProperty().bind((ObservableValue)this.disabledProperty());
            ((Button)this._popupButtonDecorator.getNode()).setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    PopupField.this.togglePopup();
                }
            });
        }
        DecorationUtils.install((Node)this, this._popupButtonDecorator);
    }

    protected Decorator<Button> createPopupButtonDecorator() {
        return (Decorator)PredefinedDecorators.getInstance().getPopupButtonDecoratorSupplier().get();
    }

    private void hidePopupButton() {
        if (this._popupButtonDecorator != null) {
            DecorationUtils.uninstall((Node)this, this._popupButtonDecorator);
        }
    }

    protected void togglePopup() {
        if (this._shapedPopup == null || !this._shapedPopup.isShowing()) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void hide() {
        if (this._shapedPopup != null) {
            this._shapedPopup.hide();
            this._shapedPopup = null;
        }
    }

    public void show() {
        PopupContent popupContent;
        if (this._shapedPopup != null) {
            this.hide();
        }
        if (!this.commitEdit()) {
            this.cancelEdit();
        }
        if ((popupContent = this.createPopupContent(this.getValue())) != null) {
            this._shapedPopup = new ShapedPopup();
            this._shapedPopup.setPopupContent((Node)((Parent)popupContent));
            this.showPopup(this._popupButtonDecorator.getNode(), this._shapedPopup);
        }
    }

    protected void customizePopupContent(PopupContent<T> popupContent) {
        popupContent.valueProperty().addListener(new ChangeListener<T>(){

            public void changed(ObservableValue<? extends T> observable, T oldValue, T newValue) {
                PopupField.this.setValue(newValue);
            }
        });
    }

    protected void showPopup(Node owner, ShapedPopup shapedPopup) {
        BalloonPopupOutline outline = new BalloonPopupOutline();
        outline.setArrowSide(Side.TOP);
        outline.setArrowPosition(0.9);
        outline.setArrowBasePosition(0.9);
        shapedPopup.setPopupOutline((PopupOutline)outline);
        shapedPopup.showPopup(owner, Pos.BOTTOM_CENTER, 0.0, 0.0);
    }

    protected PopupContent<T> createPopupContent(T value) {
        Callback<T, PopupContent<T>> factory = this.getPopupContentFactory();
        if (factory != null) {
            PopupContent popupContent = (PopupContent)factory.call(value);
            this.customizePopupContent(popupContent);
            return popupContent;
        }
        return null;
    }

    public final void setPopupContentFactory(Callback<T, PopupContent<T>> value) {
        this.popupContentFactoryProperty().set(value);
    }

    public final Callback<T, PopupContent<T>> getPopupContentFactory() {
        return (Callback)this.popupContentFactoryProperty().get();
    }

    public ObjectProperty<Callback<T, PopupContent<T>>> popupContentFactoryProperty() {
        if (this._popupContentFactory == null) {
            this._popupContentFactory = new SimpleObjectProperty((Object)this, "popupContentFactory");
        }
        return this._popupContentFactory;
    }

    public String getResourceString(String key) {
        if (key == null) {
            return "";
        }
        return FieldsResource.getResourceBundle(Locale.getDefault()).getString(key);
    }
}

