/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Point3D;
import javafx.util.Callback;
import jidefx.scene.control.field.DoubleField;
import jidefx.scene.control.field.FormattedTextField;
import jidefx.scene.control.field.PopupField;
import jidefx.scene.control.field.popup.PopupContent;
import jidefx.scene.control.field.popup.ValuesPopupContent;
import jidefx.scene.control.field.verifier.NumberValuePatternVerifier;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.javafx.Point3DConverter;

public class Point3DField
extends PopupField<Point3D> {
    private static final String STYLE_CLASS_DEFAULT = "point-3d-field";

    @Override
    protected void initializeStyle() {
        super.initializeStyle();
        this.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_DEFAULT});
    }

    @Override
    protected void initializePattern() {
        super.initializePattern();
        this.setStringConverter(new Point3DConverter(){

            protected String toString(int i, Double o, ConverterContext context) {
                if (o == null) {
                    return "";
                }
                return o.toString();
            }

            protected Double fromString(int i, String s, ConverterContext context) {
                if (s == null || s.trim().isEmpty()) {
                    return null;
                }
                return Double.valueOf(s);
            }
        }.toStringConverter());
        this.getPatternVerifiers().put((Object)"X", (Object)new NumberValuePatternVerifier<Point3D>(){

            @Override
            public Double toTargetValue(Point3D fieldValue) {
                return fieldValue.getX();
            }

            @Override
            public Point3D fromTargetValue(Point3D previousFieldValue, Number value) {
                double x = value.doubleValue();
                return previousFieldValue != null ? new Point3D(x, previousFieldValue.getY(), previousFieldValue.getZ()) : new Point3D(x, 0.0, 0.0);
            }
        });
        this.getPatternVerifiers().put((Object)"Y", (Object)new NumberValuePatternVerifier<Point3D>(){

            @Override
            public Double toTargetValue(Point3D fieldValue) {
                return fieldValue.getY();
            }

            @Override
            public Point3D fromTargetValue(Point3D previousFieldValue, Number value) {
                double y = value.doubleValue();
                return previousFieldValue != null ? new Point3D(previousFieldValue.getX(), y, previousFieldValue.getZ()) : new Point3D(0.0, y, 0.0);
            }
        });
        this.getPatternVerifiers().put((Object)"Z", (Object)new NumberValuePatternVerifier<Point3D>(){

            @Override
            public Double toTargetValue(Point3D fieldValue) {
                return fieldValue.getZ();
            }

            @Override
            public Point3D fromTargetValue(Point3D previousFieldValue, Number value) {
                double z = value.doubleValue();
                return previousFieldValue != null ? new Point3D(previousFieldValue.getX(), previousFieldValue.getY(), z) : new Point3D(0.0, 0.0, z);
            }
        });
        this.setPattern("X; Y; Z");
    }

    @Override
    protected void initializeTextField() {
        super.initializeTextField();
        this.setPopupContentFactory(new Callback<Point3D, PopupContent<Point3D>>(){

            public PopupContent<Point3D> call(Point3D param) {
                ValuesPopupContent<Point3D, Double> popupContent = new ValuesPopupContent<Point3D, Double>(new String[]{Point3DField.this.getResourceString("x"), Point3DField.this.getResourceString("y"), Point3DField.this.getResourceString("z")}){

                    @Override
                    public List<Double> toValues(Point3D value) {
                        ArrayList<Double> list = new ArrayList<Double>(3);
                        list.add(value.getX());
                        list.add(value.getY());
                        list.add(value.getZ());
                        return list;
                    }

                    @Override
                    public Point3D fromValues(List<Double> values) {
                        return new Point3D(values.get(0).doubleValue(), values.get(1).doubleValue(), values.get(2).doubleValue());
                    }

                    @Override
                    public FormattedTextField<Double> createTextField(String label) {
                        return new DoubleField();
                    }
                };
                popupContent.setValue((Point3D)Point3DField.this.getValue());
                return popupContent;
            }
        });
    }
}

