/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.IndexRange;
import javafx.scene.control.TextField;
import javafx.scene.layout.Region;
import javafx.util.Callback;
import jidefx.scene.control.decoration.DecorationDelegate;
import jidefx.scene.control.decoration.DecorationSupport;
import jidefx.scene.control.decoration.DecorationUtils;
import jidefx.scene.control.decoration.Decorator;
import jidefx.scene.control.decoration.PredefinedDecorators;

public class MaskTextField
extends TextField
implements DecorationSupport {
    private static final String STYLE_CLASS_DEFAULT = "mask-combo-box";
    public static final char INPUT_MASK_LETTER = 'A';
    public static final char INPUT_MASK_DIGIT_OR_LETTER = 'N';
    public static final char INPUT_MASK_ANY_NON_SPACE = 'X';
    public static final char INPUT_MASK_HAX = 'H';
    public static final char INPUT_MASK_DIGIT_NON_ZERO = 'D';
    public static final char INPUT_MASK_DIGIT = '9';
    public static final char INPUT_MASK_DIGIT_0_TO_8 = '8';
    public static final char INPUT_MASK_DIGIT_0_TO_7 = '7';
    public static final char INPUT_MASK_DIGIT_0_TO_6 = '6';
    public static final char INPUT_MASK_DIGIT_0_TO_5 = '5';
    public static final char INPUT_MASK_DIGIT_0_TO_4 = '4';
    public static final char INPUT_MASK_DIGIT_0_TO_3 = '3';
    public static final char INPUT_MASK_DIGIT_0_TO_2 = '2';
    public static final char INPUT_MASK_DIGIT_0_TO_1 = '1';
    public static final char INPUT_MASK_DIGIT_ZERO = '0';
    public static final char CONVERSION_MASK_UPPER_CASE = 'U';
    public static final char CONVERSION_MASK_LOWER_CASE = 'L';
    public static final char CONVERSION_MASK_IGNORE = '_';
    public static final char REQUIRED_MASK_REQUIRED = 'R';
    public static final char REQUIRED_MASK_NOT_REQUIRED = '_';
    private StringProperty _inputMaskProperty;
    private StringProperty _requiredMaskProperty;
    private StringProperty _conversionMaskProperty;
    private StringProperty _validCharactersProperty;
    private StringProperty _invalidCharactersProperty;
    private ObjectProperty<Character> _placeholderCharacterProperty;
    private StringProperty _initialTextProperty;
    private BooleanProperty _autoAdvanceProperty;
    private BooleanProperty _clearbuttonVisibleProperty;
    private Decorator<Button> _clearButtonDecorator;
    private ObservableMap<Character, Callback<Character, Boolean>> _maskVerifiers;
    private ObservableMap<Character, Callback<Character, Character>> _conversions;
    private String _fixedText;
    boolean enforcing = true;
    private DecorationDelegate _operator;

    public MaskTextField() {
        this.initializeTextField();
        this.initializeStyle();
        this.registerListeners();
    }

    public MaskTextField(String text) {
        super(text);
        this.initializeTextField();
        this.initializeStyle();
        this.registerListeners();
    }

    protected void initializeStyle() {
        this.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_DEFAULT, "decoration-support"});
    }

    protected void initializeTextField() {
        this.initializeInputMaskVerifiers();
        this.initializeConversions();
    }

    protected void initializeInputMaskVerifiers() {
        ObservableMap<Character, Callback<Character, Boolean>> maskVerifiers = this.getInputMaskVerifiers();
        maskVerifiers.clear();
        maskVerifiers.put(Character.valueOf('A'), c -> Character.isLetter(c.charValue()));
        maskVerifiers.put(Character.valueOf('N'), c -> Character.isLetterOrDigit(c.charValue()));
        maskVerifiers.put(Character.valueOf('X'), c -> !Character.isSpaceChar(c.charValue()));
        maskVerifiers.put(Character.valueOf('H'), c -> c.charValue() >= 'A' && c.charValue() <= 'F' || c.charValue() >= 'a' && c.charValue() <= 'f' || Character.isDigit(c.charValue()));
        maskVerifiers.put(Character.valueOf('D'), c -> Character.isDigit(c.charValue()) && c.charValue() != '0');
        maskVerifiers.put(Character.valueOf('9'), c -> Character.isDigit(c.charValue()));
        maskVerifiers.put(Character.valueOf('8'), c -> c.charValue() >= '0' && c.charValue() <= '8');
        maskVerifiers.put(Character.valueOf('7'), c -> c.charValue() >= '0' && c.charValue() <= '7');
        maskVerifiers.put(Character.valueOf('6'), c -> c.charValue() >= '0' && c.charValue() <= '6');
        maskVerifiers.put(Character.valueOf('5'), c -> c.charValue() >= '0' && c.charValue() <= '5');
        maskVerifiers.put(Character.valueOf('4'), c -> c.charValue() >= '0' && c.charValue() <= '4');
        maskVerifiers.put(Character.valueOf('3'), c -> c.charValue() >= '0' && c.charValue() <= '3');
        maskVerifiers.put(Character.valueOf('2'), c -> c.charValue() >= '0' && c.charValue() <= '2');
        maskVerifiers.put(Character.valueOf('1'), c -> c.charValue() >= '0' && c.charValue() <= '1');
        maskVerifiers.put(Character.valueOf('0'), c -> c.charValue() == '0');
    }

    public ObservableMap<Character, Callback<Character, Boolean>> getInputMaskVerifiers() {
        if (this._maskVerifiers == null) {
            this._maskVerifiers = FXCollections.observableHashMap();
        }
        return this._maskVerifiers;
    }

    protected void initializeConversions() {
        ObservableMap<Character, Callback<Character, Character>> conversions = this.getConversions();
        conversions.clear();
        conversions.put(Character.valueOf('U'), c -> Character.valueOf(Character.toUpperCase(c.charValue())));
        conversions.put(Character.valueOf('L'), c -> Character.valueOf(Character.toLowerCase(c.charValue())));
    }

    public ObservableMap<Character, Callback<Character, Character>> getConversions() {
        if (this._conversions == null) {
            this._conversions = FXCollections.observableHashMap();
        }
        return this._conversions;
    }

    protected void registerListeners() {
        InvalidationListener verifierListener = new InvalidationListener(){

            public void invalidated(Observable observable) {
                MaskTextField.this.clear();
            }
        };
        this.getInputMaskVerifiers().addListener(verifierListener);
        this.editableProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){
            private final String comboBoxStyleClass = "combo-box-field";
            private final String textInputStyleClass = "text-input";

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    MaskTextField.this.getStyleClass().remove((Object)"combo-box-field");
                    MaskTextField.this.getStyleClass().add((Object)"text-input");
                } else {
                    MaskTextField.this.getStyleClass().add((Object)"combo-box-field");
                    MaskTextField.this.getStyleClass().remove((Object)"text-input");
                }
            }
        });
    }

    public void clear() {
        this.setTextWithoutChecking(this.getInitialText() != null ? this.getInitialText() : this.getInitialTextFromMask());
    }

    private void setTextWithoutChecking(String text) {
        try {
            this.enforcing = false;
            this.setText(text);
        }
        finally {
            this.enforcing = true;
        }
    }

    private String getFixedText() {
        if (this._fixedText == null) {
            this._fixedText = this.getInitialTextFromMask();
        }
        return this._fixedText;
    }

    private String getInitialTextFromMask() {
        String mask = this.getInputMask();
        ObservableMap<Character, Callback<Character, Boolean>> maskVerifiers = this.getInputMaskVerifiers();
        for (Character c : maskVerifiers.keySet()) {
            mask = mask.replace(c.charValue(), this.getPlaceholderCharacter());
        }
        this._fixedText = mask;
        return mask;
    }

    public ObjectProperty<Character> placeholderCharacterProperty() {
        if (this._placeholderCharacterProperty == null) {
            this._placeholderCharacterProperty = new SimpleObjectProperty<Character>((Object)this, "placeholderCharacter", Character.valueOf(' ')){

                protected void invalidated() {
                    super.invalidated();
                    MaskTextField.this.clear();
                }
            };
        }
        return this._placeholderCharacterProperty;
    }

    public char getPlaceholderCharacter() {
        return ((Character)this.placeholderCharacterProperty().get()).charValue();
    }

    public void setPlaceholderCharacter(char placeholderCharacter) {
        this.placeholderCharacterProperty().set((Object)Character.valueOf(placeholderCharacter));
    }

    public StringProperty inputMaskProperty() {
        if (this._inputMaskProperty == null) {
            this._inputMaskProperty = new SimpleStringProperty((Object)this, "inputMask"){

                protected void invalidated() {
                    super.invalidated();
                    MaskTextField.this.clear();
                }
            };
        }
        return this._inputMaskProperty;
    }

    public String getInputMask() {
        return (String)this.inputMaskProperty().get();
    }

    public void setInputMask(String inputMask) {
        this.inputMaskProperty().set((Object)inputMask);
    }

    public StringProperty requiredMaskProperty() {
        if (this._requiredMaskProperty == null) {
            this._requiredMaskProperty = new SimpleStringProperty((Object)this, "requiredMask");
        }
        return this._requiredMaskProperty;
    }

    public String getRequiredMask() {
        return (String)this.requiredMaskProperty().get();
    }

    public void setRequiredMask(String requiredMask) {
        this.requiredMaskProperty().set((Object)requiredMask);
    }

    public StringProperty conversionMaskProperty() {
        if (this._conversionMaskProperty == null) {
            this._conversionMaskProperty = new SimpleStringProperty((Object)this, "conversionMask");
        }
        return this._conversionMaskProperty;
    }

    public String getConversionMask() {
        return (String)this.conversionMaskProperty().get();
    }

    public void setConversionMask(String mask) {
        this.conversionMaskProperty().set((Object)mask);
    }

    public StringProperty validCharactersProperty() {
        if (this._validCharactersProperty == null) {
            this._validCharactersProperty = new SimpleStringProperty((Object)this, "validCharacters");
        }
        return this._validCharactersProperty;
    }

    public String getValidCharacters() {
        return (String)this.validCharactersProperty().get();
    }

    public void setValidCharacters(String validCharacters) {
        this.validCharactersProperty().set((Object)validCharacters);
    }

    public StringProperty invalidCharactersProperty() {
        if (this._invalidCharactersProperty == null) {
            this._invalidCharactersProperty = new SimpleStringProperty((Object)this, "invalidCharacters");
        }
        return this._invalidCharactersProperty;
    }

    public String getInvalidCharacters() {
        return (String)this.invalidCharactersProperty().get();
    }

    public void setInvalidCharacters(String invalidCharacters) {
        this.invalidCharactersProperty().set((Object)invalidCharacters);
    }

    public StringProperty initialTextProperty() {
        if (this._initialTextProperty == null) {
            this._initialTextProperty = new SimpleStringProperty((Object)this, "initialText"){

                protected void invalidated() {
                    super.invalidated();
                    MaskTextField.this.clear();
                }
            };
        }
        return this._initialTextProperty;
    }

    public String getInitialText() {
        return (String)this.initialTextProperty().get();
    }

    public void setInitialText(String mask) {
        this.initialTextProperty().set((Object)mask);
    }

    public BooleanProperty autoAdvanceProperty() {
        if (this._autoAdvanceProperty == null) {
            this._autoAdvanceProperty = new SimpleBooleanProperty((Object)this, "autoAdvance", true);
        }
        return this._autoAdvanceProperty;
    }

    public boolean isAutoAdvance() {
        return this.autoAdvanceProperty().get();
    }

    public void setAutoAdvance(boolean autoAdvance) {
        this.autoAdvanceProperty().set(autoAdvance);
    }

    private String keepFixedText(String text) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            String s = text.substring(i, i + 1);
            if (this.getFixedText().contains(s)) {
                buf.append(s);
                continue;
            }
            buf.append(this.getPlaceholderCharacter());
        }
        return buf.toString();
    }

    private char convert(char c, int index) {
        Callback callback;
        String conversionMask = this.getConversionMask();
        if (Character.isSpaceChar(c) && this.getInputMaskVerifiers().containsKey((Object)Character.valueOf(this.getInputMask().charAt(index)))) {
            return this.getPlaceholderCharacter();
        }
        if (conversionMask != null && index < conversionMask.length() && (callback = (Callback)this.getConversions().get((Object)Character.valueOf(conversionMask.charAt(index)))) != null) {
            return ((Character)callback.call((Object)Character.valueOf(c))).charValue();
        }
        return c;
    }

    private boolean verifyChar(char c, int index) {
        String inputMask = this.getInputMask();
        if (inputMask != null && index < inputMask.length()) {
            String requiredMask;
            char maskChar = inputMask.charAt(index);
            if (maskChar == c) {
                return true;
            }
            if ((Character.isSpaceChar(c) || c == this.getPlaceholderCharacter()) && (requiredMask = this.getRequiredMask()) != null && index < requiredMask.length()) {
                return requiredMask.charAt(index) == '_';
            }
            Callback callback = (Callback)this.getInputMaskVerifiers().get((Object)Character.valueOf(maskChar));
            return !(this.getValidCharacters() != null && !this.getValidCharacters().trim().isEmpty() && !this.getValidCharacters().contains("" + this.convert(c, index)) || this.getInvalidCharacters() != null && !this.getInvalidCharacters().trim().isEmpty() && this.getInvalidCharacters().contains("" + this.convert(c, index)) || !(callback != null ? (Boolean)callback.call((Object)Character.valueOf(this.convert(c, index))) != false : maskChar == this.convert(c, index)));
        }
        return false;
    }

    public void replaceText(int start, int end, String text) {
        if (this.getInputMask() != null) {
            int index = 0;
            int count = end - start;
            int caret = this.getCaretPosition();
            String existingText = this.getText();
            String deletedText = existingText.substring(start, end);
            String newText = this.keepFixedText(deletedText);
            super.replaceText(start, end, newText);
            while (start < this.getInputMask().length() && index < text.length()) {
                char c = text.charAt(index);
                if (this.verifyChar(c, start)) {
                    if (this.getText().length() > start) {
                        super.replaceText(start, start + 1, "" + this.convert(c, start));
                    } else {
                        super.replaceText(start, start, "" + this.convert(c, start));
                    }
                    ++index;
                    ++start;
                    --count;
                } else {
                    if (!this.isAutoAdvance() || !this.getFixedText().contains("" + c) && (caret >= existingText.length() || existingText.charAt(caret) == this.getPlaceholderCharacter() || !this.getFixedText().contains("" + existingText.charAt(caret)))) break;
                    ++start;
                    this.selectRange(++caret, caret);
                }
                if (count > 0 || index < text.length()) continue;
                break;
            }
        } else {
            super.replaceText(start, end, text);
        }
    }

    public void replaceSelection(String replacement) {
        IndexRange range = this.getSelection();
        if (this.getInputMask() != null) {
            String newText = this.keepFixedText(this.getSelectedText());
            super.replaceText(range.getStart(), range.getEnd(), newText);
            this.selectRange(range.getStart(), range.getStart());
            for (int i = 0; i < replacement.length(); ++i) {
                int start = this.getCaretPosition();
                this.replaceText(start, start, "" + replacement.charAt(i));
            }
        } else {
            super.replaceSelection(replacement);
        }
    }

    public static MaskTextField createSSNField() {
        MaskTextField field = new MaskTextField();
        field.setInputMask("999-99-9999");
        field.setPlaceholderCharacter('#');
        return field;
    }

    public static MaskTextField createPhoneNumberField() {
        MaskTextField field = new MaskTextField();
        field.setInputMask("(999) 999-9999");
        return field;
    }

    public static MaskTextField createZipCodeField() {
        MaskTextField field = new MaskTextField();
        field.setInputMask("99999");
        return field;
    }

    public static MaskTextField createZipCodePlus4Field() {
        MaskTextField field = new MaskTextField();
        field.setInputMask("99999-9999");
        return field;
    }

    public static MaskTextField createCanadaPostalCodeField() {
        MaskTextField field = new MaskTextField();
        field.setInputMask("A9A 9A9");
        field.setConversionMask("U_U _U_");
        field.setPlaceholderCharacter('_');
        field.setAutoAdvance(false);
        return field;
    }

    public static MaskTextField createSerialNumberField() {
        MaskTextField field = new MaskTextField();
        field.setInputMask("NNNNN-NNNNN-NNNNN-NNNNN-NNNNN");
        field.setConversionMask("UUUUU_UUUUU_UUUUU_UUUUU_UUUUU");
        return field;
    }

    public static MaskTextField createIPv6Field() {
        MaskTextField field = new MaskTextField();
        field.setInputMask("HHHH:HHHH:HHHH:HHHH:HHHH:HHHH:HHHH:HHHH");
        field.setConversionMask("LLLL_LLLL_LLLL_LLLL_LLLL_LLLL_LLLL_LLLL");
        return field;
    }

    public static MaskTextField createMacAddressField() {
        MaskTextField field = new MaskTextField();
        field.setInputMask("HH:HH:HH:HH:HH:HH");
        field.setConversionMask("LL:LL:LL:LL:LL:LL");
        return field;
    }

    public static MaskTextField createDateField() {
        final MaskTextField field = new MaskTextField();
        field.setInputMask("19/39/9999");
        field.setConversionMask("_x/_y/____");
        field.getConversions().put((Object)Character.valueOf('x'), (Object)new Callback<Character, Character>(){

            public Character call(Character param) {
                char c = field.getText().charAt(0);
                if (c == '1' && param.charValue() > '2') {
                    return Character.valueOf('2');
                }
                return param;
            }
        });
        field.getConversions().put((Object)Character.valueOf('y'), (Object)new Callback<Character, Character>(){

            public Character call(Character param) {
                char c = field.getText().charAt(3);
                if (c == '3' && param.charValue() > '1') {
                    return Character.valueOf('1');
                }
                return param;
            }
        });
        field.setInitialText(new SimpleDateFormat("MM/dd/yyyy").format(Calendar.getInstance().getTime()));
        return field;
    }

    public static MaskTextField createTime12Field() {
        final MaskTextField field = new MaskTextField();
        field.setInputMask("19:59:59 xm");
        field.getInputMaskVerifiers().put((Object)Character.valueOf('x'), (Object)new Callback<Character, Boolean>(){

            public Boolean call(Character c) {
                return c.charValue() == 'A' || c.charValue() == 'P';
            }
        });
        field.getInputMaskVerifiers().put((Object)Character.valueOf('m'), (Object)new Callback<Character, Boolean>(){

            public Boolean call(Character c) {
                return c.charValue() == 'M';
            }
        });
        field.setConversionMask("_x:__:__ UU");
        field.getConversions().put((Object)Character.valueOf('x'), (Object)new Callback<Character, Character>(){

            public Character call(Character c) {
                char firstChar = field.getText().charAt(0);
                if (firstChar == '1' && c.charValue() > '2') {
                    return Character.valueOf('2');
                }
                if (firstChar == '0' && c.charValue() == '0') {
                    return Character.valueOf('1');
                }
                return c;
            }
        });
        field.setInitialText(new SimpleDateFormat("hh:mm:ss aa").format(Calendar.getInstance().getTime()));
        return field;
    }

    public static MaskTextField createTime24Field() {
        final MaskTextField field = new MaskTextField();
        field.setInputMask("29:59:59");
        field.setConversionMask("_x:__:__");
        field.getConversions().put((Object)Character.valueOf('x'), (Object)new Callback<Character, Character>(){

            public Character call(Character c) {
                char firstChar = field.getText().charAt(0);
                if (firstChar == '2' && c.charValue() > '3') {
                    return Character.valueOf('3');
                }
                return c;
            }
        });
        field.setInitialText(new SimpleDateFormat("HH:mm:ss").format(Calendar.getInstance().getTime()));
        return field;
    }

    private void showClearButton() {
        if (this._clearButtonDecorator == null) {
            this._clearButtonDecorator = (Decorator)PredefinedDecorators.getInstance().getClearButtonDecoratorSupplier().get();
            ((Button)this._clearButtonDecorator.getNode()).disableProperty().bind((ObservableValue)this.disabledProperty());
            ((Button)this._clearButtonDecorator.getNode()).setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    if (!MaskTextField.this.isDisabled()) {
                        MaskTextField.this.clear();
                    }
                }
            });
        }
        DecorationUtils.install((Node)this, this._clearButtonDecorator);
    }

    private void hideClearButton() {
        if (this._clearButtonDecorator != null) {
            DecorationUtils.uninstall((Node)this, this._clearButtonDecorator);
        }
    }

    public BooleanProperty clearButtonVisibleProperty() {
        if (this._clearbuttonVisibleProperty == null) {
            this._clearbuttonVisibleProperty = new SimpleBooleanProperty((Object)this, "clearButtonVisible"){

                protected void invalidated() {
                    super.invalidated();
                    if (this.get()) {
                        MaskTextField.this.showClearButton();
                    } else {
                        MaskTextField.this.hideClearButton();
                    }
                }
            };
        }
        return this._clearbuttonVisibleProperty;
    }

    public boolean isClearButtonVisible() {
        return this.clearButtonVisibleProperty().get();
    }

    public void setClearButtonVisible(boolean clearButtonVisible) {
        this.clearButtonVisibleProperty().set(clearButtonVisible);
    }

    protected void layoutChildren() {
        this.prepareDecorations();
        super.layoutChildren();
        Platform.runLater(this::layoutDecorations);
    }

    public void prepareDecorations() {
        if (this._operator == null) {
            this._operator = new DecorationDelegate((Region)this);
        }
        this._operator.prepareDecorations();
    }

    public void layoutDecorations() {
        this._operator.layoutDecorations();
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void positionInArea(Node child, double areaX, double areaY, double areaWidth, double areaHeight, double areaBaselineOffset, HPos halignment, VPos valignment) {
        super.positionInArea(child, areaX, areaY, areaWidth, areaHeight, areaBaselineOffset, halignment, valignment);
    }
}

