/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field;

import com.sun.javafx.scene.control.skin.TextFieldSkin;
import com.sun.javafx.scene.text.HitInfo;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Cell;
import javafx.scene.control.IndexRange;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Region;
import javafx.scene.shape.Shape;
import javafx.util.Callback;
import javafx.util.StringConverter;
import jidefx.scene.control.decoration.DecorationDelegate;
import jidefx.scene.control.decoration.DecorationPane;
import jidefx.scene.control.decoration.DecorationSupport;
import jidefx.scene.control.decoration.DecorationUtils;
import jidefx.scene.control.decoration.Decorator;
import jidefx.scene.control.decoration.PredefinedDecorators;
import jidefx.scene.control.editor.Editor;
import jidefx.scene.control.field.SpinnerStyle;
import jidefx.scene.control.field.verifier.IntegerRangePatternVerifier;
import jidefx.scene.control.field.verifier.PatternVerifier;
import jidefx.utils.AutoRepeatButtonUtils;
import jidefx.utils.CommonUtils;
import jidefx.utils.PredefinedShapes;

public class FormattedTextField<T>
extends TextField
implements DecorationSupport,
Editor<T> {
    private static final String STYLE_CLASS_DEFAULT = "formatted-text-field";
    private static final String STYLE_CLASS_NO_BACKGROUND_BUTTON = "no-background-button";
    private static final String STYLE_CLASS_INCREASE_BUTTON_ = "increase-button";
    private static final String STYLE_CLASS_DECREASE_BUTTON = "decrease-button";
    private static final String PROPERTY_FORMATTED_TEXT_FIELD_ADJUSTMENT_MOUSE_HANDLER = "FormattedTextField.AdjustmentMouseHandler";
    private StringProperty _patternProperty;
    private StringProperty _regularExpressionProperty;
    private BooleanProperty _autoAdvanceProperty;
    private BooleanProperty _autoReformatProperty;
    private BooleanProperty _autoSelectAllProperty;
    private boolean _internalAutoSelectAll = true;
    private ObjectProperty<T> _valueProperty;
    private ObjectProperty<T> _defaultValueProperty;
    private ObjectProperty<StringConverter<T>> _stringConverterProperty;
    private BooleanProperty _clearbuttonVisibleProperty;
    private Decorator<Button> _clearButtonDecorator;
    private BooleanProperty _spinnersVisibleProperty;
    private ObservableMap<String, Callback<String, Boolean>> _patternVerifiers;
    private String _fixedText;
    private DecorationPane _decorationPane;
    private Decorator<Button> _increaseDecorator;
    private Decorator<Button> _decreaseDecorator;
    private Button _decreaseSpinnerButton;
    private Button _increaseSpinnerButton;
    private boolean enforcing = true;
    private String comboBoxStyleClass = "combo-box-field";
    private String textInputStyleClass = "text-input";
    private double spinnerArrowIconSize = 10.0;
    private double spinnerButtonSize = 12.0;
    private double spinnerPadding = 100.0;
    private double spinnerOffsetX = 80.0;
    private double spinnerOffsetY = 40.0;
    private double horizontalTotalWidthRatio = 2.8;
    private double verticalTotalWidthRatio = 1.8;
    private BooleanProperty _comboBoxLikeProperty;
    private ObjectProperty<SpinnerStyle> _spinnerStyleProperty;
    private DecorationDelegate _operator;

    public FormattedTextField() {
        this(null);
    }

    public FormattedTextField(T value) {
        this.initializePattern();
        this.initializeTextField();
        this.initializeStyle();
        this.registerListeners();
        this.setValue(value);
    }

    protected void initializeStyle() {
        this.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_DEFAULT, "decoration-support"});
    }

    protected void initializeTextField() {
    }

    protected void initializePattern() {
        InvalidationListener verifierListener = new InvalidationListener(){

            public void invalidated(Observable observable) {
                if (FormattedTextField.this.getPattern() != null) {
                    FormattedTextField.this._fixedText = null;
                    FormattedTextField.this.updateText(FormattedTextField.this.getValue());
                }
            }
        };
        this.getPatternVerifiers().addListener(verifierListener);
    }

    public ObservableMap<String, Callback<String, Boolean>> getPatternVerifiers() {
        if (this._patternVerifiers == null) {
            this._patternVerifiers = FXCollections.observableHashMap();
        }
        return this._patternVerifiers;
    }

    protected void registerListeners() {
        this.addEventFilter(ScrollEvent.ANY, (EventHandler)new EventHandler<ScrollEvent>(){

            public void handle(ScrollEvent event) {
                if (!FormattedTextField.this.isFocused()) {
                    FormattedTextField.this.requestFocus();
                }
                MouseEvent e = new MouseEvent(event.getSource(), event.getTarget(), MouseEvent.MOUSE_CLICKED, event.getX(), event.getY(), event.getScreenX(), event.getScreenY(), MouseButton.PRIMARY, 1, false, false, false, false, true, false, false, true, false, true, null);
                HitInfo hitInfo = ((TextFieldSkin)FormattedTextField.this.getSkin()).getIndex(e);
                if (FormattedTextField.this.getCaretPosition() != hitInfo.getCharIndex()) {
                    ((TextFieldSkin)FormattedTextField.this.getSkin()).positionCaret(hitInfo, false);
                }
                int count = event.isShiftDown() ? 10 : 1;
                for (int i = 0; i < count; ++i) {
                    if (event.getDeltaY() > 0.0) {
                        FormattedTextField.this.increaseValue();
                        continue;
                    }
                    if (!(event.getDeltaY() < 0.0)) continue;
                    FormattedTextField.this.decreaseValue();
                }
            }
        });
        this.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.TAB && !event.isControlDown()) {
                    boolean forward;
                    boolean bl = forward = !event.isShiftDown();
                    if (forward && FormattedTextField.this.selectNextGroup()) {
                        event.consume();
                    }
                    if (!forward && FormattedTextField.this.selectPreviousGroup()) {
                        event.consume();
                    }
                } else if (event.getCode() == KeyCode.ENTER) {
                    if (FormattedTextField.this.commitEdit()) {
                        if (!(FormattedTextField.this.getParent() instanceof Cell)) {
                            event.consume();
                        }
                    } else if (FormattedTextField.this.cancelEdit()) {
                        event.consume();
                    }
                } else if (event.getCode() == KeyCode.ESCAPE && FormattedTextField.this.cancelEdit()) {
                    event.consume();
                }
                if (!event.isConsumed() && FormattedTextField.this.processKeyCode(event)) {
                    event.consume();
                }
            }
        });
        this.editableProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (FormattedTextField.this.isComboBoxLike()) {
                    if (newValue.booleanValue()) {
                        FormattedTextField.this.getStyleClass().remove((Object)FormattedTextField.this.comboBoxStyleClass);
                        FormattedTextField.this.getStyleClass().add((Object)FormattedTextField.this.textInputStyleClass);
                    } else {
                        FormattedTextField.this.getStyleClass().add((Object)FormattedTextField.this.comboBoxStyleClass);
                        FormattedTextField.this.getStyleClass().remove((Object)FormattedTextField.this.textInputStyleClass);
                    }
                }
                FormattedTextField.this.configPseudoClassState(newValue);
            }
        });
        this.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (FormattedTextField.this._decorationPane != null && FormattedTextField.this._decorationPane.getParent() != null && !FormattedTextField.this.isEditable()) {
                    if (newValue.booleanValue()) {
                        FormattedTextField.this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"focused"), false);
                        FormattedTextField.this._decorationPane.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"focused"), true);
                    } else {
                        FormattedTextField.this._decorationPane.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"focused"), false);
                    }
                }
                if (!newValue.booleanValue() && !FormattedTextField.this.commitEdit()) {
                    FormattedTextField.this.cancelEdit();
                }
            }
        });
        this.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                FormattedTextField.this.configDecorationPane();
            }
        });
        this.spinnerStyleProperty().addListener((ChangeListener)new ChangeListener<SpinnerStyle>(){

            public void changed(ObservableValue<? extends SpinnerStyle> observable, SpinnerStyle oldValue, SpinnerStyle newValue) {
                FormattedTextField.this.hideSpinners();
                FormattedTextField.this._increaseDecorator = null;
                FormattedTextField.this._decreaseDecorator = null;
                FormattedTextField.this.configDecorationPane();
                if (FormattedTextField.this.isSpinnersVisible()) {
                    FormattedTextField.this.showSpinners();
                    FormattedTextField.this.requestLayout();
                }
            }
        });
    }

    private void configPseudoClassState(Boolean newValue) {
        if (this._decorationPane != null) {
            this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"readonly"), newValue == false);
        } else if (newValue.booleanValue()) {
            this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"readonly"), false);
        }
    }

    private void configDecorationPane() {
        if (this._decorationPane != null) {
            this._decorationPane.getStyleClass().removeAll((Object[])new String[]{"combo-box-base"});
            this._decorationPane.getStyleClass().addAll((Object[])new String[]{"combo-box-base"});
            double increaseWidth = this._increaseSpinnerButton == null || this._increaseSpinnerButton.getPrefWidth() == 0.0 ? this.spinnerButtonSize : this._increaseSpinnerButton.getPrefWidth();
            double increaseHeight = this._increaseSpinnerButton == null || this._increaseSpinnerButton.getPrefHeight() == 0.0 ? this.spinnerButtonSize : this._increaseSpinnerButton.getPrefHeight();
            double decreaseWidth = this._decreaseSpinnerButton == null || this._decreaseSpinnerButton.getPrefWidth() == 0.0 ? this.spinnerButtonSize : this._decreaseSpinnerButton.getPrefWidth();
            double decreaseHeight = this._decreaseSpinnerButton == null || this._decreaseSpinnerButton.getPrefHeight() == 0.0 ? this.spinnerButtonSize : this._decreaseSpinnerButton.getPrefHeight();
            double maxWidth = Math.max(increaseWidth, decreaseWidth);
            double maxHeight = Math.max(increaseHeight, decreaseHeight);
            double groupedVerticalPadding = maxHeight > this.getHeight() ? maxHeight / 2.0 - this.getHeight() / 2.0 : 0.0;
            double verticalPadding = maxHeight * 2.0 - this.getHeight() <= 0.0 ? 0.0 : maxHeight - this.getHeight() / 2.0;
            switch (this.getSpinnerStyle()) {
                case OUTSIDE_LEFT_HORIZONTAL: {
                    this._decorationPane.setPadding(new Insets(groupedVerticalPadding, 0.0, groupedVerticalPadding, maxWidth * this.horizontalTotalWidthRatio));
                    break;
                }
                case OUTSIDE_LEFT_VERTICAL: {
                    this._decorationPane.setPadding(new Insets(verticalPadding, 0.0, verticalPadding, maxWidth * this.verticalTotalWidthRatio));
                    break;
                }
                case OUTSIDE_CENTER_HORIZONTAL: {
                    this._decorationPane.setPadding(new Insets(groupedVerticalPadding, maxWidth * this.verticalTotalWidthRatio, groupedVerticalPadding, maxWidth * this.verticalTotalWidthRatio));
                    break;
                }
                case OUTSIDE_CENTER_VERTICAL: {
                    this._decorationPane.setPadding(new Insets(maxHeight * 0.9, 0.0, maxHeight * 0.9, 0.0));
                    break;
                }
                case OUTSIDE_RIGHT_HORIZONTAL: {
                    this._decorationPane.setPadding(new Insets(groupedVerticalPadding, maxWidth * this.horizontalTotalWidthRatio, groupedVerticalPadding, 0.0));
                    break;
                }
                case OUTSIDE_RIGHT_VERTICAL: {
                    this._decorationPane.setPadding(new Insets(verticalPadding, maxWidth * this.verticalTotalWidthRatio, verticalPadding, 0.0));
                    break;
                }
                default: {
                    this._decorationPane.setPadding(new Insets(0.0));
                }
            }
        }
    }

    public void clear() {
        this.setValue(this.getDefaultValue());
    }

    private void setTextWithoutChecking(String text) {
        try {
            this.enforcing = false;
            this.setText(text);
        }
        finally {
            this.enforcing = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelEdit() {
        T value = this.getValue();
        if (value != null) {
            IndexRange range;
            String groupName;
            block6: {
                groupName = this.getCurrentGroupName();
                this.enforcing = false;
                try {
                    String oldText = this.getText();
                    String newText = this.toString(value);
                    if (!CommonUtils.equals((Object)oldText, (Object)newText)) {
                        this.setTextWithoutChecking(newText);
                        break block6;
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.enforcing = false;
                }
            }
            if (groupName != null && (range = this.getGroupRangeAt(groupName)) != null) {
                this.selectRange(range.getStart(), range.getEnd());
            }
            return true;
        }
        return false;
    }

    public boolean commitEdit() {
        if (!this.supportFromString()) {
            return true;
        }
        T value = this.fromString(this.getText());
        if (value == null) {
            return false;
        }
        this.setValue(value);
        return true;
    }

    protected String toString(T value) {
        StringConverter<T> objectConverter = this.getStringConverter();
        if (objectConverter != null) {
            return objectConverter.toString(value);
        }
        return null;
    }

    protected T fromString(String text) {
        StringConverter<T> objectConverter = this.getStringConverter();
        if (objectConverter != null) {
            try {
                return (T)objectConverter.fromString(text);
            }
            catch (Exception e) {
                CommonUtils.ignoreException((Exception)e);
            }
        }
        return null;
    }

    protected boolean supportFromString() {
        return this.getStringConverter() != null;
    }

    public void previousWord() {
        IndexRange range = this.previousRange(true);
        if (range != null) {
            if (this.getCaretPosition() <= range.getEnd()) {
                this.positionCaret(range.getStart());
            } else {
                this.positionCaret(range.getEnd());
            }
        }
    }

    public void nextWord() {
        IndexRange range = this.nextRange(true);
        if (range != null) {
            if (this.getCaretPosition() >= range.getStart()) {
                this.positionCaret(range.getEnd());
            } else {
                this.positionCaret(range.getStart());
            }
        }
    }

    public void endOfNextWord() {
        this.nextWord();
    }

    public void selectPreviousWord() {
        IndexRange range = this.previousRange(true);
        if (range != null) {
            if (this.getCaretPosition() <= range.getEnd()) {
                this.selectPositionCaret(range.getStart());
            } else {
                this.selectPositionCaret(range.getEnd());
            }
        }
    }

    public void selectNextWord() {
        IndexRange range = this.nextRange(true);
        if (range != null) {
            if (this.getCaretPosition() >= range.getStart()) {
                this.selectPositionCaret(range.getEnd());
            } else {
                this.selectPositionCaret(range.getStart());
            }
        }
    }

    public void selectEndOfNextWord() {
        this.selectNextWord();
    }

    private IndexRange nextRange(boolean checkEnd) {
        IndexRange range = this.getGroupRangeAt(this.getCaretPosition());
        if (range != null) {
            if (checkEnd && range.getEnd() != this.getCaretPosition()) {
                return range;
            }
            if (!checkEnd && range.getStart() != this.getCaretPosition()) {
                return range;
            }
            IndexRange nextRange = this.findNextRange(range.getEnd());
            return nextRange == null ? new IndexRange(range.getEnd(), range.getEnd()) : nextRange;
        }
        return null;
    }

    private IndexRange findNextRange(int rangeEnd) {
        for (int i = rangeEnd + 1; i < this.getText().length(); ++i) {
            IndexRange nextRange = this.getGroupRangeAt(i);
            if (nextRange == null || nextRange.getEnd() == rangeEnd) continue;
            return nextRange;
        }
        return null;
    }

    private IndexRange previousRange(boolean checkStart) {
        IndexRange range = this.getGroupRangeAt(this.getCaretPosition());
        if (range != null) {
            if (checkStart && range.getStart() != this.getCaretPosition()) {
                return range;
            }
            if (!checkStart && range.getEnd() != this.getCaretPosition()) {
                return range;
            }
            IndexRange previousRange = this.findPreviousRange(range.getStart());
            return previousRange == null ? new IndexRange(range.getStart(), range.getStart()) : previousRange;
        }
        return null;
    }

    private IndexRange findPreviousRange(int rangeStart) {
        for (int i = rangeStart - 1; i >= 0; --i) {
            IndexRange previousRange = this.getGroupRangeAt(i);
            if (previousRange == null || previousRange.getStart() == rangeStart) continue;
            return previousRange;
        }
        return null;
    }

    public boolean selectPreviousGroup() {
        this.commitWithoutSelectAll();
        int caretPosition = this.getCaretPosition();
        IndexRange range = this.getGroupRangeAt(caretPosition);
        if (caretPosition > 0) {
            for (int i = caretPosition - 1; i >= 0; --i) {
                IndexRange newRange = this.getGroupRangeAt(i);
                if (newRange == null || newRange.equals((Object)range)) continue;
                this.selectRange(newRange.getStart(), newRange.getEnd());
                return true;
            }
        }
        return false;
    }

    public boolean selectNextGroup() {
        this.commitWithoutSelectAll();
        int caretPosition = this.getCaretPosition();
        IndexRange range = this.getGroupRangeAt(caretPosition);
        if (caretPosition < this.getText().length()) {
            for (int i = caretPosition + 1; i <= this.getText().length(); ++i) {
                IndexRange newRange = this.getGroupRangeAt(i);
                if (newRange == null || newRange.equals((Object)range)) continue;
                this.selectRange(newRange.getStart(), newRange.getEnd());
                return true;
            }
        }
        return false;
    }

    private void commitWithoutSelectAll() {
        this._internalAutoSelectAll = false;
        try {
            if (!this.commitEdit()) {
                this.cancelEdit();
            }
        }
        finally {
            this._internalAutoSelectAll = true;
        }
    }

    public boolean selectCurrentGroup() {
        IndexRange range = this.getGroupRangeAt(this.getCaretPosition());
        if (range != null) {
            this.selectRange(range.getStart(), range.getEnd());
            return true;
        }
        return false;
    }

    public boolean processKeyCode(KeyEvent event) {
        String text;
        if (!event.getCode().isNavigationKey() || event.getCode() == KeyCode.LEFT || event.getCode() == KeyCode.RIGHT || !event.isShortcutDown() && (event.getCode() == KeyCode.HOME || event.getCode() == KeyCode.END)) {
            return false;
        }
        String name = this.getCurrentGroupName();
        if (name == null || name.trim().isEmpty()) {
            int caretPosition = this.getCaretPosition();
            int length = this.getText().length();
            for (int i = 0; i < length; ++i) {
                int caret = (i + caretPosition) % length;
                this.positionCaret(caret);
                name = this.getCurrentGroupName();
                if (name != null && !name.trim().isEmpty()) break;
            }
        }
        if ((text = this.getCurrentGroupText()) != null) {
            try {
                Callback verifier = (Callback)this.getPatternVerifiers().get((Object)name);
                if (verifier != null && verifier instanceof PatternVerifier.Adjustable && verifier instanceof PatternVerifier.Formatter && verifier instanceof PatternVerifier.Parser) {
                    if (verifier instanceof PatternVerifier.Value) {
                        ((PatternVerifier.Value)verifier).setFieldValue(this.fromString(this.getText()));
                    }
                    Object newValue = null;
                    Object value = ((PatternVerifier.Parser)verifier).parse(text);
                    switch (event.getCode()) {
                        case UP: {
                            newValue = ((PatternVerifier.Adjustable)verifier).getNextValue(value, !event.isShiftDown());
                            break;
                        }
                        case DOWN: {
                            newValue = ((PatternVerifier.Adjustable)verifier).getPreviousValue(value, !event.isShiftDown());
                            break;
                        }
                        case PAGE_UP: {
                            newValue = ((PatternVerifier.Adjustable)verifier).getNextPage(value, !event.isShiftDown());
                            break;
                        }
                        case PAGE_DOWN: {
                            newValue = ((PatternVerifier.Adjustable)verifier).getPreviousPage(value, !event.isShiftDown());
                            break;
                        }
                        case HOME: {
                            if (!event.isShortcutDown()) break;
                            newValue = ((PatternVerifier.Adjustable)verifier).getHome(value);
                            break;
                        }
                        case END: {
                            if (!event.isShortcutDown()) break;
                            newValue = ((PatternVerifier.Adjustable)verifier).getEnd(value);
                        }
                    }
                    if (verifier instanceof PatternVerifier.Value && newValue == null) {
                        Object newFieldValue = ((PatternVerifier.Value)verifier).getFieldValue();
                        String newWholeText = this.toString(newFieldValue);
                        if (newWholeText != null) {
                            this.setValue(newFieldValue);
                        }
                        IndexRange range = this.getGroupRangeAt(name);
                        this.selectRange(range.getStart(), range.getEnd());
                        return true;
                    }
                    if (newValue != null) {
                        String newText = ((PatternVerifier.Formatter)verifier).format(newValue);
                        int groupStart = this.getGroupStart(this.getCaretPosition());
                        if (((Boolean)verifier.call((Object)newText)).booleanValue()) {
                            super.replaceText(groupStart, groupStart + text.length(), newText);
                            this.commitWithoutSelectAll();
                            this.selectRange(groupStart, groupStart + newText.length());
                        }
                        return true;
                    }
                }
            }
            catch (NumberFormatException e) {
                CommonUtils.ignoreException((Exception)e);
            }
        }
        return false;
    }

    public void increaseValue() {
        if (this.getCurrentGroupName() == null || this.getCurrentGroupName().trim().isEmpty()) {
            for (int i = 0; i < this.getText().length(); ++i) {
                this.positionCaret(i);
                if (this.getCurrentGroupName() != null && !this.getCurrentGroupName().trim().isEmpty()) break;
            }
        }
        this.requestFocus();
        this.processKeyCode(new KeyEvent(KeyEvent.KEY_PRESSED, "", "", KeyCode.UP, true, false, false, false));
    }

    public void decreaseValue() {
        if (this.getCurrentGroupName() == null || this.getCurrentGroupName().trim().isEmpty()) {
            for (int i = 0; i < this.getText().length(); ++i) {
                this.positionCaret(i);
                if (this.getCurrentGroupName() != null && !this.getCurrentGroupName().trim().isEmpty()) break;
            }
        }
        this.requestFocus();
        this.processKeyCode(new KeyEvent(KeyEvent.KEY_PRESSED, "", "", KeyCode.DOWN, true, false, false, false));
    }

    private String getFixedText() {
        if (this._fixedText == null) {
            this._fixedText = this.getInitialTextFromMask();
        }
        return this._fixedText;
    }

    private String getInitialTextFromMask() {
        String pattern = this.getPattern();
        ObservableMap<String, Callback<String, Boolean>> verifiers = this.getPatternVerifiers();
        for (String s : verifiers.keySet()) {
            pattern = pattern.replace(s, "");
        }
        this._fixedText = pattern;
        return pattern;
    }

    public StringProperty patternProperty() {
        if (this._patternProperty == null) {
            this._patternProperty = new SimpleStringProperty(this, "pattern"){

                protected void invalidated() {
                    super.invalidated();
                    FormattedTextField.this._fixedText = null;
                    FormattedTextField.this.updateText(FormattedTextField.this.getValue());
                }
            };
        }
        return this._patternProperty;
    }

    public String getPattern() {
        return (String)this.patternProperty().get();
    }

    public void setPattern(String pattern) {
        this.patternProperty().set((Object)pattern);
    }

    public StringProperty regularExpressionProperty() {
        if (this._regularExpressionProperty == null) {
            this._regularExpressionProperty = new SimpleStringProperty();
        }
        return this._regularExpressionProperty;
    }

    public String getRegularExpression() {
        String regex = (String)this.regularExpressionProperty().get();
        if (regex == null && !this.verifyMatcher(regex = this.createRegexFromPattern(false), this.getPattern()) && !this.verifyMatcher(regex = this.createRegexFromPattern(true), this.getPattern())) {
            throw new IllegalStateException("You must call setRegularExpression method to set a regular expression for the pattern \"" + this.getPattern() + "\" as we couldn't figure out how to split it in to groups.");
        }
        return regex;
    }

    public void setRegularExpression(String regex) {
        this.regularExpressionProperty().set((Object)regex);
    }

    private boolean verifyMatcher(String regex, String sampleText) {
        Matcher matcher = Pattern.compile(regex).matcher(sampleText);
        if (matcher != null && matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String group = matcher.group(i);
                if (group != null && !group.trim().isEmpty()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ObjectProperty<StringConverter<T>> stringConverterProperty() {
        if (this._stringConverterProperty == null) {
            this._stringConverterProperty = new SimpleObjectProperty();
        }
        return this._stringConverterProperty;
    }

    public StringConverter<T> getStringConverter() {
        return (StringConverter)this.stringConverterProperty().get();
    }

    public void setStringConverter(StringConverter<T> stringConverter) {
        this.stringConverterProperty().set(stringConverter);
    }

    public ObjectProperty<T> valueProperty() {
        if (this._valueProperty == null) {
            this._valueProperty = new SimpleObjectProperty<T>(this, "value"){

                protected void invalidated() {
                    super.invalidated();
                    Object value = this.get();
                    if (value != null && !FormattedTextField.this.supportFromString()) {
                        throw new IllegalStateException("You must call setStringConverter before you can call setValue.");
                    }
                    FormattedTextField.this.updateText(value);
                }
            };
        }
        return this._valueProperty;
    }

    private void updateText(T value) {
        String text = this.toString(value);
        if (text != null) {
            if (!text.equals(this.getText())) {
                this.setTextWithoutChecking(text);
            }
            if (this.isAutoSelectAll() && this._internalAutoSelectAll) {
                this.selectAll();
            }
        } else {
            this.setTextWithoutChecking(this.getInitialTextFromMask());
            if (this.isAutoSelectAll() && this._internalAutoSelectAll) {
                this.selectAll();
            }
        }
    }

    @Override
    public T getValue() {
        return (T)this.valueProperty().get();
    }

    @Override
    public void setValue(T value) {
        this.valueProperty().set(value);
    }

    @Override
    public ObservableValue<T> observableValue() {
        return this.valueProperty();
    }

    public ObjectProperty<T> defaultValueProperty() {
        if (this._defaultValueProperty == null) {
            this._defaultValueProperty = new SimpleObjectProperty((Object)this, "defaultValue");
        }
        return this._defaultValueProperty;
    }

    public T getDefaultValue() {
        return (T)this.defaultValueProperty().get();
    }

    public void setDefaultValue(T value) {
        this.defaultValueProperty().set(value);
    }

    public BooleanProperty autoAdvanceProperty() {
        if (this._autoAdvanceProperty == null) {
            this._autoAdvanceProperty = new SimpleBooleanProperty(true);
        }
        return this._autoAdvanceProperty;
    }

    public boolean isAutoAdvance() {
        return this.autoAdvanceProperty().get();
    }

    public void setAutoAdvance(boolean autoAdvance) {
        this.autoAdvanceProperty().set(autoAdvance);
    }

    public BooleanProperty autoReformatProperty() {
        if (this._autoReformatProperty == null) {
            this._autoReformatProperty = new SimpleBooleanProperty(false);
        }
        return this._autoReformatProperty;
    }

    public boolean isAutoReformat() {
        return this.autoReformatProperty().get();
    }

    public void setAutoReformat(boolean autoReformat) {
        this.autoReformatProperty().set(autoReformat);
    }

    public BooleanProperty autoSelectAllProperty() {
        if (this._autoSelectAllProperty == null) {
            this._autoSelectAllProperty = new SimpleBooleanProperty((Object)this, "autoSelectAll", true);
        }
        return this._autoSelectAllProperty;
    }

    public boolean isAutoSelectAll() {
        return this.autoSelectAllProperty().get();
    }

    public void setAutoSelectAll(boolean autoSelectAll) {
        this.autoSelectAllProperty().set(autoSelectAll);
    }

    private String keepFixedText(String text) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            String s = text.substring(i, i + 1);
            if (!this.getFixedText().contains(s)) continue;
            buf.append(s);
        }
        return buf.toString();
    }

    protected Matcher getGroupMatcher(String newText) {
        String pattern = this.getPattern();
        if (pattern != null) {
            return Pattern.compile(this.getRegularExpression()).matcher(newText);
        }
        return null;
    }

    private String createRegexFromPattern(boolean considerMinMaxLength) {
        String pattern = this.getPattern();
        String regex = pattern.replace(".", "\\.").replace("(", "\\(").replace(")", "\\)").replace("[", "\\[").replace("]", "\\]").replace("+", "\\+").replace("$", "\\$").replace("#", "\\#").replace("^", "\\^").replace("&", "\\&").replace("-", "\\-").replace("*", "\\*");
        int maxLength = 0;
        for (String s : this.getPatternVerifiers().keySet()) {
            if (s.length() <= maxLength) continue;
            maxLength = s.length();
        }
        for (int i = maxLength; i >= 0; --i) {
            for (String s : this.getPatternVerifiers().keySet()) {
                if (s.length() != i) continue;
                Callback callback = (Callback)this.getPatternVerifiers().get((Object)s);
                if (callback instanceof PatternVerifier.Length && considerMinMaxLength) {
                    int min = ((PatternVerifier.Length)callback).getMinLength();
                    int max = ((PatternVerifier.Length)callback).getMaxLength();
                    regex = regex.replace(s, "(.{" + min + "," + max + "}+)");
                    continue;
                }
                regex = regex.replace(s, "(.*)");
            }
        }
        regex = "^" + regex + "$";
        return regex;
    }

    public String getGroupText(int groupIndex) {
        String newText = this.getText();
        Matcher matcher = this.getGroupMatcher(newText);
        if (matcher.find() && groupIndex >= 1 && groupIndex <= matcher.groupCount()) {
            return matcher.group(groupIndex);
        }
        return null;
    }

    public String getGroupText(String groupName) {
        String text = this.getText();
        Matcher matcher = this.getGroupMatcher(text);
        if (matcher != null && matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String name;
                Matcher m = this.getGroupMatcher(this.getPattern());
                if (!m.find() || !groupName.equals(name = m.group(i))) continue;
                return matcher.group(i);
            }
        }
        return null;
    }

    private String getGroupTextAfterward(char c, int index, boolean insert) {
        String text = this.getText();
        String newText = text.substring(0, index) + c + text.substring(insert ? index : index + 1);
        Matcher matcher = this.getGroupMatcher(newText);
        if (matcher != null && matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                if (index < matcher.start(i) || index > matcher.end(i)) continue;
                String group = matcher.group(i);
                return group;
            }
        }
        return "" + c;
    }

    private String getGroupTextAfterward2(char c, int index, boolean insert) {
        String text = this.getText();
        String newText = text.substring(0, index) + c + text.substring(insert ? index : index + 1);
        Matcher matcher = this.getGroupMatcher(newText);
        if (matcher != null && matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                if (index + 1 < matcher.start(i) || index + 1 > matcher.end(i)) continue;
                return matcher.group(i);
            }
        }
        return "" + c;
    }

    private int getGroupStart(int index) {
        String text = this.getText();
        Matcher matcher = this.getGroupMatcher(text);
        if (matcher != null && matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                if (index < matcher.start(i) || index > matcher.end(i)) continue;
                return matcher.start(i);
            }
        }
        return index;
    }

    private String getGroupNameAfterward(char c, int index, boolean insert) {
        String text = this.getText();
        String newText = insert ? text.substring(0, index) + c + text.substring(index) : text.substring(0, index) + c + text.substring(index + 1);
        return this.getGroupNameAt(index, newText);
    }

    private String getGroupNameAfterward2(char c, int index, boolean insert) {
        String text = this.getText();
        String newText = insert ? text.substring(0, index) + c + text.substring(index) : text.substring(0, index) + c + text.substring(index + 1);
        return this.getGroupNameAt(index + 1, newText);
    }

    private String getCurrentGroupName() {
        int index = this.getCaretPosition();
        String text = this.getText();
        return this.getGroupNameAt(index, text);
    }

    private String getGroupNameAt(int index, String text) {
        Matcher matcher = this.getGroupMatcher(text);
        if (matcher != null && matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                Matcher m;
                if (index < matcher.start(i) || index > matcher.end(i) || !(m = this.getGroupMatcher(this.getPattern())).find()) continue;
                return m.group(i);
            }
        }
        return "";
    }

    private String getCurrentGroupText() {
        int index = this.getCaretPosition();
        String text = this.getText();
        Matcher matcher = this.getGroupMatcher(text);
        if (matcher != null && matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                if (index < matcher.start(i) || index > matcher.end(i)) continue;
                return matcher.group(i);
            }
        }
        return null;
    }

    private int getCurrentGroupIndex() {
        int index = this.getCaretPosition();
        String text = this.getText();
        Matcher matcher = this.getGroupMatcher(text);
        if (matcher != null && matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                if (index < matcher.start(i) || index > matcher.end(i)) continue;
                return i;
            }
        }
        return 0;
    }

    private IndexRange getGroupRangeAt(int caretPosition) {
        String text = this.getText();
        Matcher matcher = this.getGroupMatcher(text);
        if (matcher != null && matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                if (caretPosition < matcher.start(i) || caretPosition > matcher.end(i)) continue;
                return new IndexRange(matcher.start(i), matcher.end(i));
            }
        }
        return null;
    }

    private IndexRange getGroupRange(int group) {
        String text = this.getText();
        Matcher matcher = this.getGroupMatcher(text);
        if (matcher.find() && group >= 0 && group <= matcher.groupCount()) {
            return new IndexRange(matcher.start(group), matcher.end(group));
        }
        return null;
    }

    private IndexRange getGroupRangeAt(String groupName) {
        String text = this.getText();
        Matcher matcher = this.getGroupMatcher(text);
        if (matcher != null && matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String name;
                Matcher m = this.getGroupMatcher(this.getPattern());
                if (!m.find() || !groupName.equals(name = m.group(i))) continue;
                return new IndexRange(matcher.start(i), matcher.end(i));
            }
        }
        return null;
    }

    private boolean verifyChar(char c, int index, boolean insert) {
        String groupName = this.getGroupNameAfterward(c, index, insert);
        if (this.getValue() == null && (groupName == null || groupName.trim().isEmpty())) {
            return true;
        }
        Callback verifier = (Callback)this.getPatternVerifiers().get((Object)groupName);
        if (verifier != null) {
            Callback secondVerifier;
            String secondGroupName;
            String textAfterward;
            Boolean result;
            T fieldValue = this.fromString(this.getText());
            if (fieldValue == null) {
                fieldValue = this.getValue();
            }
            if (verifier instanceof PatternVerifier.Value) {
                ((PatternVerifier.Value)verifier).setFieldValue(fieldValue);
            }
            if ((result = (Boolean)verifier.call((Object)(textAfterward = this.getGroupTextAfterward(c, index, insert)))).booleanValue() && !groupName.equals(secondGroupName = this.getGroupNameAfterward2(c, index, insert)) && (secondVerifier = (Callback)this.getPatternVerifiers().get((Object)secondGroupName)) != null) {
                if (secondVerifier instanceof PatternVerifier.Value) {
                    ((PatternVerifier.Value)secondVerifier).setFieldValue(fieldValue);
                }
                String textAfterward2 = this.getGroupTextAfterward2(c, index, insert);
                return (Boolean)secondVerifier.call((Object)textAfterward2);
            }
            return result;
        }
        return false;
    }

    public void replaceText(int start, int end, String text) {
        if (text.isEmpty()) {
            String existingText = this.getText();
            int newEnd = Math.max(0, Math.min(end, existingText.length()));
            String deletedText = existingText.substring(start, newEnd);
            String newText = this.keepFixedText(deletedText);
            super.replaceText(start, newEnd, newText);
            this.reformat();
        } else if (text.length() >= 1) {
            String existingText = this.getText();
            int newEnd = Math.max(0, Math.min(end, existingText.length()));
            String deletedText = existingText.substring(start, newEnd);
            String newText = this.keepFixedText(deletedText);
            super.replaceText(start, newEnd, newText);
            this.reformat();
            int index = 0;
            while (index < text.length()) {
                char c = text.charAt(index);
                if (start != -1 && !this.getFixedText().contains("" + c) && this.verifyChar(c, start, true)) {
                    super.replaceText(start, start, "" + c);
                    this.reformat();
                    ++index;
                    ++start;
                    continue;
                }
                if (start != -1 && start < this.getText().length() && !this.getFixedText().contains("" + this.getText().charAt(start)) && !this.getFixedText().contains("" + c) && this.verifyChar(c, start, false)) {
                    super.replaceText(start, start + 1, "" + c);
                    this.reformat();
                    ++index;
                    ++start;
                    continue;
                }
                if (start >= this.getText().length()) break;
                if (c == this.getText().charAt(start)) {
                    this.positionCaret(start + 1);
                    ++index;
                    continue;
                }
                if (!this.isAutoAdvance()) break;
                this.replaceText(start + 1, end + 1, text.substring(index));
                this.reformat();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reformat() {
        if (this.isAutoReformat()) {
            try {
                this._internalAutoSelectAll = false;
                int position = this.getCaretPosition();
                String text = this.getText();
                this.commitEdit();
                String newText = this.getText();
                int newPosition = position + (newText.length() - text.length());
                this.positionCaret(Math.min(newPosition, newText.length()));
            }
            finally {
                this._internalAutoSelectAll = true;
            }
        }
    }

    public void replaceSelection(String replacement) {
        IndexRange range = this.getSelection();
        if (this.getPattern() != null) {
            String newText = this.keepFixedText(this.getSelectedText());
            super.replaceText(range.getStart(), range.getEnd(), newText);
            this.positionCaret(range.getStart());
            for (int i = 0; i < replacement.length(); ++i) {
                int start = this.getCaretPosition();
                this.replaceText(start, start, "" + replacement.charAt(i));
            }
        } else {
            super.replaceSelection(replacement);
        }
    }

    private void showSpinners() {
        Button button;
        if (this._increaseDecorator == null) {
            this._increaseDecorator = this.createIncreaseSpinnerDecorator();
            button = (Button)this._increaseDecorator.getNode();
            this.enableAutoRepeat(button);
            button.disableProperty().bind((ObservableValue)this.disabledProperty());
            button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    if (!FormattedTextField.this.isDisabled()) {
                        FormattedTextField.this.increaseValue();
                    }
                }
            });
        }
        DecorationUtils.install((Node)this, this._increaseDecorator);
        if (this._decreaseDecorator == null) {
            this._decreaseDecorator = this.createDecreaseSpinnerDecorator();
            button = (Button)this._decreaseDecorator.getNode();
            this.enableAutoRepeat(button);
            button.disableProperty().bind((ObservableValue)this.disabledProperty());
            button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    if (!FormattedTextField.this.isDisabled()) {
                        FormattedTextField.this.decreaseValue();
                    }
                }
            });
        }
        DecorationUtils.install((Node)this, this._decreaseDecorator);
    }

    protected void enableAutoRepeat(Button button) {
        AutoRepeatButtonUtils.install((ButtonBase)button);
    }

    protected Decorator<Button> createIncreaseSpinnerDecorator() {
        Decorator<Button> increaseSpinnerDecorator = new PredefinedDecorators.AbstractButtonDecoratorSupplier(){

            public Decorator<Button> get() {
                FormattedTextField.this._increaseSpinnerButton = FormattedTextField.this.createIncreaseSpinnerButton();
                switch (FormattedTextField.this.getSpinnerStyle()) {
                    case OUTSIDE_LEFT_HORIZONTAL: {
                        return new Decorator((Node)FormattedTextField.this._increaseSpinnerButton, Pos.CENTER_LEFT, new Point2D(-FormattedTextField.this.spinnerOffsetX, 0.0));
                    }
                    case OUTSIDE_CENTER_HORIZONTAL: {
                        return new Decorator((Node)FormattedTextField.this._increaseSpinnerButton, Pos.CENTER_RIGHT, new Point2D(FormattedTextField.this.spinnerOffsetX, 0.0));
                    }
                    case OUTSIDE_RIGHT_HORIZONTAL: {
                        return new Decorator((Node)FormattedTextField.this._increaseSpinnerButton, Pos.CENTER_RIGHT, new Point2D(FormattedTextField.this.spinnerOffsetX + 100.0, 0.0));
                    }
                    case OUTSIDE_LEFT_VERTICAL: {
                        return new Decorator((Node)FormattedTextField.this._increaseSpinnerButton, Pos.CENTER_LEFT, new Point2D(-FormattedTextField.this.spinnerOffsetX, -FormattedTextField.this.spinnerOffsetY));
                    }
                    case OUTSIDE_CENTER_VERTICAL: {
                        return new Decorator((Node)FormattedTextField.this._increaseSpinnerButton, Pos.TOP_CENTER, new Point2D(0.0, -FormattedTextField.this.spinnerOffsetY));
                    }
                    case OUTSIDE_RIGHT_VERTICAL: {
                        return new Decorator((Node)FormattedTextField.this._increaseSpinnerButton, Pos.CENTER_RIGHT, new Point2D(FormattedTextField.this.spinnerOffsetX, -FormattedTextField.this.spinnerOffsetY));
                    }
                    case INSIDE_LEFT_HORIZONTAL: {
                        return new Decorator((Node)FormattedTextField.this._increaseSpinnerButton, Pos.CENTER_LEFT, new Point2D(FormattedTextField.this.spinnerOffsetX + 100.0, 0.0), new Insets(0.0, 0.0, 0.0, FormattedTextField.this.spinnerPadding));
                    }
                    case INSIDE_CENTER_HORIZONTAL: {
                        return new Decorator((Node)FormattedTextField.this._increaseSpinnerButton, Pos.CENTER_RIGHT, new Point2D(-FormattedTextField.this.spinnerOffsetX, 0.0), new Insets(0.0, FormattedTextField.this.spinnerPadding, 0.0, 0.0));
                    }
                    case INSIDE_RIGHT_HORIZONTAL: {
                        return new Decorator((Node)FormattedTextField.this._increaseSpinnerButton, Pos.CENTER_RIGHT, new Point2D(-FormattedTextField.this.spinnerOffsetX, 0.0), new Insets(0.0, FormattedTextField.this.spinnerPadding, 0.0, 0.0));
                    }
                    case INSIDE_LEFT_VERTICAL: {
                        return new Decorator((Node)FormattedTextField.this._increaseSpinnerButton, Pos.CENTER_LEFT, new Point2D(FormattedTextField.this.spinnerOffsetX, -FormattedTextField.this.spinnerOffsetY), new Insets(0.0, 0.0, 0.0, FormattedTextField.this.spinnerPadding / 2.0));
                    }
                }
                return new Decorator((Node)FormattedTextField.this._increaseSpinnerButton, Pos.CENTER_RIGHT, new Point2D(-FormattedTextField.this.spinnerOffsetX, -FormattedTextField.this.spinnerOffsetY), new Insets(0.0, FormattedTextField.this.spinnerPadding / 2.0, 0.0, 0.0));
            }
        }.get();
        return increaseSpinnerDecorator;
    }

    protected Button createIncreaseSpinnerButton() {
        Shape arrowIcon = PredefinedShapes.getInstance().createArrowIcon(this.spinnerArrowIconSize);
        Button button = new Button();
        button.setId(STYLE_CLASS_INCREASE_BUTTON_);
        button.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_NO_BACKGROUND_BUTTON});
        button.setPrefWidth(this.spinnerButtonSize);
        button.setPrefHeight(this.spinnerButtonSize);
        button.setFocusTraversable(false);
        button.setPickOnBounds(true);
        button.setCursor(Cursor.DEFAULT);
        arrowIcon.setFocusTraversable(false);
        button.setGraphic((Node)arrowIcon);
        double arrowRotate = 0.0;
        switch (this.getSpinnerStyle()) {
            case OUTSIDE_LEFT_VERTICAL: 
            case OUTSIDE_CENTER_VERTICAL: 
            case OUTSIDE_RIGHT_VERTICAL: 
            case INSIDE_LEFT_VERTICAL: 
            case INSIDE_RIGHT_VERTICAL: {
                arrowRotate = 180.0;
                break;
            }
            case OUTSIDE_LEFT_HORIZONTAL: 
            case OUTSIDE_CENTER_HORIZONTAL: 
            case OUTSIDE_RIGHT_HORIZONTAL: 
            case INSIDE_LEFT_HORIZONTAL: 
            case INSIDE_CENTER_HORIZONTAL: 
            case INSIDE_RIGHT_HORIZONTAL: {
                arrowRotate = -90.0;
            }
        }
        button.getGraphic().setRotate(arrowRotate);
        return button;
    }

    protected Decorator<Button> createDecreaseSpinnerDecorator() {
        return new PredefinedDecorators.AbstractButtonDecoratorSupplier(){

            public Decorator<Button> get() {
                FormattedTextField.this._decreaseSpinnerButton = FormattedTextField.this.createDecreaseSpinnerButton();
                switch (FormattedTextField.this.getSpinnerStyle()) {
                    case OUTSIDE_LEFT_HORIZONTAL: {
                        return new Decorator((Node)FormattedTextField.this._decreaseSpinnerButton, Pos.CENTER_LEFT, new Point2D(-FormattedTextField.this.spinnerOffsetX - 100.0, 0.0));
                    }
                    case OUTSIDE_CENTER_HORIZONTAL: {
                        return new Decorator((Node)FormattedTextField.this._decreaseSpinnerButton, Pos.CENTER_LEFT, new Point2D(-FormattedTextField.this.spinnerOffsetX, 0.0));
                    }
                    case OUTSIDE_RIGHT_HORIZONTAL: {
                        return new Decorator((Node)FormattedTextField.this._decreaseSpinnerButton, Pos.CENTER_RIGHT, new Point2D(FormattedTextField.this.spinnerOffsetX, 0.0));
                    }
                    case OUTSIDE_LEFT_VERTICAL: {
                        return new Decorator((Node)FormattedTextField.this._decreaseSpinnerButton, Pos.CENTER_LEFT, new Point2D(-FormattedTextField.this.spinnerOffsetX, FormattedTextField.this.spinnerOffsetY));
                    }
                    case OUTSIDE_CENTER_VERTICAL: {
                        return new Decorator((Node)FormattedTextField.this._decreaseSpinnerButton, Pos.BOTTOM_CENTER, new Point2D(0.0, FormattedTextField.this.spinnerOffsetY));
                    }
                    case OUTSIDE_RIGHT_VERTICAL: {
                        return new Decorator((Node)FormattedTextField.this._decreaseSpinnerButton, Pos.CENTER_RIGHT, new Point2D(FormattedTextField.this.spinnerOffsetX, FormattedTextField.this.spinnerOffsetY));
                    }
                    case INSIDE_LEFT_HORIZONTAL: {
                        return new Decorator((Node)FormattedTextField.this._decreaseSpinnerButton, Pos.CENTER_LEFT, new Point2D(FormattedTextField.this.spinnerOffsetX, 0.0), new Insets(0.0, 0.0, 0.0, FormattedTextField.this.spinnerPadding));
                    }
                    case INSIDE_CENTER_HORIZONTAL: {
                        return new Decorator((Node)FormattedTextField.this._decreaseSpinnerButton, Pos.CENTER_LEFT, new Point2D(FormattedTextField.this.spinnerOffsetX, 0.0), new Insets(0.0, 0.0, 0.0, FormattedTextField.this.spinnerPadding));
                    }
                    case INSIDE_RIGHT_HORIZONTAL: {
                        return new Decorator((Node)FormattedTextField.this._decreaseSpinnerButton, Pos.CENTER_RIGHT, new Point2D(-FormattedTextField.this.spinnerOffsetX - 100.0, 0.0), new Insets(0.0, FormattedTextField.this.spinnerPadding, 0.0, 0.0));
                    }
                    case INSIDE_LEFT_VERTICAL: {
                        return new Decorator((Node)FormattedTextField.this._decreaseSpinnerButton, Pos.CENTER_LEFT, new Point2D(FormattedTextField.this.spinnerOffsetX, FormattedTextField.this.spinnerOffsetY), new Insets(0.0, 0.0, 0.0, FormattedTextField.this.spinnerPadding / 2.0));
                    }
                }
                return new Decorator((Node)FormattedTextField.this._decreaseSpinnerButton, Pos.CENTER_RIGHT, new Point2D(-FormattedTextField.this.spinnerOffsetX, FormattedTextField.this.spinnerOffsetY), new Insets(0.0, FormattedTextField.this.spinnerPadding / 2.0, 0.0, 0.0));
            }
        }.get();
    }

    protected Button createDecreaseSpinnerButton() {
        Shape arrowIcon = PredefinedShapes.getInstance().createArrowIcon(this.spinnerArrowIconSize);
        Button button = new Button();
        button.setId(STYLE_CLASS_DECREASE_BUTTON);
        button.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_NO_BACKGROUND_BUTTON});
        button.setPrefWidth(this.spinnerButtonSize);
        button.setPrefHeight(this.spinnerButtonSize);
        button.setFocusTraversable(false);
        button.setPickOnBounds(true);
        button.setCursor(Cursor.DEFAULT);
        arrowIcon.setFocusTraversable(false);
        button.setGraphic((Node)arrowIcon);
        double arrowRotate = 0.0;
        switch (this.getSpinnerStyle()) {
            case OUTSIDE_LEFT_HORIZONTAL: 
            case OUTSIDE_CENTER_HORIZONTAL: 
            case OUTSIDE_RIGHT_HORIZONTAL: 
            case INSIDE_LEFT_HORIZONTAL: 
            case INSIDE_CENTER_HORIZONTAL: 
            case INSIDE_RIGHT_HORIZONTAL: {
                arrowRotate = 90.0;
            }
        }
        button.getGraphic().setRotate(arrowRotate);
        return button;
    }

    private void hideSpinners() {
        if (this._increaseDecorator != null) {
            DecorationUtils.uninstall((Node)this, this._increaseDecorator);
        }
        if (this._decreaseDecorator != null) {
            DecorationUtils.uninstall((Node)this, this._decreaseDecorator);
        }
    }

    private void showClearButton() {
        if (this._clearButtonDecorator == null) {
            this._clearButtonDecorator = (Decorator)PredefinedDecorators.getInstance().getClearButtonDecoratorSupplier().get();
            ((Button)this._clearButtonDecorator.getNode()).disableProperty().bind((ObservableValue)this.disabledProperty());
            ((Button)this._clearButtonDecorator.getNode()).setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    if (!FormattedTextField.this.isDisabled()) {
                        FormattedTextField.this.clear();
                    }
                }
            });
        }
        DecorationUtils.install((Node)this, this._clearButtonDecorator);
    }

    private void hideClearButton() {
        if (this._clearButtonDecorator != null) {
            DecorationUtils.uninstall((Node)this, this._clearButtonDecorator);
        }
    }

    public BooleanProperty spinnersVisibleProperty() {
        if (this._spinnersVisibleProperty == null) {
            this._spinnersVisibleProperty = new SimpleBooleanProperty(this, "spinnersVisible"){

                protected void invalidated() {
                    super.invalidated();
                    boolean visible = this.get();
                    if (visible) {
                        FormattedTextField.this.showSpinners();
                    } else {
                        FormattedTextField.this.hideSpinners();
                    }
                }
            };
        }
        return this._spinnersVisibleProperty;
    }

    public boolean isSpinnersVisible() {
        return this.spinnersVisibleProperty().get();
    }

    public void setSpinnersVisible(boolean spinnersVisible) {
        this.spinnersVisibleProperty().set(spinnersVisible);
    }

    public BooleanProperty clearButtonVisibleProperty() {
        if (this._clearbuttonVisibleProperty == null) {
            this._clearbuttonVisibleProperty = new SimpleBooleanProperty(this, "clearButtonVisible"){

                protected void invalidated() {
                    super.invalidated();
                    boolean visible = this.get();
                    if (visible) {
                        FormattedTextField.this.showClearButton();
                    } else {
                        FormattedTextField.this.hideClearButton();
                    }
                }
            };
        }
        return this._clearbuttonVisibleProperty;
    }

    public boolean isClearButtonVisible() {
        return this.clearButtonVisibleProperty().get();
    }

    public void setClearButtonVisible(boolean clearButtonVisible) {
        this.clearButtonVisibleProperty().set(clearButtonVisible);
    }

    public BooleanProperty comboBoxLikeProperty() {
        if (this._comboBoxLikeProperty == null) {
            this._comboBoxLikeProperty = new SimpleBooleanProperty(this, "comboBoxLike", true){

                protected void invalidated() {
                    super.invalidated();
                    FormattedTextField.this.getStyleClass().remove((Object)FormattedTextField.this.comboBoxStyleClass);
                    FormattedTextField.this.getStyleClass().add((Object)FormattedTextField.this.textInputStyleClass);
                }
            };
        }
        return this._comboBoxLikeProperty;
    }

    public boolean isComboBoxLike() {
        return this.comboBoxLikeProperty().get();
    }

    public void setComboBoxLike(Boolean comboBoxLie) {
        this.comboBoxLikeProperty().set(comboBoxLie.booleanValue());
    }

    public void installAdjustmentMouseHandler(Node node) {
        this.installAdjustmentMouseHandler(node, 1);
    }

    public void installAdjustmentMouseHandler(Node node, int units) {
        this.installAdjustmentMouseHandler(node, units, 1.0);
    }

    public void installAdjustmentMouseHandler(final Node node, final int units, final double threshold) {
        this.uninstallAdjustmentMouseHandler(node);
        EventHandler<MouseEvent> eventHandler = new EventHandler<MouseEvent>(){
            double x = Double.NEGATIVE_INFINITY;

            public void handle(MouseEvent event) {
                if (!FormattedTextField.this.isDisabled()) {
                    if (event.getEventType().equals(MouseEvent.MOUSE_ENTERED)) {
                        node.setCursor(Cursor.H_RESIZE);
                    } else if (event.getEventType().equals(MouseEvent.MOUSE_PRESSED)) {
                        if (!FormattedTextField.this.isFocused()) {
                            FormattedTextField.this.requestFocus();
                            FormattedTextField.this.selectCurrentGroup();
                        }
                    } else if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED) && event.isStillSincePress()) {
                        if (event.getClickCount() >= 2) {
                            if (event.isShiftDown()) {
                                if (!FormattedTextField.this.selectPreviousGroup()) {
                                    FormattedTextField.this.positionCaret(FormattedTextField.this.getText().length());
                                    FormattedTextField.this.selectCurrentGroup();
                                }
                            } else if (!FormattedTextField.this.selectNextGroup()) {
                                FormattedTextField.this.positionCaret(0);
                                FormattedTextField.this.selectCurrentGroup();
                            }
                        }
                    } else if (event.getEventType().equals(MouseEvent.MOUSE_DRAGGED)) {
                        if (this.x == Double.NEGATIVE_INFINITY) {
                            this.x = event.getSceneX() - 1.0;
                        }
                        double value = event.getSceneX() - this.x;
                        int s = Math.max(1, units);
                        double t = threshold;
                        if (event.isAltDown()) {
                            t *= 10.0;
                        } else if (event.isShiftDown()) {
                            s *= 10;
                        }
                        if (Math.abs(value) > t) {
                            for (int i = 0; i < s; ++i) {
                                if (value > 0.0) {
                                    FormattedTextField.this.increaseValue();
                                    continue;
                                }
                                FormattedTextField.this.decreaseValue();
                            }
                            this.x = event.getSceneX();
                        }
                    } else if (event.getEventType().equals(MouseEvent.MOUSE_RELEASED)) {
                        this.x = Double.NEGATIVE_INFINITY;
                    } else if (event.getEventType().equals(MouseEvent.MOUSE_EXITED) && this.x == Double.NEGATIVE_INFINITY) {
                        node.setCursor(Cursor.DEFAULT);
                    }
                }
            }
        };
        node.getProperties().put((Object)PROPERTY_FORMATTED_TEXT_FIELD_ADJUSTMENT_MOUSE_HANDLER, (Object)eventHandler);
        node.addEventHandler(MouseEvent.ANY, (EventHandler)eventHandler);
    }

    public void uninstallAdjustmentMouseHandler(Node node) {
        Object eventHandler = node.getProperties().get((Object)PROPERTY_FORMATTED_TEXT_FIELD_ADJUSTMENT_MOUSE_HANDLER);
        if (eventHandler instanceof EventHandler) {
            node.removeEventHandler(MouseEvent.ANY, (EventHandler)eventHandler);
            node.getProperties().remove((Object)PROPERTY_FORMATTED_TEXT_FIELD_ADJUSTMENT_MOUSE_HANDLER);
        }
    }

    public Node asSpinner() {
        return this.asSpinner(SpinnerStyle.INSIDE_RIGHT_VERTICAL);
    }

    public Node asSpinner(SpinnerStyle style) {
        if (style != null) {
            this.setSpinnerStyle(style);
        }
        this.setSpinnersVisible(true);
        boolean isEditable = this.isEditable();
        if (this._decorationPane == null) {
            this._decorationPane = new DecorationPane((Parent)this);
            this.configDecorationPane();
        }
        this.setEditable(!isEditable);
        this.setEditable(isEditable);
        return this._decorationPane;
    }

    public static FormattedTextField<String> createIPv4Field() {
        FormattedTextField<String> field = new FormattedTextField<String>();
        field.getPatternVerifiers().put((Object)"h", (Object)new IntegerRangePatternVerifier(0, 255));
        field.setPattern("h.h.h.h");
        return field;
    }

    public ObjectProperty<SpinnerStyle> spinnerStyleProperty() {
        if (this._spinnerStyleProperty == null) {
            this._spinnerStyleProperty = new SimpleObjectProperty((Object)SpinnerStyle.INSIDE_RIGHT_VERTICAL);
        }
        return this._spinnerStyleProperty;
    }

    public SpinnerStyle getSpinnerStyle() {
        return (SpinnerStyle)((Object)this.spinnerStyleProperty().get());
    }

    public void setSpinnerStyle(SpinnerStyle spinnerStyle) {
        this.spinnerStyleProperty().set((Object)spinnerStyle);
    }

    protected void layoutChildren() {
        this.prepareDecorations();
        super.layoutChildren();
        Platform.runLater(this::layoutDecorations);
    }

    public void prepareDecorations() {
        if (this._operator == null) {
            this._operator = new DecorationDelegate((Region)this);
        }
        this._operator.prepareDecorations();
    }

    public void layoutDecorations() {
        this._operator.layoutDecorations();
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void positionInArea(Node child, double areaX, double areaY, double areaWidth, double areaHeight, double areaBaselineOffset, HPos halignment, VPos valignment) {
        super.positionInArea(child, areaX, areaY, areaWidth, areaHeight, areaBaselineOffset, halignment, valignment);
    }

    static enum Mode {
        Insert,
        Replace,
        ReplaceGroup;

    }
}

