/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Dimension2D;
import javafx.util.Callback;
import jidefx.scene.control.field.DoubleField;
import jidefx.scene.control.field.FormattedTextField;
import jidefx.scene.control.field.PopupField;
import jidefx.scene.control.field.popup.PopupContent;
import jidefx.scene.control.field.popup.ValuesPopupContent;
import jidefx.scene.control.field.verifier.NumberValuePatternVerifier;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.javafx.Dimension2DConverter;

public class Dimension2DField
extends PopupField<Dimension2D> {
    private static final String STYLE_CLASS_DEFAULT = "dimension-2d-field";

    @Override
    protected void initializeStyle() {
        super.initializeStyle();
        this.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_DEFAULT});
    }

    @Override
    protected void initializePattern() {
        super.initializePattern();
        this.setStringConverter(new Dimension2DConverter(){

            protected String toString(int i, Double o, ConverterContext context) {
                if (o == null) {
                    return "";
                }
                return o.toString();
            }

            protected Double fromString(int i, String s, ConverterContext context) {
                if (s == null || s.trim().isEmpty()) {
                    return null;
                }
                return Double.valueOf(s);
            }
        }.toStringConverter());
        this.getPatternVerifiers().put((Object)"Width", (Object)new NumberValuePatternVerifier<Dimension2D>((Number)0, (Number)Double.MAX_VALUE){

            @Override
            public Double toTargetValue(Dimension2D fieldValue) {
                return fieldValue.getWidth();
            }

            @Override
            public Dimension2D fromTargetValue(Dimension2D previousFieldValue, Number value) {
                double x = value.doubleValue();
                return previousFieldValue != null ? new Dimension2D(x, previousFieldValue.getHeight()) : new Dimension2D(x, 0.0);
            }
        });
        this.getPatternVerifiers().put((Object)"Height", (Object)new NumberValuePatternVerifier<Dimension2D>((Number)0, (Number)Double.MAX_VALUE){

            @Override
            public Double toTargetValue(Dimension2D fieldValue) {
                return fieldValue.getHeight();
            }

            @Override
            public Dimension2D fromTargetValue(Dimension2D previousFieldValue, Number value) {
                double y = value.doubleValue();
                return previousFieldValue != null ? new Dimension2D(previousFieldValue.getWidth(), y) : new Dimension2D(0.0, y);
            }
        });
        this.setPattern("Width; Height");
    }

    @Override
    protected void initializeTextField() {
        super.initializeTextField();
        this.setPopupContentFactory(new Callback<Dimension2D, PopupContent<Dimension2D>>(){

            public PopupContent<Dimension2D> call(Dimension2D param) {
                ValuesPopupContent<Dimension2D, Double> popupContent = new ValuesPopupContent<Dimension2D, Double>(new String[]{Dimension2DField.this.getResourceString("width"), Dimension2DField.this.getResourceString("height")}){

                    @Override
                    public List<Double> toValues(Dimension2D value) {
                        ArrayList<Double> list = new ArrayList<Double>(2);
                        list.add(value.getWidth());
                        list.add(value.getHeight());
                        return list;
                    }

                    @Override
                    public Dimension2D fromValues(List<Double> values) {
                        return new Dimension2D(values.get(0).doubleValue(), values.get(1).doubleValue());
                    }

                    @Override
                    public FormattedTextField<Double> createTextField(String label) {
                        return new DoubleField(0.0, Double.MAX_VALUE);
                    }
                };
                popupContent.setValue((Dimension2D)Dimension2DField.this.getValue());
                return popupContent;
            }
        });
    }
}

