/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.shape.Shape;
import javafx.util.Callback;
import jidefx.scene.control.decoration.Decorator;
import jidefx.scene.control.decoration.PredefinedDecorators;
import jidefx.scene.control.field.PopupField;
import jidefx.scene.control.field.popup.DatePopupContent;
import jidefx.scene.control.field.popup.PopupContent;
import jidefx.scene.control.field.verifier.PatternVerifierUtils;
import jidefx.utils.CommonUtils;
import jidefx.utils.PredefinedShapes;

public class DateField
extends PopupField<Date> {
    private static final String STYLE_CLASS_DEFAULT = "date-field";
    private ObjectProperty<DateFormat> _dateFormatProperty;

    public DateField() {
        this(SimpleDateFormat.getDateInstance());
    }

    public DateField(Date value) {
        this(SimpleDateFormat.getDateInstance(), value);
    }

    public DateField(String pattern) {
        this(new SimpleDateFormat(pattern));
    }

    public DateField(DateFormat format) {
        this(format, Calendar.getInstance().getTime());
    }

    public DateField(String pattern, Date value) {
        this(new SimpleDateFormat(pattern), value);
    }

    public DateField(DateFormat format, Date value) {
        this.setDateFormat(format);
        this.setValue(value);
    }

    @Override
    protected void initializeStyle() {
        super.initializeStyle();
        this.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_DEFAULT});
    }

    @Override
    protected void initializeTextField() {
        super.initializeTextField();
        this.setPopupContentFactory(new Callback<Date, PopupContent<Date>>(){

            public PopupContent<Date> call(Date param) {
                DatePopupContent content = new DatePopupContent();
                content.setValue(DateField.this.getValue());
                return content;
            }
        });
    }

    @Override
    protected void customizePopupContent(PopupContent<Date> popupContent) {
        super.customizePopupContent(popupContent);
        popupContent.valueProperty().addListener((ChangeListener)new ChangeListener<Date>(){

            public void changed(ObservableValue<? extends Date> observable, Date oldValue, Date newValue) {
                DateField.this.hide();
            }
        });
    }

    @Override
    protected String toString(Date value) {
        DateFormat format = this.getDateFormat();
        if (format != null) {
            try {
                return format.format(value);
            }
            catch (Exception e) {
                CommonUtils.ignoreException((Exception)e);
            }
        }
        return super.toString(value);
    }

    @Override
    protected Date fromString(String text) {
        DateFormat format = this.getDateFormat();
        if (format != null) {
            try {
                return format.parse(text);
            }
            catch (ParseException e) {
                CommonUtils.ignoreException((Exception)e);
            }
        }
        return (Date)super.fromString(text);
    }

    @Override
    protected boolean supportFromString() {
        return this.getDateFormat() != null || super.supportFromString();
    }

    public ObjectProperty<DateFormat> dateFormatProperty() {
        if (this._dateFormatProperty == null) {
            this._dateFormatProperty = new SimpleObjectProperty<DateFormat>((Object)this, "dateFormat"){

                protected void invalidated() {
                    super.invalidated();
                    DateFormat format = (DateFormat)this.get();
                    PatternVerifierUtils.initializePatternVerifiersForDateFormatUsingDate(DateField.this.getPatternVerifiers());
                    if (format instanceof SimpleDateFormat && DateField.this.getPattern() == null) {
                        DateField.this.setPattern(((SimpleDateFormat)format).toPattern());
                    }
                    DateField.this.setStringConverter(null);
                }
            };
        }
        return this._dateFormatProperty;
    }

    public DateFormat getDateFormat() {
        return (DateFormat)this.dateFormatProperty().get();
    }

    public void setDateFormat(DateFormat format) {
        this.dateFormatProperty().set((Object)format);
    }

    @Override
    protected Decorator<Button> createPopupButtonDecorator() {
        return new PredefinedDecorators.AbstractButtonDecoratorSupplier(){

            public Decorator<Button> get() {
                Shape calendarIcon = PredefinedShapes.getInstance().createCalendarIcon(15.0);
                Shape shape = PredefinedShapes.getInstance().createArrowedIcon(calendarIcon);
                return new Decorator((Node)this.createButton((Node)shape), Pos.CENTER_RIGHT, new Point2D(-70.0, 0.0));
            }
        }.get();
    }

    public static DateField createDateField(String dateFormat) {
        return DateField.createDateField(dateFormat, Calendar.getInstance().getTime());
    }

    public static DateField createDateField(String dateFormat, Date initialValue) {
        return new DateField(dateFormat, initialValue);
    }

    public static DateField createDateField(DateFormat dateFormat, Date initialValue) {
        return new DateField(dateFormat, initialValue);
    }

    public static DateField createTimeField() {
        return DateField.createDateField(SimpleDateFormat.getTimeInstance(), Calendar.getInstance().getTime());
    }

    public static DateField createTimeField(int dateFormatStyle) {
        return DateField.createDateField(SimpleDateFormat.getTimeInstance(dateFormatStyle), Calendar.getInstance().getTime());
    }

    public static DateField createDateField() {
        return DateField.createDateField(SimpleDateFormat.getDateInstance(), Calendar.getInstance().getTime());
    }

    public static DateField createDateField(int dateFormatStyle) {
        return DateField.createDateField(SimpleDateFormat.getDateInstance(dateFormatStyle), Calendar.getInstance().getTime());
    }

    public static DateField createDateTimeField() {
        return DateField.createDateField(SimpleDateFormat.getDateTimeInstance(), Calendar.getInstance().getTime());
    }

    public static DateField createDateTimeField(int dateFormatStyle, int timeFormatStyle) {
        return DateField.createDateField(SimpleDateFormat.getDateTimeInstance(dateFormatStyle, timeFormatStyle), Calendar.getInstance().getTime());
    }
}

