/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.shape.Shape;
import javafx.util.Callback;
import jidefx.scene.control.decoration.Decorator;
import jidefx.scene.control.decoration.PredefinedDecorators;
import jidefx.scene.control.field.PopupField;
import jidefx.scene.control.field.popup.CalendarPopupContent;
import jidefx.scene.control.field.popup.PopupContent;
import jidefx.scene.control.field.verifier.PatternVerifierUtils;
import jidefx.utils.CommonUtils;
import jidefx.utils.PredefinedShapes;

public class CalendarField
extends PopupField<Calendar> {
    private static final String STYLE_CLASS_DEFAULT = "calendar-field";
    private ObjectProperty<DateFormat> _dateFormatProperty;

    public CalendarField() {
        this(SimpleDateFormat.getDateInstance());
    }

    public CalendarField(String pattern) {
        if (pattern != null) {
            this.setDateFormat(new SimpleDateFormat(pattern));
        }
    }

    public CalendarField(DateFormat format) {
        this.setDateFormat(format);
    }

    @Override
    protected void initializeStyle() {
        super.initializeStyle();
        this.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_DEFAULT});
    }

    @Override
    protected String toString(Calendar value) {
        DateFormat format = this.getDateFormat();
        if (format != null) {
            try {
                return format.format(value.getTime());
            }
            catch (Exception e) {
                CommonUtils.ignoreException((Exception)e);
            }
        }
        return super.toString(value);
    }

    @Override
    protected Calendar fromString(String text) {
        DateFormat format = this.getDateFormat();
        if (format != null) {
            try {
                Calendar cal = Calendar.getInstance();
                cal.setTime(format.parse(text));
                return cal;
            }
            catch (ParseException e) {
                CommonUtils.ignoreException((Exception)e);
            }
        }
        return (Calendar)super.fromString(text);
    }

    @Override
    protected boolean supportFromString() {
        return this.getDateFormat() != null || super.supportFromString();
    }

    public ObjectProperty<DateFormat> dateFormatProperty() {
        if (this._dateFormatProperty == null) {
            this._dateFormatProperty = new SimpleObjectProperty<DateFormat>((Object)this, "dateFormat"){

                protected void invalidated() {
                    super.invalidated();
                    DateFormat format = (DateFormat)this.get();
                    PatternVerifierUtils.initializePatternVerifiersForDateFormatUsingCalendar(CalendarField.this.getPatternVerifiers());
                    if (format instanceof SimpleDateFormat && CalendarField.this.getPattern() == null) {
                        CalendarField.this.setPattern(((SimpleDateFormat)format).toPattern());
                    }
                    CalendarField.this.setStringConverter(null);
                }
            };
        }
        return this._dateFormatProperty;
    }

    public DateFormat getDateFormat() {
        return (DateFormat)this.dateFormatProperty().get();
    }

    public void setDateFormat(DateFormat format) {
        this.dateFormatProperty().set((Object)format);
    }

    @Override
    protected Decorator<Button> createPopupButtonDecorator() {
        return new PredefinedDecorators.AbstractButtonDecoratorSupplier(){

            public Decorator<Button> get() {
                Shape calendarIcon = PredefinedShapes.getInstance().createCalendarIcon(15.0);
                Shape shape = PredefinedShapes.getInstance().createArrowedIcon(calendarIcon);
                return new Decorator((Node)this.createButton((Node)shape), Pos.CENTER_RIGHT, new Point2D(-70.0, 0.0), new Insets(0.0, 100.0, 0.0, 0.0));
            }
        }.get();
    }

    @Override
    protected void initializeTextField() {
        super.initializeTextField();
        this.setPopupContentFactory(new Callback<Calendar, PopupContent<Calendar>>(){

            public PopupContent<Calendar> call(Calendar param) {
                CalendarPopupContent content = new CalendarPopupContent();
                content.setValue(CalendarField.this.getValue());
                return content;
            }
        });
    }

    @Override
    protected void customizePopupContent(PopupContent<Calendar> popupContent) {
        super.customizePopupContent(popupContent);
        popupContent.valueProperty().addListener((ChangeListener)new ChangeListener<Calendar>(){

            public void changed(ObservableValue<? extends Calendar> observable, Calendar oldValue, Calendar newValue) {
                CalendarField.this.hide();
            }
        });
    }

    public static CalendarField createCalendarField(String dateFormat, Calendar initialValue) {
        CalendarField field = new CalendarField(dateFormat);
        field.setValue(initialValue);
        return field;
    }

    public static CalendarField createCalendarField(Calendar initialValue) {
        CalendarField field = new CalendarField();
        field.setValue(initialValue);
        return field;
    }

    public static CalendarField createCalendarField() {
        return new CalendarField();
    }
}

