/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.BoundingBox;
import javafx.util.Callback;
import jidefx.scene.control.field.DoubleField;
import jidefx.scene.control.field.FormattedTextField;
import jidefx.scene.control.field.PopupField;
import jidefx.scene.control.field.popup.PopupContent;
import jidefx.scene.control.field.popup.ValuesPopupContent;
import jidefx.scene.control.field.verifier.NumberValuePatternVerifier;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.javafx.BoundingBoxConverter;

public class BoundingBoxField
extends PopupField<BoundingBox> {
    private static final String STYLE_CLASS_DEFAULT = "bounding-box-field";

    @Override
    protected void initializeStyle() {
        super.initializeStyle();
        this.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_DEFAULT});
    }

    @Override
    protected void initializeTextField() {
        super.initializeTextField();
        this.setPopupContentFactory(new Callback<BoundingBox, PopupContent<BoundingBox>>(){

            public PopupContent<BoundingBox> call(BoundingBox param) {
                ValuesPopupContent<BoundingBox, Double> popupContent = new ValuesPopupContent<BoundingBox, Double>(new String[]{BoundingBoxField.this.getResourceString("x"), BoundingBoxField.this.getResourceString("y"), BoundingBoxField.this.getResourceString("z"), BoundingBoxField.this.getResourceString("width"), BoundingBoxField.this.getResourceString("height"), BoundingBoxField.this.getResourceString("depth")}){

                    @Override
                    public List<Double> toValues(BoundingBox value) {
                        ArrayList<Double> list = new ArrayList<Double>(6);
                        list.add(value.getMinX());
                        list.add(value.getMinY());
                        list.add(value.getMinZ());
                        list.add(value.getWidth());
                        list.add(value.getHeight());
                        list.add(value.getDepth());
                        return list;
                    }

                    @Override
                    public BoundingBox fromValues(List<Double> values) {
                        return new BoundingBox(values.get(0).doubleValue(), values.get(1).doubleValue(), values.get(2).doubleValue(), values.get(3).doubleValue(), values.get(4).doubleValue(), values.get(5).doubleValue());
                    }

                    @Override
                    public FormattedTextField<Double> createTextField(String label) {
                        int fieldIndex = this.getFieldIndex(label);
                        if (fieldIndex == 3 || fieldIndex == 4 || fieldIndex == 5) {
                            return new DoubleField(0.0, Double.MAX_VALUE);
                        }
                        return new DoubleField();
                    }
                };
                popupContent.setValue((BoundingBox)BoundingBoxField.this.getValue());
                return popupContent;
            }
        });
    }

    @Override
    protected void initializePattern() {
        super.initializePattern();
        this.setStringConverter(new BoundingBoxConverter(){

            protected String toString(int i, Double o, ConverterContext context) {
                if (o == null) {
                    return "";
                }
                return o.toString();
            }

            protected Double fromString(int i, String s, ConverterContext context) {
                if (s == null || s.trim().isEmpty()) {
                    return null;
                }
                return Double.valueOf(s);
            }
        }.toStringConverter());
        this.getPatternVerifiers().put((Object)"X", (Object)new NumberValuePatternVerifier<BoundingBox>(){

            @Override
            public Double toTargetValue(BoundingBox fieldValue) {
                return fieldValue.getMinX();
            }

            @Override
            public BoundingBox fromTargetValue(BoundingBox previousFieldValue, Number value) {
                double x = value.doubleValue();
                return previousFieldValue != null ? new BoundingBox(x, previousFieldValue.getMinY(), previousFieldValue.getMinZ(), previousFieldValue.getWidth(), previousFieldValue.getHeight(), previousFieldValue.getDepth()) : new BoundingBox(x, 0.0, 0.0, 0.0, 0.0, 0.0);
            }
        });
        this.getPatternVerifiers().put((Object)"Y", (Object)new NumberValuePatternVerifier<BoundingBox>(){

            @Override
            public Double toTargetValue(BoundingBox fieldValue) {
                return fieldValue.getMinY();
            }

            @Override
            public BoundingBox fromTargetValue(BoundingBox previousFieldValue, Number value) {
                double y = value.doubleValue();
                return previousFieldValue != null ? new BoundingBox(previousFieldValue.getMinX(), y, previousFieldValue.getMinZ(), previousFieldValue.getWidth(), previousFieldValue.getHeight(), previousFieldValue.getDepth()) : new BoundingBox(0.0, y, 0.0, 0.0, 0.0, 0.0);
            }
        });
        this.getPatternVerifiers().put((Object)"Z", (Object)new NumberValuePatternVerifier<BoundingBox>(){

            @Override
            public Double toTargetValue(BoundingBox fieldValue) {
                return fieldValue.getMinZ();
            }

            @Override
            public BoundingBox fromTargetValue(BoundingBox previousFieldValue, Number value) {
                double z = value.doubleValue();
                return previousFieldValue != null ? new BoundingBox(previousFieldValue.getMinX(), previousFieldValue.getMinY(), z, previousFieldValue.getWidth(), previousFieldValue.getHeight(), previousFieldValue.getDepth()) : new BoundingBox(0.0, 0.0, z, 0.0, 0.0, 0.0);
            }
        });
        this.getPatternVerifiers().put((Object)"Width", (Object)new NumberValuePatternVerifier<BoundingBox>((Number)0, (Number)Double.MAX_VALUE){

            @Override
            public Double toTargetValue(BoundingBox fieldValue) {
                return fieldValue.getWidth();
            }

            @Override
            public BoundingBox fromTargetValue(BoundingBox previousFieldValue, Number value) {
                double width = value.doubleValue();
                return previousFieldValue != null ? new BoundingBox(previousFieldValue.getMinX(), previousFieldValue.getMinY(), previousFieldValue.getMinZ(), width, previousFieldValue.getHeight(), previousFieldValue.getDepth()) : new BoundingBox(0.0, 0.0, 0.0, width, 0.0, 0.0);
            }
        });
        this.getPatternVerifiers().put((Object)"Height", (Object)new NumberValuePatternVerifier<BoundingBox>((Number)0, (Number)Double.MAX_VALUE){

            @Override
            public Double toTargetValue(BoundingBox fieldValue) {
                return fieldValue.getHeight();
            }

            @Override
            public BoundingBox fromTargetValue(BoundingBox previousFieldValue, Number value) {
                double height = value.doubleValue();
                return previousFieldValue != null ? new BoundingBox(previousFieldValue.getMinX(), previousFieldValue.getMinY(), previousFieldValue.getMinZ(), previousFieldValue.getWidth(), height, previousFieldValue.getDepth()) : new BoundingBox(0.0, 0.0, 0.0, 0.0, height, 0.0);
            }
        });
        this.getPatternVerifiers().put((Object)"Depth", (Object)new NumberValuePatternVerifier<BoundingBox>((Number)0, (Number)Double.MAX_VALUE){

            @Override
            public Double toTargetValue(BoundingBox fieldValue) {
                return fieldValue.getDepth();
            }

            @Override
            public BoundingBox fromTargetValue(BoundingBox previousFieldValue, Number value) {
                double depth = value.doubleValue();
                return previousFieldValue != null ? new BoundingBox(previousFieldValue.getMinX(), previousFieldValue.getMinY(), previousFieldValue.getMinZ(), previousFieldValue.getWidth(), previousFieldValue.getHeight(), depth) : new BoundingBox(0.0, 0.0, 0.0, 0.0, 0.0, depth);
            }
        });
        this.setPattern("X; Y; Z; Width; Height; Depth");
    }
}

