/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.editor;

import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import jidefx.scene.control.editor.ComboBoxEditor;
import jidefx.scene.control.editor.EditorContext;
import jidefx.scene.control.editor.LazyInitializeEditor;

public class EnumComboBoxEditor<T extends Enum>
extends ComboBoxEditor<T>
implements LazyInitializeEditor<T> {
    private boolean initialized = false;

    public EnumComboBoxEditor() {
        this.setEditable(false);
    }

    @Override
    public void initialize(Class<T> clazz, EditorContext context) {
        super.initialize(clazz, context);
        if (Enum.class.isAssignableFrom(clazz)) {
            this.initializeEnums(clazz);
        }
    }

    private void initializeEnums(Class<T> clazz) {
        if (!this.initialized && clazz != null && clazz.isEnum()) {
            ObservableList observableList = FXCollections.observableArrayList((Object[])clazz.getEnumConstants());
            this.setItems(observableList);
            this.initialized = true;
        }
    }
}

