/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.combobox;

import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import jidefx.scene.control.combobox.FormattedComboBox;
import jidefx.scene.control.field.FormattedTextField;
import jidefx.scene.control.field.IntegerField;

public class IntegerComboBox
extends FormattedComboBox<Integer> {
    private static final String STYLE_CLASS_DEFAULT = "integer-combo-box";
    private IntegerProperty _maxProperty;
    private IntegerProperty _minProperty;

    public IntegerComboBox() {
        this(0, 100, 0);
    }

    public IntegerComboBox(int min, int max, int value) {
        super(value);
        this.setMin(min);
        this.setMax(max);
    }

    @Override
    protected void initializeStyle() {
        super.initializeStyle();
        this.getStyleClass().add((Object)STYLE_CLASS_DEFAULT);
    }

    public IntegerProperty maxProperty() {
        if (this._maxProperty == null) {
            this._maxProperty = new SimpleIntegerProperty((Object)this, "max");
        }
        return this._maxProperty;
    }

    public int getMax() {
        return this.maxProperty().get();
    }

    public void setMax(int maxValue) {
        this.maxProperty().set(maxValue);
    }

    public IntegerProperty minProperty() {
        if (this._minProperty == null) {
            this._minProperty = new SimpleIntegerProperty((Object)this, "min");
        }
        return this._minProperty;
    }

    public int getMin() {
        return this.minProperty().get();
    }

    public void setMin(int min) {
        this.minProperty().set(min);
    }

    @Override
    protected FormattedTextField<Integer> createFormattedTextField() {
        IntegerField field = new IntegerField(Integer.MIN_VALUE, Integer.MAX_VALUE);
        field.maxProperty().bind((ObservableValue)this.maxProperty());
        field.minProperty().bind((ObservableValue)this.minProperty());
        return field;
    }

    @Override
    protected void initializeComboBox() {
        super.initializeComboBox();
        this.setPopupContentFactory(((IntegerField)this.getEditor()).getPopupContentFactory());
    }
}

