/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.ResourceBundle;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.ConverterResource;
import jidefx.utils.converter.DefaultObjectConverter;

public class QuarterNameConverter
extends DefaultObjectConverter<Integer> {
    public static final ConverterContext CONTEXT = new ConverterContext("QuarterName");
    private String _quarterNamePattern;

    @Override
    public String toString(Integer qtr, ConverterContext context) {
        if (qtr == null) {
            return "";
        }
        if (qtr >= 0 && qtr < 4) {
            return MessageFormat.format(this.getQuarterNamePattern(), qtr + 1);
        }
        return "";
    }

    @Override
    public Integer fromString(String string, ConverterContext context) {
        String quarterNamePattern = this.getQuarterNamePattern();
        try {
            Object[] values = new MessageFormat(quarterNamePattern).parse(string);
            if (values.length > 0) {
                return Integer.parseInt("" + values[0]) - 1;
            }
        }
        catch (ParseException e) {
            // empty catch block
        }
        return 0;
    }

    public String getQuarterNamePattern() {
        if (this._quarterNamePattern == null) {
            return this.getResourceString("Quarter.quarter");
        }
        return this._quarterNamePattern;
    }

    public void setQuarterNamePattern(String quarterName) {
        this._quarterNamePattern = quarterName;
    }

    protected String getResourceString(String key) {
        ResourceBundle resourceBundle = ConverterResource.getResourceBundle(Locale.getDefault());
        return resourceBundle.getString(key);
    }
}

