/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.DefaultObjectConverter;

public abstract class AbstractDateConverter<T>
extends DefaultObjectConverter<T> {
    public static final ConverterContext CONTEXT_DATETIME = new ConverterContext("DateTime");
    public static final ConverterContext CONTEXT_TIME = new ConverterContext("Time");
    public static final ConverterContext CONTEXT_DATE = new ConverterContext("");
    public static final String PROPERTY_DATE_FORMAT = "DateFormat";
    private DateFormat _shortFormat = SimpleDateFormat.getDateInstance(3);
    private DateFormat _mediumFormat = SimpleDateFormat.getDateInstance(2);
    private DateFormat _longFormat = SimpleDateFormat.getDateInstance(1);
    private DateFormat _defaultFormat = SimpleDateFormat.getDateInstance(2);
    private DateFormat _shortDateTimeFormat = SimpleDateFormat.getDateTimeInstance(3, 3);
    private DateFormat _mediumDateTimeFormat = SimpleDateFormat.getDateTimeInstance(2, 2);
    private DateFormat _longDateTimeFormat = SimpleDateFormat.getDateTimeInstance(1, 1);
    private DateFormat _defaultDateTimeFormat = SimpleDateFormat.getDateTimeInstance(2, 2);
    private DateFormat _shortTimeFormat = SimpleDateFormat.getTimeInstance(3);
    private DateFormat _mediumTimeFormat = SimpleDateFormat.getTimeInstance(2);
    private DateFormat _longTimeFormat = SimpleDateFormat.getTimeInstance(1);
    private DateFormat _defaultTimeFormat = SimpleDateFormat.getTimeInstance(2);

    public synchronized String anyDateToString(Object object, ConverterContext context) {
        TimeZone timeZone;
        if (object == null) {
            return "";
        }
        if (object instanceof Calendar) {
            timeZone = ((Calendar)object).getTimeZone();
            object = ((Calendar)object).getTime();
        } else if (object instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)object);
            timeZone = cal.getTimeZone();
        } else {
            timeZone = TimeZone.getDefault();
        }
        if (object instanceof Date || object instanceof Number) {
            Object format;
            Object object2 = format = context != null ? context.getProperties().get((Object)PROPERTY_DATE_FORMAT) : null;
            if (format instanceof DateFormat) {
                return ((DateFormat)format).format(object);
            }
            if (CONTEXT_DATETIME.equals(context)) {
                this._defaultDateTimeFormat.setTimeZone(timeZone);
                return this._defaultDateTimeFormat.format(object);
            }
            if (CONTEXT_TIME.equals(context)) {
                this._defaultTimeFormat.setTimeZone(timeZone);
                return this._defaultTimeFormat.format(object);
            }
            this._defaultFormat.setTimeZone(timeZone);
            return this._defaultFormat.format(object);
        }
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public synchronized Object fromStringToDate(String string, ConverterContext context) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        try {
            Object format;
            Object object = format = context != null ? context.getProperties().get((Object)PROPERTY_DATE_FORMAT) : null;
            if (format instanceof DateFormat) {
                try {
                    return ((DateFormat)format).parse(string);
                }
                catch (ParseException e) {
                    // empty catch block
                }
            }
            if (CONTEXT_DATETIME.equals(context)) {
                return this._defaultDateTimeFormat.parse(string);
            }
            if (CONTEXT_TIME.equals(context)) {
                return this._defaultTimeFormat.parse(string);
            }
            return this._defaultFormat.parse(string);
        }
        catch (ParseException e1) {
            String[] formatStrings;
            if (CONTEXT_DATETIME.equals(context)) {
                try {
                    return this._shortDateTimeFormat.parse(string);
                }
                catch (ParseException e2) {
                    try {
                        return this._mediumDateTimeFormat.parse(string);
                    }
                    catch (ParseException e3) {
                        try {
                            return this._longDateTimeFormat.parse(string);
                        }
                        catch (ParseException e4) {
                        }
                    }
                }
            } else {
                if (CONTEXT_TIME.equals(context)) {
                    try {
                        return this._shortTimeFormat.parse(string);
                    }
                    catch (ParseException e2) {
                        try {
                            return this._mediumTimeFormat.parse(string);
                        }
                        catch (ParseException e3) {
                            try {
                                return this._longTimeFormat.parse(string);
                            }
                            catch (ParseException e4) {
                                return string;
                            }
                        }
                    }
                }
                try {
                    return this._shortFormat.parse(string);
                }
                catch (ParseException e2) {
                    try {
                        return this._mediumFormat.parse(string);
                    }
                    catch (ParseException e3) {
                        try {
                            return this._longFormat.parse(string);
                        }
                        catch (ParseException e4) {
                            // empty catch block
                        }
                    }
                }
            }
            for (String formatString : formatStrings = new String[]{"M/d/yyyy", "MM/dd/yyyy", "yyyy-MM-dd", "yy-MM-dd", "yyyyMMdd", "yyMMdd", "dd-MMM-yy", "dd-MMM-yyyy"}) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(formatString);
                    return sdf.parse(string);
                }
                catch (ParseException ex) {
                }
            }
            return null;
        }
    }

    public DateFormat getDefaultDateFormat() {
        return this._defaultFormat;
    }

    public void setDefaultDateFormat(DateFormat defaultDateFormat) {
        this._defaultFormat = defaultDateFormat;
    }

    public DateFormat getDefaultTimeFormat() {
        return this._defaultTimeFormat;
    }

    public void setDefaultTimeFormat(DateFormat defaultTimeFormat) {
        this._defaultTimeFormat = defaultTimeFormat;
    }

    public DateFormat getDefaultDateTimeFormat() {
        return this._defaultDateTimeFormat;
    }

    public void setDefaultDateTimeFormat(DateFormat defaultDateTimeFormat) {
        this._defaultDateTimeFormat = defaultDateTimeFormat;
    }
}

