/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.write;

import com.jerolba.carpet.impl.write.BigDecimalWrite;
import com.jerolba.carpet.impl.write.CarpetWriteConfiguration;
import com.jerolba.carpet.impl.write.DecimalConfig;
import com.jerolba.carpet.impl.write.EnumsValues;
import com.jerolba.carpet.impl.write.FieldTypeInspect;
import com.jerolba.carpet.impl.write.GeometryWrite;
import com.jerolba.carpet.impl.write.PrimitiveFieldWriter;
import com.jerolba.carpet.impl.write.TimeWrite;
import com.jerolba.carpet.impl.write.UuidWrite;
import com.jerolba.carpet.impl.write.VariantWriter;
import com.jerolba.carpet.impl.write.WriteRecordModelWriter;
import com.jerolba.carpet.model.BigDecimalType;
import com.jerolba.carpet.model.EnumType;
import com.jerolba.carpet.model.FieldType;
import com.jerolba.carpet.model.ToBooleanFunction;
import com.jerolba.carpet.model.ToByteFunction;
import com.jerolba.carpet.model.ToFloatFunction;
import com.jerolba.carpet.model.ToShortFunction;
import com.jerolba.carpet.model.WriteRecordModelType;
import java.time.LocalDate;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;

class ModelFieldsWriter {
    ModelFieldsWriter() {
    }

    public static BiConsumer<RecordConsumer, Object> buildSimpleElementConsumer(FieldType fieldType, RecordConsumer recordConsumer, CarpetWriteConfiguration carpetConfiguration) {
        FieldTypeInspect type = new FieldTypeInspect(fieldType);
        if (type.isInteger()) {
            return (consumer, v) -> consumer.addInteger(((Integer)v).intValue());
        }
        if (type.isString()) {
            return (consumer, v) -> consumer.addBinary(Binary.fromString((String)((String)v)));
        }
        if (type.isBoolean()) {
            return (consumer, v) -> consumer.addBoolean(((Boolean)v).booleanValue());
        }
        if (type.isLong()) {
            return (consumer, v) -> consumer.addLong(((Long)v).longValue());
        }
        if (type.isDouble()) {
            return (consumer, v) -> consumer.addDouble(((Double)v).doubleValue());
        }
        if (type.isFloat()) {
            return (consumer, v) -> consumer.addFloat(((Float)v).floatValue());
        }
        if (type.isShort() || type.isByte()) {
            return (consumer, v) -> consumer.addInteger(((Number)v).intValue());
        }
        if (type.isBinary() || type.isBinaryGeospatial()) {
            return (consumer, v) -> consumer.addBinary((Binary)v);
        }
        if (fieldType instanceof EnumType) {
            EnumType enumType = (EnumType)fieldType;
            EnumsValues enumValues = new EnumsValues(enumType.enumClass());
            return (consumer, v) -> consumer.addBinary(enumValues.getValue(v));
        }
        if (type.isUuid()) {
            return (consumer, v) -> consumer.addBinary(UuidWrite.uuidToBinary(v));
        }
        if (type.isLocalDate()) {
            return (consumer, v) -> consumer.addInteger((int)((LocalDate)v).toEpochDay());
        }
        if (type.isLocalTime()) {
            return TimeWrite.localTimeConsumer(carpetConfiguration.defaultTimeUnit());
        }
        if (type.isLocalDateTime()) {
            return TimeWrite.localDateTimeConsumer(carpetConfiguration.defaultTimeUnit());
        }
        if (type.isInstant()) {
            return TimeWrite.instantCosumer(carpetConfiguration.defaultTimeUnit());
        }
        if (type.isBigDecimal()) {
            BigDecimalType bigDecimalType = (BigDecimalType)fieldType;
            DecimalConfig config = BigDecimalWrite.buildDecimalConfig(bigDecimalType.precision(), bigDecimalType.scale(), bigDecimalType.roundingMode(), carpetConfiguration.decimalConfig());
            return new BigDecimalWrite(config)::write;
        }
        if (type.isJtsGeometry()) {
            return GeometryWrite.geometryCosumer();
        }
        if (type.isVariant()) {
            return VariantWriter.simpleVariantConsumer();
        }
        if (fieldType instanceof WriteRecordModelType) {
            WriteRecordModelType recordType = (WriteRecordModelType)fieldType;
            WriteRecordModelWriter recordWriter = new WriteRecordModelWriter(recordConsumer, recordType, carpetConfiguration);
            return (consumer, v) -> {
                consumer.startGroup();
                recordWriter.write(v);
                consumer.endGroup();
            };
        }
        return null;
    }

    public static Consumer<Object> buildPrimitiveJavaConsumer(WriteRecordModelType.PrimitiveJavaFieldInfo<?> primitiveField, int idx, RecordConsumer recordConsumer) {
        Object fieldAccessor = primitiveField.accessor();
        String parquetFieldName = primitiveField.parquetFieldName();
        FieldTypeInspect javaType = new FieldTypeInspect(primitiveField.fieldType());
        if (javaType.isBoolean()) {
            ToBooleanFunction accessor = (ToBooleanFunction)fieldAccessor;
            return new PrimitiveFieldWriter(recordConsumer, parquetFieldName, idx, (rc, obj) -> rc.addBoolean(accessor.applyAsBoolean(obj)));
        }
        if (javaType.isByte()) {
            ToByteFunction accessor = (ToByteFunction)fieldAccessor;
            return new PrimitiveFieldWriter(recordConsumer, parquetFieldName, idx, (rc, obj) -> rc.addInteger((int)accessor.applyAsByte(obj)));
        }
        if (javaType.isShort()) {
            ToShortFunction accessor = (ToShortFunction)fieldAccessor;
            return new PrimitiveFieldWriter(recordConsumer, parquetFieldName, idx, (rc, obj) -> rc.addInteger((int)accessor.applyAsShort(obj)));
        }
        if (javaType.isInteger()) {
            ToIntFunction accessor = (ToIntFunction)fieldAccessor;
            return new PrimitiveFieldWriter(recordConsumer, parquetFieldName, idx, (rc, obj) -> rc.addInteger(accessor.applyAsInt(obj)));
        }
        if (javaType.isLong()) {
            ToLongFunction accessor = (ToLongFunction)fieldAccessor;
            return new PrimitiveFieldWriter(recordConsumer, parquetFieldName, idx, (rc, obj) -> rc.addLong(accessor.applyAsLong(obj)));
        }
        if (javaType.isFloat()) {
            ToFloatFunction accessor = (ToFloatFunction)fieldAccessor;
            return new PrimitiveFieldWriter(recordConsumer, parquetFieldName, idx, (rc, obj) -> rc.addFloat(accessor.applyAsFloat(obj)));
        }
        if (javaType.isDouble()) {
            ToDoubleFunction accessor = (ToDoubleFunction)fieldAccessor;
            return new PrimitiveFieldWriter(recordConsumer, parquetFieldName, idx, (rc, obj) -> rc.addDouble(accessor.applyAsDouble(obj)));
        }
        return null;
    }
}

